/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.service.proxy;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.messaging.RemoteMessagingException;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceNotInitializedException;
import com.metamatrix.platform.service.proxy.ServiceProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultipleInvokationProxy
extends ServiceProxy {
    MultipleInvokationProxy(String serviceType) {
        super(serviceType);
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        List<ServiceRegistryBinding> serviceBindings = this.getInstances();
        boolean returnsCollection = Collection.class.isAssignableFrom(m.getReturnType());
        ArrayList result = null;
        if (returnsCollection) {
            result = new ArrayList();
        }
        int retryLimit = this.getRetryLimit();
        for (ServiceRegistryBinding serviceBinding : serviceBindings) {
            ServiceInterface service = serviceBinding.getService();
            try {
                boolean called = false;
                for (int i = 0; i <= retryLimit && !called; ++i) {
                    try {
                        try {
                            Object singleResult = m.invoke((Object)service, args);
                            if (returnsCollection && singleResult != null) {
                                result.addAll((Collection)singleResult);
                            }
                            called = true;
                            break;
                        }
                        catch (InvocationTargetException e) {
                            throw e.getTargetException();
                        }
                    }
                    catch (RemoteMessagingException e) {
                        this.logException((Throwable)((Object)e));
                        if (i >= retryLimit) continue;
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (called) continue;
                serviceBinding.markServiceAsBad();
            }
            catch (ServiceNotInitializedException snie) {
                this.logException((Throwable)((Object)snie));
            }
            catch (ServiceException sce) {
                serviceBinding.markServiceAsBad();
            }
            catch (MetaMatrixException e) {}
        }
        return result;
    }
}

