/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.service.proxy;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolFactory;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.RegistryListener;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.ServicePlugin;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.proxy.MultipleInvokationProxy;
import com.metamatrix.platform.service.proxy.RandomSelectionPolicy;
import com.metamatrix.platform.service.proxy.RoundRobinSelectionPolicy;
import com.metamatrix.platform.service.proxy.ServiceProxy;
import com.metamatrix.platform.service.proxy.ServiceSelectionPolicy;
import com.metamatrix.platform.service.proxy.ServiceSelectionPolicyKey;
import com.metamatrix.platform.service.proxy.SingleInvokationProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@Singleton
public class ProxyManager
implements RegistryListener {
    private Map<ServiceSelectionPolicyKey, ServiceSelectionPolicy> policyRegistry = new HashMap<ServiceSelectionPolicyKey, ServiceSelectionPolicy>();
    private WorkerPool updatePool = WorkerPoolFactory.newWorkerPool((String)"RegistryUpdate", (int)1, (long)60000L);
    ClusteredRegistryState registry;
    String hostName;
    String processName;

    @Inject
    public ProxyManager(@Named(value="HostName") String hostName, @Named(value="ProcessName") String processName, ClusteredRegistryState registry) {
        this.hostName = hostName;
        this.processName = processName;
        this.registry = registry;
        this.registry.addListener(this);
    }

    @Override
    public void registryChanged() {
        this.updatePool.execute(new Runnable(){

            @Override
            public void run() {
                ProxyManager.this.doUpdate();
            }
        });
    }

    public synchronized ServiceInterface findOrCreateProxy(String serviceTypeName, Properties props) {
        ServiceSelectionPolicyKey policyKey = this.createPolicyKey(serviceTypeName, props);
        ServiceSelectionPolicy policy = this.policyRegistry.get(policyKey);
        if (policy == null) {
            policy = this.createPolicy(policyKey.getPolicyType());
            this.setServiceInstances(policy, serviceTypeName);
            this.policyRegistry.put(policyKey, policy);
        }
        return ProxyManager.createProxy(serviceTypeName, props, policy);
    }

    static ServiceInterface createProxy(String serviceTypeName, Properties props, ServiceSelectionPolicy policy) {
        String proxyClassName = props.getProperty("metamatrix.core.proxy.serviceProxyClassName");
        if (proxyClassName == null) {
            throw new IllegalArgumentException(ServicePlugin.Util.getString("ERR.014.008.0049"));
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(proxyClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(ServicePlugin.Util.getString("ERR.014.008.0050", new Object[]{proxyClassName, e}));
        }
        ServiceProxy serviceProxy = null;
        if (Boolean.valueOf(props.getProperty("metamatrix.core.proxy.serviceMultipleDelegation")).booleanValue()) {
            serviceProxy = new MultipleInvokationProxy(serviceTypeName);
        } else {
            serviceProxy = new SingleInvokationProxy(serviceTypeName);
            serviceProxy.setStickyFlag(Boolean.valueOf(props.getProperty("metamatrix.core.proxy.serviceSelectionSticky")));
        }
        serviceProxy.setServiceSelectionPolicy(policy);
        return (ServiceInterface)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)serviceProxy);
    }

    public synchronized String toString() {
        Iterator<ServiceSelectionPolicyKey> itr = this.policyRegistry.keySet().iterator();
        StringBuffer s = new StringBuffer();
        s.append("(");
        s.append(this.getClass().getName() + "(" + this.policyRegistry.size() + ")");
        s.append("\n     ");
        while (itr.hasNext()) {
            s.append(((Object)itr.next()).toString());
            s.append("     ");
        }
        s.append(")");
        return s.toString();
    }

    private synchronized void doUpdate() {
        for (ServiceSelectionPolicyKey key : this.policyRegistry.keySet()) {
            this.setServiceInstances(this.policyRegistry.get(key), key.getServiceTypeName());
        }
    }

    private ServiceSelectionPolicyKey createPolicyKey(String serviceTypeName, Properties props) {
        String policyTypeName = (String)props.get("metamatrix.core.proxy.serviceSelectionPolicyName");
        if (policyTypeName == null) {
            throw new IllegalArgumentException(ServicePlugin.Util.getString("ERR.014.008.0051"));
        }
        ServiceSelectionPolicyKey key = new ServiceSelectionPolicyKey(serviceTypeName, policyTypeName);
        return key;
    }

    private ServiceSelectionPolicy createPolicy(String policy) {
        if (policy.equals("RANDOM")) {
            return new RandomSelectionPolicy(false);
        }
        if (policy.equals("RANDOM_LOCAL")) {
            return new RandomSelectionPolicy(true);
        }
        if (policy.equals("ROUND_ROBIN")) {
            return new RoundRobinSelectionPolicy(false);
        }
        if (policy.equals("ROUND_ROBIN_LOCAL")) {
            return new RoundRobinSelectionPolicy(true);
        }
        throw new IllegalArgumentException(ServicePlugin.Util.getString("ERR.014.008.0060", new Object[]{policy}));
    }

    private void setServiceInstances(ServiceSelectionPolicy policy, String serviceType) {
        List<ServiceRegistryBinding> localServiceBindings = this.registry.getActiveServiceBindings(this.hostName, this.processName, serviceType);
        List<ServiceRegistryBinding> serviceBindings = this.registry.getActiveServiceBindings(null, null, serviceType);
        serviceBindings.removeAll(localServiceBindings);
        policy.updateServices(localServiceBindings, serviceBindings);
    }
}

