/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.service.proxy;

import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.ServicePlugin;
import com.metamatrix.platform.service.api.exception.ServiceNotFoundException;
import com.metamatrix.platform.service.proxy.ServiceSelectionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class RandomSelectionPolicy
implements ServiceSelectionPolicy {
    private boolean preferLocal = false;
    private Random randomizer = new Random();
    List<ServiceRegistryBinding> localServices;
    List<ServiceRegistryBinding> remoteServices;

    public RandomSelectionPolicy(boolean preferLocal) {
        this.preferLocal = preferLocal;
    }

    @Override
    public synchronized List<ServiceRegistryBinding> getInstances() throws ServiceNotFoundException {
        ArrayList<ServiceRegistryBinding> allServices = new ArrayList<ServiceRegistryBinding>(this.localServices);
        allServices.addAll(this.remoteServices);
        Collections.shuffle(allServices);
        if (allServices.isEmpty()) {
            throw new ServiceNotFoundException("ERR.014.008.0053", ServicePlugin.Util.getString("ERR.014.008.0053", new Object[]{this.getClass().getSimpleName()}));
        }
        return allServices;
    }

    @Override
    public synchronized ServiceRegistryBinding getNextInstance() throws ServiceNotFoundException {
        int index;
        ServiceRegistryBinding serviceBinding = null;
        List<ServiceRegistryBinding> allServices = this.remoteServices;
        if (this.preferLocal) {
            if (this.localServices != null && !this.localServices.isEmpty()) {
                index = this.randomizer.nextInt(this.localServices.size());
                serviceBinding = this.localServices.get(index);
            }
        } else {
            allServices = new ArrayList<ServiceRegistryBinding>(this.localServices);
            allServices.addAll(this.remoteServices);
        }
        if (serviceBinding == null && allServices != null && !allServices.isEmpty()) {
            index = this.randomizer.nextInt(allServices.size());
            serviceBinding = allServices.get(index);
        }
        if (serviceBinding == null) {
            throw new ServiceNotFoundException("ERR.014.008.0053", ServicePlugin.Util.getString("ERR.014.008.0053", new Object[]{this.getClass().getSimpleName()}));
        }
        return serviceBinding;
    }

    @Override
    public void updateServices(List<ServiceRegistryBinding> localServices, List<ServiceRegistryBinding> remoteServices) {
        this.localServices = new ArrayList<ServiceRegistryBinding>(localServices);
        this.remoteServices = new ArrayList<ServiceRegistryBinding>(remoteServices);
    }
}

