/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.service.proxy;

import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.ServicePlugin;
import com.metamatrix.platform.service.api.exception.ServiceNotFoundException;
import com.metamatrix.platform.service.proxy.ServiceSelectionPolicy;
import java.util.ArrayList;
import java.util.List;

public class RoundRobinSelectionPolicy
implements ServiceSelectionPolicy {
    private boolean preferLocal = false;
    List<ServiceRegistryBinding> localServices;
    List<ServiceRegistryBinding> remoteServices;
    private int localCurrentIndex = 0;
    private int currentIndex = 0;

    public RoundRobinSelectionPolicy(boolean preferLocal) {
        this.preferLocal = preferLocal;
    }

    @Override
    public synchronized ServiceRegistryBinding getNextInstance() throws ServiceNotFoundException {
        ServiceRegistryBinding serviceBinding = null;
        List<ServiceRegistryBinding> allServices = this.remoteServices;
        if (this.preferLocal) {
            if (this.localServices != null && !this.localServices.isEmpty()) {
                this.localCurrentIndex = (this.localCurrentIndex + 1) % this.localServices.size();
                serviceBinding = this.localServices.get(this.localCurrentIndex);
            }
        } else {
            allServices = new ArrayList<ServiceRegistryBinding>(this.localServices);
            allServices.addAll(this.remoteServices);
        }
        if (serviceBinding == null && allServices != null && !allServices.isEmpty()) {
            this.currentIndex = (this.currentIndex + 1) % allServices.size();
            serviceBinding = allServices.get(this.currentIndex);
        }
        if (serviceBinding == null) {
            throw new ServiceNotFoundException("ERR.014.008.0053", ServicePlugin.Util.getString("ERR.014.008.0053", new Object[]{this.getClass().getSimpleName()}));
        }
        return serviceBinding;
    }

    public synchronized List getInstances() throws ServiceNotFoundException {
        ArrayList<ServiceRegistryBinding> newList = new ArrayList<ServiceRegistryBinding>();
        List<ServiceRegistryBinding> allServices = this.remoteServices;
        if (this.preferLocal) {
            if (!this.localServices.isEmpty()) {
                this.localCurrentIndex = (this.localCurrentIndex + 1) % this.localServices.size();
                newList.addAll(this.localServices.subList(this.localCurrentIndex, this.localServices.size()));
                newList.addAll(this.localServices.subList(0, this.localCurrentIndex));
            }
        } else {
            allServices = new ArrayList<ServiceRegistryBinding>(this.localServices);
            allServices.addAll(this.remoteServices);
        }
        if (allServices != null && !allServices.isEmpty()) {
            this.currentIndex = (this.currentIndex + 1) % allServices.size();
            newList.addAll(allServices.subList(this.currentIndex, allServices.size()));
            newList.addAll(allServices.subList(0, this.currentIndex));
        }
        if (newList.isEmpty()) {
            throw new ServiceNotFoundException("ERR.014.008.0053", ServicePlugin.Util.getString("ERR.014.008.0053", new Object[]{this.getClass().getSimpleName()}));
        }
        return newList;
    }

    @Override
    public void updateServices(List<ServiceRegistryBinding> localServices, List<ServiceRegistryBinding> remoteServices) {
        this.localServices = new ArrayList<ServiceRegistryBinding>(localServices);
        this.remoteServices = new ArrayList<ServiceRegistryBinding>(remoteServices);
        this.localCurrentIndex = 0;
        this.currentIndex = 0;
    }
}

