/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.service.proxy;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.ServicePlugin;
import com.metamatrix.platform.service.api.exception.ServiceNotFoundException;
import com.metamatrix.platform.service.proxy.ServiceSelectionPolicy;
import java.lang.reflect.InvocationHandler;
import java.util.List;

public abstract class ServiceProxy
implements InvocationHandler {
    private static final int DEFAULT_RETRY_LIMIT = 1;
    private int retryLimit = 1;
    protected static final int MAX_RETRY_DELAY_VAL = 250;
    private String serviceType;
    private ServiceSelectionPolicy serviceSelectionPolicy;
    private boolean sticky = false;

    public ServiceProxy(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceSelectionPolicy(ServiceSelectionPolicy policy) {
        this.serviceSelectionPolicy = policy;
    }

    protected ServiceRegistryBinding getNextInstance() throws ServiceNotFoundException {
        try {
            return this.serviceSelectionPolicy.getNextInstance();
        }
        catch (ServiceNotFoundException e) {
            String msg = ServicePlugin.Util.getString("ERR.014.008.0054", new Object[]{this.getServiceType()});
            throw new ServiceNotFoundException((Throwable)((Object)e), "ERR.014.008.0054", msg);
        }
    }

    protected List<ServiceRegistryBinding> getInstances() throws ServiceNotFoundException {
        try {
            return this.serviceSelectionPolicy.getInstances();
        }
        catch (ServiceNotFoundException e) {
            throw new ServiceNotFoundException((Throwable)((Object)e), "ERR.014.008.0054", ServicePlugin.Util.getString("ERR.014.008.0054", new Object[]{this.getServiceType()}));
        }
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    protected final void logException(Throwable e) {
        LogManager.logError((String)"PROXY", (Throwable)e, (String)this.getClass().getName());
    }

    public boolean getStickyFlag() {
        return this.sticky;
    }

    public void setStickyFlag(boolean sticky) {
        this.sticky = sticky;
    }
}

