/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.util;

import com.google.inject.Inject;
import com.metamatrix.platform.config.api.service.ConfigurationServiceInterface;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.proxy.ProxyManager;
import com.metamatrix.server.connector.service.ConnectorServiceInterface;
import com.metamatrix.server.query.service.QueryServiceInterface;
import java.util.Properties;

public class PlatformProxyHelper {
    @Inject
    static ProxyManager proxy;
    public static final String RANDOM = "RANDOM";
    public static final String ROUND_ROBIN = "ROUND_ROBIN";
    public static final String ROUND_ROBIN_LOCAL = "ROUND_ROBIN_LOCAL";
    public static final String RANDOM_LOCAL = "RANDOM_LOCAL";
    public static final String SESSION_SERVICE_PROXY_CLASS;
    public static final String AUTHORIZATION_SERVICE_PROXY_CLASS;
    public static final String MEMBERSHIP_SERVICE_PROXY_CLASS;
    public static final String CONFIGURATION_SERVICE_PROXY_CLASS;
    public static final String QUERY_SERVICE_PROXY_CLASS;
    public static final String CONNECTOR_SERVICE_PROXY_CLASS;

    public static final SessionServiceInterface getSessionServiceProxy(String policyType) throws ServiceException {
        Properties props = new Properties();
        props.put("metamatrix.core.proxy.serviceProxyClassName", SESSION_SERVICE_PROXY_CLASS);
        props.put("metamatrix.core.proxy.serviceSelectionPolicyName", policyType);
        return (SessionServiceInterface)proxy.findOrCreateProxy("SessionService", props);
    }

    public static final AuthorizationServiceInterface getAuthorizationServiceProxy(String policyType) throws ServiceException {
        Properties props = new Properties();
        props.put("metamatrix.core.proxy.serviceProxyClassName", AUTHORIZATION_SERVICE_PROXY_CLASS);
        props.put("metamatrix.core.proxy.serviceSelectionPolicyName", policyType);
        return (AuthorizationServiceInterface)proxy.findOrCreateProxy("AuthorizationService", props);
    }

    public static final MembershipServiceInterface getMembershipServiceProxy(String policyType) throws ServiceException {
        Properties props = new Properties();
        props.put("metamatrix.core.proxy.serviceProxyClassName", MEMBERSHIP_SERVICE_PROXY_CLASS);
        props.put("metamatrix.core.proxy.serviceSelectionPolicyName", policyType);
        return (MembershipServiceInterface)proxy.findOrCreateProxy("MembershipService", props);
    }

    public static final ConfigurationServiceInterface getConfigurationServiceProxy(String policyType) throws ServiceException {
        Properties props = new Properties();
        props.put("metamatrix.core.proxy.serviceProxyClassName", CONFIGURATION_SERVICE_PROXY_CLASS);
        props.put("metamatrix.core.proxy.serviceSelectionPolicyName", policyType);
        return (ConfigurationServiceInterface)proxy.findOrCreateProxy("ConfigurationService", props);
    }

    public static final QueryServiceInterface getQueryServiceProxy(String policyType) throws ServiceException {
        Properties props = new Properties();
        props.put("metamatrix.core.proxy.serviceProxyClassName", QUERY_SERVICE_PROXY_CLASS);
        props.put("metamatrix.core.proxy.serviceSelectionPolicyName", policyType);
        props.put("metamatrix.core.proxy.serviceMultipleDelegation", Boolean.TRUE.toString());
        return (QueryServiceInterface)proxy.findOrCreateProxy("QueryService", props);
    }

    public static final ConnectorServiceInterface getConnectorServiceProxy(String routingID, String policyType) throws ServiceException {
        Properties props = new Properties();
        props.put("metamatrix.core.proxy.serviceProxyClassName", CONNECTOR_SERVICE_PROXY_CLASS);
        props.put("metamatrix.core.proxy.serviceSelectionPolicyName", policyType);
        props.put("metamatrix.core.proxy.serviceSelectionSticky", Boolean.TRUE.toString());
        return (ConnectorServiceInterface)proxy.findOrCreateProxy(routingID, props);
    }

    static {
        SESSION_SERVICE_PROXY_CLASS = SessionServiceInterface.class.getName();
        AUTHORIZATION_SERVICE_PROXY_CLASS = AuthorizationServiceInterface.class.getName();
        MEMBERSHIP_SERVICE_PROXY_CLASS = MembershipServiceInterface.class.getName();
        CONFIGURATION_SERVICE_PROXY_CLASS = ConfigurationServiceInterface.class.getName();
        QUERY_SERVICE_PROXY_CLASS = QueryServiceInterface.class.getName();
        CONNECTOR_SERVICE_PROXY_CLASS = ConnectorServiceInterface.class.getName();
    }
}

