/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.vm.controller;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.admin.util.AdminMethodRoleResolver;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MultipleException;
import com.metamatrix.common.classloader.URLFilteringClassLoader;
import com.metamatrix.common.comm.ClientServiceRegistry;
import com.metamatrix.common.comm.platform.socket.server.AdminAuthorizationInterceptor;
import com.metamatrix.common.comm.platform.socket.server.LogonImpl;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.extensionmodule.protocol.URLFactory;
import com.metamatrix.common.id.dbid.DBIDGenerator;
import com.metamatrix.common.id.dbid.DBIDGeneratorException;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolFactory;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.ZipFileUtil;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.api.AuthorizationAdminAPI;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import com.metamatrix.platform.admin.api.ExtensionSourceAdminAPI;
import com.metamatrix.platform.admin.api.MembershipAdminAPI;
import com.metamatrix.platform.admin.api.RuntimeStateAdminAPI;
import com.metamatrix.platform.admin.api.SessionAdminAPI;
import com.metamatrix.platform.admin.apiimpl.AdminHelper;
import com.metamatrix.platform.admin.apiimpl.AuthorizationAdminAPIImpl;
import com.metamatrix.platform.admin.apiimpl.ConfigurationAdminAPIImpl;
import com.metamatrix.platform.admin.apiimpl.ExtensionSourceAdminAPIImpl;
import com.metamatrix.platform.admin.apiimpl.MembershipAdminAPIImpl;
import com.metamatrix.platform.admin.apiimpl.RuntimeStateAdminAPIImpl;
import com.metamatrix.platform.admin.apiimpl.SessionAdminAPIImpl;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.platform.registry.ResourceNotBoundException;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.platform.vm.api.controller.ProcessManagement;
import com.metamatrix.platform.vm.controller.ProcessStatistics;
import com.metamatrix.platform.vm.controller.ServerEvents;
import com.metamatrix.platform.vm.controller.SocketListenerStats;
import com.metamatrix.server.HostManagement;
import com.metamatrix.server.ResourceFinder;
import com.metamatrix.server.admin.api.QueryAdminAPI;
import com.metamatrix.server.admin.api.RuntimeMetadataAdminAPI;
import com.metamatrix.server.admin.api.TransactionAdminAPI;
import com.metamatrix.server.admin.apiimpl.QueryAdminAPIImpl;
import com.metamatrix.server.admin.apiimpl.RuntimeMetadataAdminAPIImpl;
import com.metamatrix.server.admin.apiimpl.TransactionAdminAPIImpl;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class ProcessController
implements ProcessManagement {
    public static final String STARTER_MAX_THREADS = "vm.starter.maxThreads";
    public static final String STARTER_TIMETOLIVE = "vm.starter.timetolive";
    public static final String SERVICE_MONITOR_INTERVAL = "metamatrix.server.serviceMonitorInterval";
    private static final String STOP_DELAY_TIME = "metamatrix.vm.stop.delay.sec";
    private static final int DEFAULT_FORCE_SHUTDOWN_TIME = 30;
    public static final int DEFAULT_STARTER_MAX_THREADS = 15;
    public static final int DEFAULT_STARTER_TIMETOLIVE = 15000;
    protected Host host;
    protected String processName;
    private Date startTime;
    private Properties vmProps;
    VMComponentDefn vmComponentDefn;
    private boolean shuttingDown = false;
    private WorkerPool startServicePool;
    protected ClusteredRegistryState registry;
    private MessageBus messageBus;
    ServerEvents events;
    protected ClientServiceRegistry clientServices;
    private Map<ComponentTypeID, Properties> defaultPropertiesCache = new HashMap<ComponentTypeID, Properties>();
    private Properties hostProperties;
    private int force_shutdown_time = 30;

    public ProcessController(Host host, String processname, ClusteredRegistryState registry, ServerEvents serverEvents, MessageBus bus, HostManagement hostManagement) throws Exception {
        this.host = host;
        this.processName = processname;
        this.registry = registry;
        this.events = serverEvents;
        this.messageBus = bus;
        Properties configProps = CurrentConfiguration.getInstance().getProperties();
        int maxThreads = PropertiesUtils.getIntProperty((Properties)configProps, (String)STARTER_MAX_THREADS, (int)15);
        int timeToLive = PropertiesUtils.getIntProperty((Properties)configProps, (String)STARTER_TIMETOLIVE, (int)15000);
        this.startServicePool = WorkerPoolFactory.newWorkerPool((String)"StartServiceQueue", (int)maxThreads, (long)timeToLive);
        this.initVMProperties(host.getFullName(), processname);
        this.startTime = new Date();
        this.clientServices = new ClientServiceRegistry();
        RuntimeMetadataCatalog.getInstance().init(CurrentConfiguration.getInstance().getProperties(), ResourceFinder.getMessageBus(), ResourceFinder.getCacheFactory());
        this.registerILogonAPI();
        this.registerAdmin(hostManagement);
        this.registerSubSystemAdminAPIs(hostManagement);
        this.addShutdownHook();
    }

    private void registerSubSystemAdminAPIs(HostManagement hostManagement) throws MetaMatrixComponentException {
        this.clientServices.registerClientService(ConfigurationAdminAPI.class, (Object)ConfigurationAdminAPIImpl.getInstance(this.registry), "CONFIGURATION_ADMIN_API");
        this.clientServices.registerClientService(RuntimeStateAdminAPI.class, (Object)RuntimeStateAdminAPIImpl.getInstance(this.registry, hostManagement), "RUNTIME_STATE_ADMIN_API");
        this.clientServices.registerClientService(MembershipAdminAPI.class, (Object)MembershipAdminAPIImpl.getInstance(), "ADMIN_API");
        this.clientServices.registerClientService(SessionAdminAPI.class, (Object)SessionAdminAPIImpl.getInstance(), "ADMIN_API");
        this.clientServices.registerClientService(AuthorizationAdminAPI.class, (Object)AuthorizationAdminAPIImpl.getInstance(), "AUTHORIZATION_ADMIN_API");
        this.clientServices.registerClientService(ExtensionSourceAdminAPI.class, (Object)ExtensionSourceAdminAPIImpl.getInstance(), "ADMIN_API");
        this.clientServices.registerClientService(QueryAdminAPI.class, (Object)QueryAdminAPIImpl.getInstance(), "ADMIN_API");
        this.clientServices.registerClientService(RuntimeMetadataAdminAPI.class, (Object)RuntimeMetadataAdminAPIImpl.getInstance(), "RUNTIME_METADATA_ADMIN_API");
        this.clientServices.registerClientService(TransactionAdminAPI.class, (Object)TransactionAdminAPIImpl.getInstance(), "ADMIN_API");
    }

    private void registerAdmin(HostManagement hostManagement) throws AdminException {
        ServerAdminImpl serverAdminImpl = new ServerAdminImpl(this.registry, hostManagement);
        AdminMethodRoleResolver adminMethodRoleResolver = new AdminMethodRoleResolver();
        adminMethodRoleResolver.init();
        ServerAdmin roleCheckedServerAdmin = (ServerAdmin)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ServerAdmin.class}, (InvocationHandler)new AdminAuthorizationInterceptor(new AdminHelper(), adminMethodRoleResolver, serverAdminImpl));
        this.clientServices.registerClientService(ServerAdmin.class, (Object)roleCheckedServerAdmin, "ADMIN");
    }

    private void registerILogonAPI() throws ConfigurationException, ServiceException {
        this.clientServices.registerClientService(ILogon.class, (Object)new LogonImpl(PlatformProxyHelper.getSessionServiceProxy("ROUND_ROBIN_LOCAL"), CurrentConfiguration.getInstance().getClusterName()), "LOGON");
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    ProcessController.this.shutdown(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    ConfigurationModelContainer getConfigurationModel() throws ConfigurationException {
        return CurrentConfiguration.getInstance().getConfigurationModel();
    }

    private void initVMProperties(String hostname, String processName) throws Exception {
        ConfigurationModelContainer config = this.getConfigurationModel();
        VMComponentDefn deployedVM = config.getConfiguration().getVMForHost(hostname, processName);
        if (deployedVM != null) {
            this.vmComponentDefn = deployedVM;
            this.vmProps = config.getDefaultPropertyValues(deployedVM.getComponentTypeID());
            Properties props = config.getConfiguration().getAllPropertiesForComponent(deployedVM.getID());
            this.vmProps.putAll((Map<?, ?>)props);
            this.force_shutdown_time = PropertiesUtils.getIntProperty((Properties)System.getProperties(), (String)STOP_DELAY_TIME, (int)30);
            if (30 == this.force_shutdown_time) {
                this.force_shutdown_time = PropertiesUtils.getIntProperty((Properties)this.vmProps, (String)"vm.forced.shutdown.time", (int)30);
            }
            Properties allProps = new Properties();
            allProps.putAll((Map<?, ?>)System.getProperties());
            allProps.putAll((Map<?, ?>)config.getConfiguration().getProperties());
            allProps.putAll((Map<?, ?>)this.host.getProperties());
            allProps.putAll((Map<?, ?>)props);
            System.setProperties(allProps);
            this.logMessage(PlatformPlugin.Util.getString("VMController.VM_Force_Shutdown_Time", new Object[]{this.force_shutdown_time}));
            ProcessRegistryBinding binding = new ProcessRegistryBinding(this.host.getFullName(), this.processName, deployedVM, this, this.messageBus);
            this.events.processAdded(binding);
        }
    }

    protected void logMessage(String s) {
        LogManager.logInfo((String)"CONTROLLER", (String)s);
    }

    @Override
    public void start() {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0013"));
        VMComponentDefnID vmComponentDefnID = (VMComponentDefnID)this.vmComponentDefn.getID();
        try {
            ConfigurationModelContainer configuration = this.getConfigurationModel();
            Collection deployedServices = configuration.getConfiguration().getDeployedServicesForVM(this.vmComponentDefn);
            this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0014", new Object[]{new Integer(deployedServices.size()), vmComponentDefnID.getName()}));
            ArrayList<DeployedComponent> essentialServices = new ArrayList<DeployedComponent>();
            ArrayList<DeployedComponent> otherServices = new ArrayList<DeployedComponent>();
            for (DeployedComponent depComp : deployedServices) {
                ServiceComponentDefn scd = (ServiceComponentDefn)depComp.getDeployedComponentDefn(configuration.getConfiguration());
                if (scd.isEssential()) {
                    essentialServices.add(depComp);
                    continue;
                }
                otherServices.add(depComp);
            }
            boolean errored = false;
            for (DeployedComponent depComp : essentialServices) {
                try {
                    this.startDeployedService(depComp, null, configuration, true);
                }
                catch (Exception e) {
                    errored = true;
                }
            }
            if (errored) {
                return;
            }
            for (DeployedComponent depComp : otherServices) {
                try {
                    this.startDeployedService(depComp, null, configuration, false);
                }
                catch (Exception e) {}
            }
            this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0016", new Object[]{new Integer(deployedServices.size()), vmComponentDefnID.getName()}));
        }
        catch (ConfigurationException e) {
            this.logException(e, PlatformPlugin.Util.getString("MSG.014.010.0017", new Object[]{vmComponentDefnID.getName(), this.host.getID().getName()}));
        }
    }

    @Override
    public void startService(ServiceID serviceID) {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0018", new Object[]{serviceID}));
        ServiceRegistryBinding binding = null;
        try {
            binding = this.registry.getServiceBinding(serviceID.getHostName(), serviceID.getProcessName(), serviceID);
        }
        catch (ResourceNotBoundException e) {
            String msg = PlatformPlugin.Util.getString("MSG.014.010.0019", new Object[]{serviceID});
            throw new ServiceException((Throwable)((Object)e), msg);
        }
        catch (Exception e) {
            String msg = PlatformPlugin.Util.getString("MSG.014.010.0020", new Object[]{serviceID});
            throw new ServiceException(e, msg);
        }
        if (!binding.isServiceBad()) {
            throw new ServiceException(PlatformPlugin.Util.getString("MSG.014.010.0021", new Object[]{serviceID}));
        }
        try {
            ConfigurationModelContainer configuration = this.getConfigurationModel();
            this.startDeployedService(binding.getDeployedComponent(), serviceID, configuration, true);
        }
        catch (Exception e) {
            throw new ServiceException(e, PlatformPlugin.Util.getString("MSG.014.010.0022", new Object[]{serviceID}));
        }
    }

    @Override
    public void startDeployedService(ServiceComponentDefnID id) {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0023", new Object[]{id}));
        this.startDeployedService(id, null);
    }

    private void startDeployedService(ServiceComponentDefnID defnID, ServiceID serviceID) {
        try {
            ConfigurationModelContainer configuration = this.getConfigurationModel();
            VMComponentDefnID vmComponentDefnID = (VMComponentDefnID)this.vmComponentDefn.getID();
            DeployedComponent deployedService = configuration.getConfiguration().getDeployedServiceForVM(defnID, vmComponentDefnID, (HostID)this.getConfigHost().getID());
            this.startDeployedService(deployedService, serviceID, configuration, true);
        }
        catch (Exception e) {
            String msg = PlatformPlugin.Util.getString("MSG.014.010.0024", new Object[]{defnID});
            throw new ServiceException(e, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDeployedService(DeployedComponent deployedService, ServiceID serviceID, ConfigurationModelContainer configModel, boolean synch) throws ConfigurationException {
        Properties defaultProps = null;
        ProcessController processController = this;
        synchronized (processController) {
            defaultProps = this.defaultPropertiesCache.get(deployedService.getComponentTypeID());
            if (defaultProps == null) {
                if (this.hostProperties == null) {
                    this.hostProperties = CurrentConfiguration.getInstance().getSystemBootStrapProperties();
                    this.hostProperties = new Properties(this.hostProperties);
                    PropertiesUtils.putAll((Properties)this.hostProperties, (Properties)this.host.getProperties());
                }
                defaultProps = new Properties(this.hostProperties);
                defaultProps.putAll((Map<?, ?>)configModel.getDefaultPropertyValues(deployedService.getComponentTypeID()));
                this.defaultPropertiesCache.put(deployedService.getComponentTypeID(), defaultProps);
            }
        }
        Properties serviceProps = new Properties(defaultProps);
        Properties props = configModel.getConfiguration().getAllPropertiesForComponent(deployedService.getID());
        serviceProps.putAll((Map<?, ?>)props);
        PropertiesUtils.setOverrideProperies((Properties)serviceProps, (Properties)this.hostProperties);
        ProductServiceConfigID pscID = deployedService.getProductServiceConfigID();
        String serviceClassName = serviceProps.getProperty("ServiceClassName");
        if (serviceClassName != null && serviceClassName.length() > 0) {
            this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0025", new Object[]{deployedService.getServiceComponentDefnID().getName(), this.processName, this.host.getID().getName()}));
            serviceProps.put("InstanceName", deployedService.getName());
            serviceProps.put("ServiceName", deployedService.getServiceComponentDefnID().getName());
            serviceProps.put("ComponentTypeName", deployedService.getComponentTypeID().getFullName());
            if (!deployedService.isDeployedConnector()) {
                serviceProps.put("ServiceRoutingID", deployedService.getComponentTypeID().getFullName());
            } else {
                ServiceComponentDefn scd = (ServiceComponentDefn)deployedService.getDeployedComponentDefn(configModel.getConfiguration());
                String routingID = scd.getRoutingUUID();
                serviceProps.put("ServiceRoutingID", routingID);
            }
        } else {
            String msg = PlatformPlugin.Util.getString("MSG.014.010.0026", new Object[]{"ServiceClassName", deployedService.getServiceComponentDefnID().getName(), this.processName, this.host.getID().getName()});
            throw new ServiceException(msg);
        }
        this.startService(this.clientServices, serviceClassName, serviceID, deployedService, pscID, serviceProps, synch);
    }

    @Override
    public synchronized void shutdown(boolean now) {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0041"));
        try {
            this.stopServices(now, true);
        }
        catch (MultipleException e) {
            this.logException(e, e.getMessage());
        }
        catch (ServiceException e) {
            this.logException((Throwable)((Object)e), e.getMessage());
        }
        JDBCConnectionPoolHelper.getInstance().shutDown();
        this.events.processRemoved(this.host.getFullName(), this.processName);
        this.shuttingDown = true;
        this.notifyAll();
        this.startServicePool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(ProcessController.this.force_shutdown_time * 1000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(1);
            }
        });
    }

    @Override
    public void stopService(ServiceID id, boolean now, boolean shutdown) {
        try {
            this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0035", new Object[]{id}));
            this.validateServiceID(id);
            ServiceRegistryBinding binding = this.registry.getServiceBinding(id.getHostName(), id.getProcessName(), id);
            this.stopService(binding, now, shutdown);
        }
        catch (ResourceNotBoundException e) {
            throw new ServiceException((Throwable)((Object)e));
        }
    }

    @Override
    public void setCurrentLogConfiguration(LogConfiguration logConfiguration) {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0046", new Object[]{logConfiguration}));
        LogManager.setLogConfiguration((LogConfiguration)logConfiguration);
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    public Host getConfigHost() {
        return this.host;
    }

    @Override
    public void ping() {
    }

    @Override
    public synchronized boolean isShuttingDown() {
        return this.shuttingDown;
    }

    @Override
    public ProcessStatistics getVMStatistics() {
        ThreadGroup tg;
        ProcessStatistics vmStats = new ProcessStatistics();
        Runtime rt = Runtime.getRuntime();
        vmStats.freeMemory = rt.freeMemory();
        vmStats.totalMemory = rt.totalMemory();
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while ((tg = root.getParent()) != null) {
            root = tg;
        }
        vmStats.threadCount = root.activeCount();
        vmStats.name = this.processName;
        vmStats.processPoolStats = this.getProcessPoolStats();
        vmStats.socketListenerStats = this.getSocketListenerStats();
        return vmStats;
    }

    @Override
    public void dumpThreads() {
        ThreadGroup tg;
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while ((tg = root.getParent()) != null) {
            root = tg;
        }
        this.listThreads(root, 0);
    }

    private void listThreads(ThreadGroup tg, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("    ");
        }
        System.out.println(tg);
        ++indent;
        int cnt = tg.activeCount();
        Thread[] threads = new Thread[cnt];
        tg.enumerate(threads, false);
        for (int i = 0; i < cnt; ++i) {
            if (threads[i] == null) continue;
            for (int j = 0; j < indent; ++j) {
                System.out.print("    ");
            }
            System.out.println(threads[i]);
        }
        cnt = tg.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[cnt];
        tg.enumerate(groups);
        for (int i = 0; i < cnt; ++i) {
            this.listThreads(groups[i], indent);
        }
    }

    private void validateServiceID(ServiceID serviceID) {
        if (!serviceID.getHostName().equalsIgnoreCase(this.host.getFullName()) || !serviceID.getProcessName().equalsIgnoreCase(this.processName)) {
            throw new ServiceException(PlatformPlugin.Util.getString("MSG.014.010.0047", new Object[]{serviceID, this.host.getFullName(), this.processName}));
        }
    }

    @Override
    public byte[] exportLogs() {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("logs", ".zip");
            tmpFile.deleteOnExit();
            String mainLogDirectory = this.host.getLogDirectory();
            ZipFileUtil.addAll((File)tmpFile, (String)mainLogDirectory, (String)"log");
            String hostLogDirectory = this.host.getProperty("metamatrix.host.dir") + File.separator + "log";
            ZipFileUtil.addAll((File)tmpFile, (String)hostLogDirectory, (String)("hosts_" + this.host.getName() + "_log"));
            String servletLogDirectory = this.host.getProperty("metamatrix.host.dir") + File.separator + "servletengine" + File.separator + "logs";
            ZipFileUtil.addAll((File)tmpFile, (String)servletLogDirectory, (String)("hosts_" + this.host.getName() + "_servletengine_log"));
            byte[] byArray = new FileUtil(tmpFile.getAbsolutePath()).readBytes();
            return byArray;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        finally {
            try {
                tmpFile.delete();
            }
            catch (Exception e) {}
        }
    }

    protected abstract SocketListenerStats getSocketListenerStats();

    protected abstract WorkerPoolStats getProcessPoolStats();

    private void startService(final ClientServiceRegistry clientServiceRegistry, final String serviceClassName, final ServiceID serviceID, final DeployedComponent deployedComponent, final ProductServiceConfigID pscID, final Properties serviceProps, boolean synch) {
        if (!synch) {
            this.startServicePool.execute(new Runnable(){

                @Override
                public void run() {
                    ProcessController.this.startService(clientServiceRegistry, serviceID, deployedComponent, serviceClassName, pscID, serviceProps);
                }
            });
        } else {
            try {
                this.startService(clientServiceRegistry, serviceID, deployedComponent, serviceClassName, pscID, serviceProps);
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
        }
    }

    private void startService(ClientServiceRegistry serverListenerRegistry, ServiceID serviceID, DeployedComponent deployedComponent, String serviceClass, ProductServiceConfigID pscID, Properties serviceProps) {
        String serviceInstanceName = null;
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String extensionClasspath = CurrentConfiguration.getInstance().getProperties().getProperty("metamatrix.extension.CommonClasspath");
            if (extensionClasspath != null && extensionClasspath.length() > 0) {
                try {
                    URLFilteringClassLoader commonExtensionClassLoader = new URLFilteringClassLoader(URLFactory.parseURLs(extensionClasspath, ";"), currentClassLoader);
                    Thread.currentThread().setContextClassLoader((ClassLoader)commonExtensionClassLoader);
                    this.logMessage(PlatformPlugin.Util.getString("commonextensionspath_in_use", new Object[]{extensionClasspath, serviceID}));
                }
                catch (MalformedURLException e) {
                    this.logMessage(PlatformPlugin.Util.getString("commonextensionspath_not_in_use", new Object[]{extensionClasspath, serviceID}));
                }
            }
            if (serviceID == null) {
                serviceID = this.createServiceID();
            }
            serviceInstanceName = serviceProps.getProperty("InstanceName");
            String componentType = serviceProps.getProperty("ComponentTypeName");
            String serviceType = serviceProps.getProperty("ServiceName");
            String routingID = serviceProps.getProperty("ServiceRoutingID");
            String essentialStr = serviceProps.getProperty("metamatrix.service.essentialservice");
            boolean essential = false;
            if (essentialStr != null && essentialStr.trim().length() != 0) {
                essential = Boolean.valueOf(essentialStr);
            }
            ServiceInterface service = (ServiceInterface)Thread.currentThread().getContextClassLoader().loadClass(serviceClass).newInstance();
            ServiceRegistryBinding binding = new ServiceRegistryBinding(serviceID, service, routingID, serviceInstanceName, componentType, serviceInstanceName, this.host.getFullName(), deployedComponent, pscID, service.getCurrentState(), service.getStateChangeTime(), essential, this.messageBus);
            this.logMessage(PlatformPlugin.Util.getString("ServiceController.0", new Object[]{serviceInstanceName}));
            this.events.serviceAdded(binding);
            Object[] param1 = new Object[]{serviceID};
            DeployedComponentID deployedComponentID = (DeployedComponentID)deployedComponent.getID();
            this.logMessage(PlatformPlugin.Util.getString("ServiceController.1", param1));
            binding.getService().init(serviceID, deployedComponentID, serviceProps, serverListenerRegistry);
            this.logMessage(PlatformPlugin.Util.getString("ServiceController.2", param1));
            this.logMessage(PlatformPlugin.Util.getString("ServiceController.3", param1));
            this.logMessage(PlatformPlugin.Util.getString("MSG.014.008.0009", new Object[]{serviceType, serviceInstanceName}));
        }
        catch (Exception e) {
            throw new ServiceException(e, PlatformPlugin.Util.getString("ERR.014.008.0028", new Object[]{serviceInstanceName}));
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private void stopServices(boolean now, boolean shutdown) throws MultipleException {
        MultipleException multipleException = new MultipleException();
        List<ServiceRegistryBinding> bindings = this.registry.getServiceBindings(this.host.getFullName(), this.processName);
        for (ServiceRegistryBinding binding : bindings) {
            try {
                this.stopService(binding, now, shutdown);
            }
            catch (ServiceException se) {
                multipleException.getExceptions().add(se);
            }
        }
        int numExceptions = multipleException.getExceptions().size();
        if (numExceptions == 1) {
            throw (ServiceException)((Object)multipleException.getExceptions().get(0));
        }
        if (numExceptions > 1) {
            throw multipleException;
        }
    }

    private synchronized void stopService(ServiceRegistryBinding binding, boolean now, boolean shutdown) {
        int currentState;
        ServiceInterface service = null;
        if (!shutdown && !this.canServiceBeShutdown(binding)) {
            throw new ServiceException("ERR.014.008.0017", PlatformPlugin.Util.getString("ERR.014.008.0017", new Object[]{binding.getServiceID()}));
        }
        try {
            service = binding.getService();
            if (service == null) {
                return;
            }
            currentState = binding.getCurrentState();
        }
        catch (Exception e) {
            throw new ServiceException(e, "ERR.014.008.0018", PlatformPlugin.Util.getString("ERR.014.008.0018", new Object[]{binding.getServiceID()}));
        }
        if (currentState != 4 && currentState != 2) {
            if (!now) {
                service.die();
            } else {
                service.dieNow();
            }
        }
        if (shutdown) {
            this.events.serviceRemoved(binding.getServiceID());
        } else {
            this.events.serviceUpdated(binding);
        }
    }

    @Override
    public void checkService(ServiceID serviceID) {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0054", new Object[]{serviceID}));
        this.validateServiceID(serviceID);
        ServiceInterface service = null;
        int currentState = 0;
        try {
            ServiceRegistryBinding binding = this.registry.getServiceBinding(serviceID.getHostName(), serviceID.getProcessName(), serviceID);
            service = binding.getService();
            if (service == null) {
                return;
            }
            currentState = binding.getCurrentState();
        }
        catch (Exception e) {
            this.logException(e, PlatformPlugin.Util.getString("ERR.014.008.0068", new Object[]{serviceID}));
            return;
        }
        try {
            if (currentState == 1 || currentState == 6) {
                service.checkState();
            }
        }
        catch (ServiceException e) {
            this.logException((Throwable)((Object)e), PlatformPlugin.Util.getString("ERR.014.008.0068", new Object[]{serviceID}));
        }
    }

    protected Properties getProperties() {
        return this.vmProps;
    }

    protected boolean isStarted() {
        boolean servicesStarted = false;
        List<ServiceRegistryBinding> authServices = this.registry.getActiveServiceBindings(null, null, "AuthorizationService");
        List<ServiceRegistryBinding> sessionServices = this.registry.getActiveServiceBindings(null, null, "SessionService");
        List<ServiceRegistryBinding> membershipServices = this.registry.getActiveServiceBindings(null, null, "MembershipService");
        List<ServiceRegistryBinding> configurationServices = this.registry.getActiveServiceBindings(null, null, "ConfigurationService");
        if (authServices.size() > 0 && sessionServices.size() > 0 && membershipServices.size() > 0 && configurationServices.size() > 0) {
            servicesStarted = true;
        }
        return servicesStarted;
    }

    private ServiceID createServiceID() {
        try {
            return new ServiceID(DBIDGenerator.getInstance().getID("Service"), this.host.getFullName(), this.processName);
        }
        catch (DBIDGeneratorException e) {
            throw new ServiceException((Throwable)((Object)e), "ERR.014.008.0025", PlatformPlugin.Util.getString("ERR.014.008.0025"));
        }
    }

    private boolean canServiceBeShutdown(ServiceRegistryBinding binding) {
        boolean shutdown = true;
        try {
            List<ServiceRegistryBinding> services;
            if (binding.isEssential() && (services = this.registry.getActiveServiceBindings(null, null, binding.getServiceType())).size() < 2) {
                shutdown = false;
            }
        }
        catch (Exception e) {
            this.logException(e, PlatformPlugin.Util.getString("ERR.014.008.0026", new Object[]{binding.getServiceID()}));
        }
        return shutdown;
    }

    private void logException(Throwable e, String msg) {
        LogManager.logError((String)"SERVICE_CONTROLLER", (Throwable)e, (String)msg);
    }

    @Override
    public InetAddress getAddress() {
        return VMNaming.getHostAddress();
    }

    @Override
    public String getName() {
        return this.processName;
    }
}

