/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.metamatrix.server.ChannelProvider;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jgroups.Channel;

@Singleton
class CacheProvider
implements Provider<Cache> {
    @Inject
    ChannelProvider channelProvider;
    @Inject
    @Named(value="ClusterName")
    String channelName;

    CacheProvider() {
    }

    public Cache get() {
        Channel channel = this.channelProvider.get(ChannelProvider.ChannelID.CACHE);
        Cache cache = new DefaultCacheFactory().createCache("jboss-cache-configuration.xml", false);
        Configuration config = cache.getConfiguration();
        config.getRuntimeConfig().setChannel(channel);
        config.setClusterName(this.channelName);
        if (channel.isConnected()) {
            channel.disconnect();
        }
        return cache;
    }
}

