/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.util.HashMap;
import java.util.Map;
import org.jgroups.Channel;
import org.jgroups.mux.Multiplexer;

@Singleton
public class ChannelProvider {
    @Inject
    Multiplexer mux;
    private Map<ChannelID, Channel> channelMap = new HashMap<ChannelID, Channel>();

    public Channel get(ChannelID id) {
        Channel c = this.channelMap.get((Object)id);
        if (c == null) {
            try {
                c = this.mux.createMuxChannel(id.toString(), "teiid");
                this.channelMap.put(id, c);
            }
            catch (Exception e) {
                throw new MetaMatrixRuntimeException("Failed to create a Channel");
            }
        }
        return c;
    }

    public static enum ChannelID {
        CACHE,
        RPC;

    }
}

