/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.log.FileLimitSizeLogWriter;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.internal.core.log.PlatformLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;

public class FileLogListenerProvider
implements Provider<LogListener> {
    @Inject
    @Named(value="LogFile")
    String logFile;
    @Inject
    @Named(value="LogDir")
    String path;

    public LogListener get() {
        PlatformLog log = new PlatformLog();
        try {
            FileLimitSizeLogWriter flw = this.buildFileLogger();
            log.addListener((LogListener)flw);
        }
        catch (FileNotFoundException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        return log;
    }

    FileLimitSizeLogWriter buildFileLogger() throws FileNotFoundException {
        File tmpFile = new File(this.path, this.logFile);
        tmpFile.getParentFile().mkdirs();
        if (tmpFile.exists()) {
            int index = this.logFile.lastIndexOf(".");
            String archiveName = FileLimitSizeLogWriter.buildArchiveFileName((String)this.logFile.substring(0, index), (String)this.logFile.substring(index));
            tmpFile.renameTo(new File(this.path, archiveName));
        }
        FileOutputStream fos = new FileOutputStream(tmpFile);
        PrintStream ps = new PrintStream(fos);
        System.setOut(ps);
        System.setErr(ps);
        Properties logProps = new Properties();
        Properties configProps = CurrentConfiguration.getInstance().getProperties();
        if (configProps.containsKey("metamatrix.log.size.limit.kbs")) {
            logProps.setProperty("metamatrix.log.size.limit.kbs", configProps.getProperty("metamatrix.log.size.limit.kbs"));
        }
        if (configProps.containsKey("metamatrix.log.size.monitor.mins")) {
            logProps.setProperty("metamatrix.log.size.monitor.mins", configProps.getProperty("metamatrix.log.size.monitor.mins"));
        }
        FileLimitSizeLogWriter flw = new FileLimitSizeLogWriter(tmpFile, logProps, false);
        return flw;
    }
}

