/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.StartupStateController;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.dqp.ResourceFinder;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.HostControllerRegistryBinding;
import com.metamatrix.platform.registry.HostMonitor;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.server.HostControllerGuiceModule;
import com.metamatrix.server.HostManagement;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@Singleton
public class HostController
implements HostManagement {
    private static final String DEFAULT_JAVA_MAIN = "com.metamatrix.server.Main";
    private Host host;
    private Map processMap = new HashMap(3);
    private ClusteredRegistryState registry;
    private HostMonitor monitor;
    private MessageBus messageBus;

    @Inject
    public HostController(@Named(value="Host") Host host, ClusteredRegistryState registry, HostMonitor hostMonitor, MessageBus bus) throws Exception {
        this.host = host;
        this.registry = registry;
        this.monitor = hostMonitor;
        this.messageBus = bus;
    }

    public void run(boolean startProcesses) throws Throwable {
        if (this.isHostRunning()) {
            System.err.println(PlatformPlugin.Util.getString("HostController.Host_is_already_running_startprocesses", new Object[]{this.host.getFullName()}));
            System.exit(-1);
        }
        StartupStateController.performSystemInitialization((boolean)true);
        this.createTempDirectories();
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        this.monitor.hostAdded(new HostControllerRegistryBinding(this.host.getFullName(), this.host.getProperties(), this, this.messageBus));
        if (startProcesses) {
            try {
                this.startServers(this.host.getFullName());
            }
            catch (Throwable e) {
                LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)e.getMessage());
                this.shutdown(this.host.getFullName());
            }
        }
    }

    private void shutdown(boolean killHostController, boolean killProcesses) {
        if (this.isHostRunning()) {
            HostControllerRegistryBinding prevHost = this.getRunningHost();
            try {
                if (killHostController) {
                    prevHost.getHostController().shutdown(prevHost.getHostName());
                } else if (killProcesses) {
                    prevHost.getHostController().killServers(prevHost.getHostName(), false);
                }
            }
            catch (MetaMatrixComponentException e) {}
        } else {
            System.err.println("Did not find previous instance of host controller to shutdown");
        }
        System.exit(-2);
    }

    private boolean isHostRunning() {
        List<HostControllerRegistryBinding> hosts = this.registry.getHosts();
        for (HostControllerRegistryBinding host : hosts) {
            if (!host.getHostName().equalsIgnoreCase(this.host.getFullName())) continue;
            return true;
        }
        return false;
    }

    private HostControllerRegistryBinding getRunningHost() {
        List<HostControllerRegistryBinding> hosts = this.registry.getHosts();
        for (HostControllerRegistryBinding host : hosts) {
            if (!host.getHostName().equalsIgnoreCase(this.host.getFullName())) continue;
            return host;
        }
        return null;
    }

    private void createTempDirectories() {
        String dataDir;
        File dataF;
        String temp_dir = this.host.getTempDirectory();
        File tempDir = new File(temp_dir);
        if (tempDir.exists()) {
            FileUtils.removeDirectoryAndChildren((File)tempDir);
        }
        if ((dataF = new File(dataDir = this.host.getDataDirectory())).exists()) {
            FileUtils.removeDirectoryAndChildren((File)dataF);
            dataF.mkdirs();
        }
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
    }

    private void startVM(VMComponentDefn deployedVM, String hostname, ConfigurationModelContainer currentConfig) {
        Properties vmPropsAndConfigProps = new Properties();
        Properties props = currentConfig.getDefaultPropertyValues(deployedVM.getComponentTypeID());
        Properties vmProps = currentConfig.getConfiguration().getAllPropertiesForComponent(deployedVM.getID());
        vmPropsAndConfigProps.putAll((Map<?, ?>)props);
        vmPropsAndConfigProps.putAll((Map<?, ?>)this.host.getProperties());
        vmPropsAndConfigProps.putAll((Map<?, ?>)vmProps);
        String processName = deployedVM.getID().getName();
        String name = processName.toUpperCase();
        if (this.processMap.containsKey(name)) {
            LogManager.logInfo((String)"CONTROLLER", (String)PlatformPlugin.Util.getString("MSG.014.005.0011", new Object[]{processName}));
            try {
                this.killServer(hostname, processName, true);
            }
            catch (MetaMatrixComponentException e) {
                LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)e.getMessage());
            }
        }
        if (deployedVM.isEnabled()) {
            this.processMap.put(name, this.startDeployVM(processName, hostname, vmPropsAndConfigProps));
        } else {
            LogManager.logInfo((String)"CONTROLLER", (String)PlatformPlugin.Util.getString("HostController.VM_is_not_enabled_to_start", new Object[]{processName}));
        }
    }

    private static void printUsage() {
        String msg = "java com.metamatrix.platform.host.HostController [-config hostName] [-noprocesses] [-shutdown] [-help]\nWhere:\n                  -help\n                  -config hostName indicates specific host configuration to use\n                  -noprocesses indicates to not start the processes\n                  -shutdown shutdown the host controller and processes";
        System.out.println(msg);
    }

    public static void main(String[] args) {
        boolean startProcesses = true;
        boolean shutdown = false;
        boolean killHostController = false;
        int parmIndex = args.length;
        for (int i = 0; i < parmIndex; ++i) {
            String command = args[i];
            if (command.equalsIgnoreCase("-noprocesses")) {
                startProcesses = false;
                continue;
            }
            if (command.equalsIgnoreCase("-help")) {
                HostController.printUsage();
                System.exit(-1);
                continue;
            }
            if (command.equalsIgnoreCase("killHostController")) {
                shutdown = true;
                killHostController = true;
                continue;
            }
            if (!command.equalsIgnoreCase("killHost")) continue;
            shutdown = true;
            killHostController = false;
        }
        String logMsg = "startserver ";
        for (int i = 0; i < args.length; ++i) {
            logMsg = logMsg + args[i] + " ";
        }
        try {
            LogManager.logInfo((String)"CONTROLLER", (String)logMsg);
            Host host = null;
            try {
                host = CurrentConfiguration.getInstance().getDefaultHost();
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
            if (host == null) {
                LogManager.logError((String)"CONTROLLER", (String)("ERROR " + PlatformPlugin.Util.getString("ERR.014.005.0001")));
                System.exit(-1);
            }
            VMNaming.setup((String)host.getFullName(), (String)host.getHostAddress(), (String)host.getBindAddress());
            HostController hostController = HostController.loadHostcontroller(host);
            if (!shutdown) {
                hostController.run(startProcesses);
                Thread.sleep(Integer.MAX_VALUE);
            } else {
                hostController.shutdown(killHostController, true);
            }
        }
        catch (Throwable e) {
            LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)("ERROR " + PlatformPlugin.Util.getString("ERR.014.005.0011")));
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static HostController loadHostcontroller(Host host) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new HostControllerGuiceModule(host)});
        ResourceFinder.setInjector((Injector)injector);
        return (HostController)injector.getInstance(HostController.class);
    }

    private Process startDeployVM(String processName, String hostName, Properties vmprops) {
        LogManager.logInfo((String)"CONTROLLER", (String)("Start deploy VM = " + processName + " on host = " + hostName));
        String command = this.buildVMCommand(processName, vmprops);
        return this.execCommand(command);
    }

    private String buildVMCommand(String processName, Properties vmprops) {
        String java = null;
        String java_home = System.getProperty("java.home");
        java = java_home != null ? java_home + "/bin/java" : "java";
        String java_opts = vmprops.getProperty("vm.starter.cmd.java_opts", "");
        java_opts = java_opts + " -Dcom.sun.management.jmxremote " + System.getProperty("vm.starter.cmd.java_opts", "");
        java = this.replaceToken(java, vmprops);
        java_opts = this.replaceToken(java_opts, vmprops);
        String cmd = java + " " + java_opts + " " + DEFAULT_JAVA_MAIN + " " + processName;
        return cmd;
    }

    private String replaceToken(String value, Properties props) {
        String rtn = value;
        int startidx;
        while ((startidx = rtn.indexOf("${")) != -1) {
            int endidx = rtn.indexOf("}");
            if (endidx < startidx) {
                return rtn;
            }
            String tokenprop = rtn.substring(startidx + 2, endidx);
            String tokenvalue = props.getProperty(tokenprop).trim();
            StringBuffer buf = new StringBuffer(rtn);
            rtn = buf.replace(startidx, endidx + 1, tokenvalue).toString();
        }
        return rtn;
    }

    private Process execCommand(String cmd) {
        Runtime rt = Runtime.getRuntime();
        Process process = null;
        try {
            LogManager.logInfo((String)"CONTROLLER", (String)PlatformPlugin.Util.getString("MSG.014.010.0049", new Object[]{cmd}));
            process = rt.exec(cmd);
            LogManager.logInfo((String)"CONTROLLER", (String)PlatformPlugin.Util.getString("MSG.014.010.0050"));
        }
        catch (Exception e) {
            LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)PlatformPlugin.Util.getString("MSG.014.010.0051", new Object[]{cmd}));
        }
        return process;
    }

    @Override
    public void killServer(String hostName, String processName, boolean stopNow) throws MetaMatrixComponentException {
        if (this.isRootHost(hostName)) {
            Process process;
            LogManager.logInfo((String)"CONTROLLER", (String)("KillVM " + processName));
            List<ProcessRegistryBinding> vms = this.registry.getVMs(null);
            for (ProcessRegistryBinding vm : vms) {
                if (!vm.getHostName().equalsIgnoreCase(this.host.getFullName()) || !vm.getProcessName().equalsIgnoreCase(processName)) continue;
                try {
                    vm.getProcessController().shutdown(stopNow);
                }
                catch (Exception e) {}
                break;
            }
            if ((process = (Process)this.processMap.get(processName.toUpperCase())) != null) {
                this.processMap.remove(processName.toUpperCase());
                process.destroy();
            }
        } else {
            HostManagement remoteHost = this.getRemoteHost(hostName);
            if (remoteHost != null) {
                remoteHost.killServer(hostName, processName, stopNow);
            } else {
                throw new MetaMatrixComponentException("HostController for host = " + hostName + " can not be reached");
            }
        }
    }

    @Override
    public void killServers(String hostName, boolean stopNow) throws MetaMatrixComponentException {
        if (this.isRootHost(hostName)) {
            LogManager.logInfo((String)"CONTROLLER", (String)"KillAllVMs");
            HashMap copyMap = new HashMap();
            copyMap.putAll(this.processMap);
            for (String processName : copyMap.keySet()) {
                this.killServer(hostName, processName, stopNow);
            }
            this.processMap.clear();
        } else {
            HostManagement remoteHost = this.getRemoteHost(hostName);
            if (remoteHost != null) {
                remoteHost.killServers(hostName, stopNow);
            } else {
                throw new MetaMatrixComponentException("HostController for host = " + hostName + " can not be reached");
            }
        }
    }

    private HostManagement getRemoteHost(String hostName) {
        HostControllerRegistryBinding hostBinding = this.registry.getHost(hostName);
        if (hostBinding != null) {
            return hostBinding.getHostController();
        }
        return null;
    }

    private boolean isRootHost(String hostName) {
        return this.host.getFullName().equalsIgnoreCase(hostName);
    }

    @Override
    public boolean ping(String hostName) {
        if (this.isRootHost(hostName)) {
            return true;
        }
        HostManagement remoteHost = this.getRemoteHost(hostName);
        if (remoteHost != null) {
            return remoteHost.ping(hostName);
        }
        return false;
    }

    @Override
    public boolean pingServer(String hostName, String processName) {
        return true;
    }

    @Override
    public void shutdown(String hostName) throws MetaMatrixComponentException {
        if (this.isRootHost(hostName)) {
            try {
                this.killServers(this.host.getFullName(), true);
            }
            catch (MetaMatrixComponentException e) {
                LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)e.getMessage());
            }
            this.monitor.hostRemoved(this.host.getFullName());
            System.exit(0);
        } else {
            HostManagement remoteHost = this.getRemoteHost(hostName);
            if (remoteHost != null) {
                remoteHost.shutdown(hostName);
            } else {
                throw new MetaMatrixComponentException("HostController for host = " + hostName + " can not be reached");
            }
        }
    }

    @Override
    public void shutdownCluster() throws MetaMatrixComponentException {
        List<HostControllerRegistryBinding> allhostss = this.registry.getHosts();
        for (HostControllerRegistryBinding mhost : allhostss) {
            try {
                mhost.getHostController().shutdown(mhost.getHostName());
            }
            catch (MetaMatrixComponentException e) {
                LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)("Failed to shutdown servers on " + mhost.getHostName()));
            }
        }
    }

    @Override
    public void startServer(String hostName, String processName) throws MetaMatrixComponentException {
        if (this.isRootHost(hostName)) {
            try {
                LogManager.logInfo((String)"CONTROLLER", (String)("StartVM " + processName));
                CurrentConfiguration.getInstance().verifyBootstrapProperties();
                ConfigurationModelContainer currentConfig = CurrentConfiguration.getInstance().getConfigurationModel();
                VMComponentDefn deployedVM = currentConfig.getConfiguration().getVMForHost(this.host.getFullName(), processName);
                if (deployedVM != null) {
                    this.startVM(deployedVM, this.host.getFullName(), currentConfig);
                }
            }
            catch (ConfigurationException e) {
                LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)("Error starting the vm = " + processName));
            }
        } else {
            HostManagement remoteHost = this.getRemoteHost(hostName);
            if (remoteHost != null) {
                remoteHost.startServer(hostName, processName);
            } else {
                throw new MetaMatrixComponentException("HostController for host = " + hostName + " can not be reached");
            }
        }
    }

    @Override
    public void startServers(String hostName) throws MetaMatrixComponentException {
        block8: {
            if (this.isRootHost(hostName)) {
                try {
                    hostName = this.host.getFullName();
                    LogManager.logInfo((String)"CONTROLLER", (String)("StartAllVMs on Host " + hostName));
                    CurrentConfiguration.getInstance().verifyBootstrapProperties();
                    ConfigurationModelContainer currentConfig = CurrentConfiguration.getInstance().getConfigurationModel();
                    Collection deployedVMs = currentConfig.getConfiguration().getVMsForHost(hostName);
                    if (deployedVMs != null && deployedVMs.size() > 0) {
                        for (VMComponentDefn deployedVM : deployedVMs) {
                            this.startVM(deployedVM, hostName, currentConfig);
                        }
                        break block8;
                    }
                    String msg = "Unable to start VM's on host \"" + hostName + "\" due to the configuration has no VM's deployed to this host.";
                    LogManager.logInfo((String)"CONTROLLER", (String)msg);
                }
                catch (ConfigurationException e) {
                    LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)"Error starting the vms");
                }
            } else {
                HostManagement remoteHost = this.getRemoteHost(hostName);
                if (remoteHost != null) {
                    remoteHost.startServers(hostName);
                } else {
                    throw new MetaMatrixComponentException("HostController for host = " + hostName + " can not be reached");
                }
            }
        }
    }

    @Override
    public void bounceAllServersInCluster() {
        this.killAllServersInCluster();
        this.startAllServersInCluster();
    }

    @Override
    public void bounceServers(String hostName) throws MetaMatrixComponentException {
        if (this.isRootHost(hostName)) {
            this.killServers(hostName, false);
            this.startServers(hostName);
        } else {
            HostManagement remoteHost = this.getRemoteHost(hostName);
            if (remoteHost != null) {
                remoteHost.bounceServers(hostName);
            } else {
                throw new MetaMatrixComponentException("HostController for host = " + hostName + " can not be reached");
            }
        }
    }

    @Override
    public void killAllServersInCluster() {
        List<HostControllerRegistryBinding> allhostss = this.registry.getHosts();
        for (HostControllerRegistryBinding mhost : allhostss) {
            try {
                mhost.getHostController().killServers(mhost.getHostName(), false);
            }
            catch (MetaMatrixComponentException e) {
                LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)("Failed to start servers on " + mhost.getHostName()));
            }
        }
    }

    @Override
    public void startAllServersInCluster() {
        List<HostControllerRegistryBinding> allhostss = this.registry.getHosts();
        for (HostControllerRegistryBinding mhost : allhostss) {
            try {
                mhost.getHostController().startServers(mhost.getHostName());
            }
            catch (MetaMatrixComponentException e) {
                LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)("Failed to start servers on " + mhost.getHostName()));
            }
        }
    }

    private class ShutdownThread
    extends Thread {
        public ShutdownThread() {
            super("ShutdownTread");
        }

        @Override
        public void run() {
            try {
                HostController.this.killServers(HostController.this.host.getFullName(), true);
            }
            catch (MetaMatrixComponentException e) {
                LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)e.getMessage());
            }
        }
    }
}

