/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import com.metamatrix.cache.CacheFactory;
import com.metamatrix.cache.jboss.JBossCacheFactory;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.VMMessageBus;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.HostMonitor;
import com.metamatrix.server.CacheProvider;
import com.metamatrix.server.ChannelProvider;
import com.metamatrix.server.FileLogListenerProvider;
import com.metamatrix.server.JGroupsProvider;
import com.metamatrix.server.LogConfigurationProvider;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.jboss.cache.Cache;
import org.jgroups.mux.Multiplexer;

class HostControllerGuiceModule
extends AbstractModule {
    Host host;

    public HostControllerGuiceModule(Host host) {
        this.host = host;
    }

    protected void configure() {
        this.commonComponents();
        this.bind(LogConfiguration.class).toProvider(LogConfigurationProvider.class).in(Scopes.SINGLETON);
        this.bind(LogListener.class).toProvider(FileLogListenerProvider.class).in(Scopes.SINGLETON);
        this.binder().requestStaticInjection(new Class[]{LogManager.class});
    }

    protected void commonComponents() {
        String systemName = null;
        try {
            systemName = CurrentConfiguration.getInstance().getClusterName();
        }
        catch (ConfigurationException err) {
            systemName = "Teiid-Cluster";
        }
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"HostName")).to(this.host.getFullName());
        this.bind(Host.class).annotatedWith((Annotation)Names.named((String)"Host")).toInstance((Object)this.host);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"ClusterName")).to(systemName);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"LogFile")).to(StringUtil.replaceAll((String)this.host.getFullName(), (String)".", (String)"_") + "_hc.log");
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"LogDir")).to(this.host.getLogDirectory());
        Names.bindProperties((Binder)this.binder(), (Properties)CurrentConfiguration.getInstance().getProperties());
        this.bind(Multiplexer.class).toProvider(JGroupsProvider.class).in(Scopes.SINGLETON);
        this.bind(ChannelProvider.class).in(Scopes.SINGLETON);
        this.bind(Cache.class).toProvider(CacheProvider.class).in(Scopes.SINGLETON);
        this.bind(CacheFactory.class).to(JBossCacheFactory.class).in(Scopes.SINGLETON);
        this.bind(ClusteredRegistryState.class).in(Scopes.SINGLETON);
        this.bind(MessageBus.class).to(VMMessageBus.class).in(Scopes.SINGLETON);
        this.bind(HostMonitor.class).in(Scopes.SINGLETON);
    }
}

