/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.HostControllerRegistryBinding;
import com.metamatrix.server.HostManagement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

@Singleton
class HostManagementProvider
implements Provider<HostManagement> {
    @Inject
    ClusteredRegistryState registry;
    @Inject
    @Named(value="HostName")
    String hostName;

    HostManagementProvider() {
    }

    public HostManagement get() {
        return (HostManagement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{HostManagement.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                HostControllerRegistryBinding hostRegistry = HostManagementProvider.this.registry.getHost(HostManagementProvider.this.hostName);
                try {
                    return method.invoke((Object)hostRegistry.getHostController(), args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        });
    }
}

