/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.jgroups.ChannelException;
import org.jgroups.jmx.JChannel;
import org.jgroups.mux.Multiplexer;

@Singleton
public class JGroupsProvider
implements Provider<Multiplexer> {
    private static final String DEFAULT_UDP_MCAST_SUPPORTED = "true";
    private static final String DEFAULT_UDP_MCAST_ADDR_PREFIX = "224.";
    private static final String DEFAULT_UDP_MCAST_PORT = "5555";
    private static final String ALL_INTERFACES_ADDR = "0.0.0.0";
    private static final String DEFAULT_PING_GOSSIP_HOST = "localhost";
    private static final String DEFAULT_PING_GOSSIP_PORT = "5555";
    private static final String DEFAULT_PING_GOSSIP_REFRESH = "15000";
    private static final String DEFAULT_PING_TIMEOUT = "2000";
    private static final String DEFAULT_PING_NUM_INITIAL_MEMBERS = "3";
    private static final String DEFAULT_JGROUPS_OTHER_SETTINGS = "MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    private static final String UDP_MCAST_SUPPORTED_PROPERTY = "udp.multicast_supported";
    private static final String UDP_MCAST_MESSAGEBUS_PORT_PROPERTY = "udp.mcast_messagebus_port";
    private static final String UDP_MCAST_ADDR_PROPERTY = "udp.mcast_addr";
    private static final String PING_GOSSIP_HOST_PROPERTY = "ping.gossip_host";
    private static final String PING_GOSSIP_PORT_PROPERTY = "ping.gossip_port";
    private static final String PING_GOSSIP_REFRESH_PROPERTY = "ping.gossip_refresh";
    private static final String PING_GOSSIP_TIMEOUT_PROPERTY = "ping.gossip_timout";
    private static final String PING_GOSSIP_NUM_INITIAL_MEMBERS_PROPERTY = "ping.gossip_initialmembers";
    private static final String JGROUPS_OTHER_SETTINGS_PROPERTY = "jgroups.other.channel.settings";
    private static final String BIND_ADDRESS_PROPERTY = "jgroups.bind.address";

    public Multiplexer get() {
        try {
            org.jgroups.JChannel channel = new org.jgroups.JChannel(this.getChannelProperties());
            Multiplexer mux = new Multiplexer(channel);
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                ObjectName on = new ObjectName("Teiid:service=JChannel,name=JGroups");
                mbs.registerMBean(new JChannel(channel), on);
            }
            catch (MalformedObjectNameException e) {
                LogManager.logWarning((String)"CONFIG", (String)"Failed to register JChannel to JMX");
            }
            catch (OperationsException e) {
                LogManager.logWarning((String)"CONFIG", (String)"Failed to register JChannel to JMX");
            }
            catch (MBeanRegistrationException e) {
                LogManager.logWarning((String)"CONFIG", (String)"Failed to register JChannel to JMX");
            }
            return mux;
        }
        catch (ChannelException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    private synchronized String getChannelProperties() {
        try {
            String properties = null;
            Properties configProps = CurrentConfiguration.getInstance().getResourceProperties("JGroups");
            String udpMulticastSupported = configProps.getProperty(UDP_MCAST_SUPPORTED_PROPERTY, DEFAULT_UDP_MCAST_SUPPORTED);
            String udpMulticastPort = configProps.getProperty(UDP_MCAST_MESSAGEBUS_PORT_PROPERTY, "5555");
            String pingGossipHost = configProps.getProperty(PING_GOSSIP_HOST_PROPERTY, DEFAULT_PING_GOSSIP_HOST);
            String pingGossipPort = configProps.getProperty(PING_GOSSIP_PORT_PROPERTY, "5555");
            String pingGossipRerefresh = configProps.getProperty(PING_GOSSIP_REFRESH_PROPERTY, DEFAULT_PING_GOSSIP_REFRESH);
            String pingTimeout = configProps.getProperty(PING_GOSSIP_TIMEOUT_PROPERTY, DEFAULT_PING_TIMEOUT);
            String pingInitialMemberCount = configProps.getProperty(PING_GOSSIP_NUM_INITIAL_MEMBERS_PROPERTY, DEFAULT_PING_NUM_INITIAL_MEMBERS);
            String otherSettings = configProps.getProperty(JGROUPS_OTHER_SETTINGS_PROPERTY, DEFAULT_JGROUPS_OTHER_SETTINGS);
            String bindAddress = this.getBindAddress();
            boolean multicastOnAllInterfaces = bindAddress.equalsIgnoreCase(ALL_INTERFACES_ADDR);
            String udpMulticastAddress = configProps.getProperty(UDP_MCAST_ADDR_PROPERTY);
            if (udpMulticastAddress == null || udpMulticastAddress.length() == 0) {
                String currentAddr = VMNaming.getBindAddress();
                String lastNode = currentAddr.substring(0, currentAddr.indexOf(46));
                udpMulticastAddress = DEFAULT_UDP_MCAST_ADDR_PREFIX + lastNode;
            }
            properties = udpMulticastSupported.equalsIgnoreCase(DEFAULT_UDP_MCAST_SUPPORTED) ? (multicastOnAllInterfaces ? "UDP(mcast_addr=" + udpMulticastAddress + ";mcast_port=" + udpMulticastPort + ";ip_ttl=32;receive_on_all_interfaces=" + udpMulticastSupported.toString() + ";" + "mcast_send_buf_size=150000;mcast_recv_buf_size=80000):" + "PING(timeout=" + pingTimeout + ";num_initial_members=" + pingInitialMemberCount + "):" : "UDP(mcast_addr=" + udpMulticastAddress + ";mcast_port=" + udpMulticastPort + ";ip_ttl=32;bind_addr=" + bindAddress + ";" + "mcast_send_buf_size=150000;mcast_recv_buf_size=80000):" + "PING(timeout=" + pingTimeout + ";num_initial_members=" + pingInitialMemberCount + "):") : "UDP(ip_mcast=false;mcast_addr=" + udpMulticastAddress + ";mcast_port=" + udpMulticastPort + ";bind_addr=" + bindAddress + "):" + "PING(gossip_host=" + pingGossipHost + ";gossip_port=" + pingGossipPort + ";gossip_refresh=" + pingGossipRerefresh + ";" + "timeout=" + pingTimeout + ";num_initial_members=" + pingInitialMemberCount + "):";
            properties = properties + otherSettings;
            return properties;
        }
        catch (ConfigurationException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    private final String getBindAddress() {
        String bindAddress = System.getProperty(BIND_ADDRESS_PROPERTY);
        if (bindAddress == null) {
            bindAddress = VMNaming.getBindAddress();
        }
        if (bindAddress == null) {
            LogManager.logWarning((String)"MESSAGE_BUS", (String)"WARNING: Unable to set jgroups.bind.address, will set to 127.0.0.1");
            bindAddress = "127.0.0.1";
        }
        return bindAddress;
    }
}

