/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.core.util.ZipFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

class LogApplicationInfo
extends Thread {
    String applFileName = null;
    String logPath = null;
    String hostName;
    String processName;
    private static final String APPLICATION_PRODUCT_INFORMATION = "Product Information";

    public LogApplicationInfo(String hostName, String processName, String path, String fileName) {
        this.applFileName = fileName;
        this.logPath = path;
        this.hostName = hostName;
        this.processName = processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream is = null;
        try {
            ConfigurationModelContainer configmodel = CurrentConfiguration.getInstance().getConfigurationModel();
            VMComponentDefn deployedVM = configmodel.getConfiguration().getVMForHost(this.hostName, this.processName);
            Properties configprops = null;
            ApplicationInfo info = ApplicationInfo.getInstance();
            StringBuffer sb = new StringBuffer();
            sb.append(VMNaming.getHostInfo());
            sb.append("\n---- System Properties ----\n");
            sb.append(PropertiesUtils.prettyPrint((Properties)System.getProperties()));
            sb.append("\n---- MM Global Properties ----\n");
            sb.append(PropertiesUtils.prettyPrint((Properties)configmodel.getConfiguration().getProperties()));
            sb.append("\n---- Host Properties ----\n");
            configprops = configmodel.getHost(this.hostName).getProperties();
            sb.append(PropertiesUtils.prettyPrint((Properties)configprops));
            sb.append("\n# of Processors: " + Runtime.getRuntime().availableProcessors());
            sb.append("\nMax Avail memory: " + Runtime.getRuntime().maxMemory());
            sb.append("\nFree memory: " + Runtime.getRuntime().freeMemory());
            sb.append("\n\n---- VM Properties ----\n");
            sb.append(PropertiesUtils.prettyPrint((Properties)deployedVM.getProperties()));
            sb.append("\n---- JGroups Resource Properties ----\n");
            configprops = configmodel.getResource("JGroups").getProperties();
            sb.append(PropertiesUtils.prettyPrint((Properties)configprops));
            sb.append("\n---- WebServices Resource Properties ----\n");
            configprops = configmodel.getResource("WebServices").getProperties();
            sb.append(PropertiesUtils.prettyPrint((Properties)configprops));
            sb.append(info.getClasspathInfo());
            sb.append("\n\n---- Extension Jars Manifest Info ----\n");
            this.logManifestInfoForExtensionModules(sb);
            is = ByteArrayHelper.toInputStream((byte[])sb.toString().getBytes());
            File logFile = null;
            logFile = this.logPath == null || this.logPath.length() == 0 ? new File(this.applFileName) : new File(this.logPath, this.applFileName);
            FileUtils.write((InputStream)is, (File)logFile);
            is.close();
        }
        catch (Exception e) {
            System.err.println("Error writing application info to " + this.applFileName + ", msg: " + e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logManifestInfoForExtensionModules(StringBuffer sb) {
        Random random = new Random(System.currentTimeMillis());
        TempDirectory tempDir = null;
        try {
            tempDir = new TempDirectory(System.currentTimeMillis(), random.nextLong());
            tempDir.create();
            ExtensionModuleManager em = ExtensionModuleManager.getInstance();
            List descriptors = em.getSourceDescriptors("JAR File");
            if (descriptors != null) {
                for (ExtensionModuleDescriptor md : descriptors) {
                    Attributes manifestAttributes;
                    sb.append("\n == Jar: " + md.getName() + " ===== " + APPLICATION_PRODUCT_INFORMATION);
                    byte[] jardata = em.getSource(md.getName());
                    File f = new File(tempDir.getPath(), md.getName());
                    FileUtils.write((byte[])jardata, (File)f);
                    Manifest m = ZipFileUtil.getManifest((File)f);
                    if (m == null || (manifestAttributes = m.getAttributes(APPLICATION_PRODUCT_INFORMATION)) == null || manifestAttributes.isEmpty()) continue;
                    for (Object n : manifestAttributes.keySet()) {
                        Object v = manifestAttributes.get(n);
                        sb.append("\n");
                        sb.append("   ");
                        sb.append(n.toString());
                        sb.append(":        ");
                        sb.append(v.toString());
                    }
                    sb.append("\n");
                }
            }
        }
        catch (Exception e) {
            sb.append("**** Error: Unable to list manifest - msg: " + e.getMessage());
        }
        finally {
            if (tempDir != null) {
                tempDir.remove();
            }
        }
    }
}

