/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.log.config.BasicLogConfiguration;
import com.metamatrix.common.log.config.LogConfigurationException;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.util.LogContextsUtil;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.platform.config.event.ConfigurationChangeEvent;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

@Singleton
class LogConfigurationProvider
implements Provider<LogConfiguration> {
    private static final String LOG_CONTEXT_PROPERTY_NAME = "metamatrix.log.contexts";
    private static final String LOG_LEVEL_PROPERTY_NAME = "metamatrix.log";
    @Inject
    MessageBus messsgeBus;

    LogConfigurationProvider() {
    }

    public LogConfiguration get() {
        try {
            LogConfiguration orig = (LogConfiguration)CurrentConfiguration.getInstance().getConfiguration().getLogConfiguration().clone();
            try {
                this.messsgeBus.addListener(ConfigurationChangeEvent.class, new EventObjectListener(){

                    public void processEvent(EventObject obj) {
                        if (obj instanceof ConfigurationChangeEvent) {
                            try {
                                Configuration currentConfig = CurrentConfiguration.getInstance().getConfiguration();
                                int level = Integer.parseInt(currentConfig.getProperty(LogConfigurationProvider.LOG_LEVEL_PROPERTY_NAME));
                                String[] contexts = this.getContext();
                                BasicLogConfiguration newConfig = new BasicLogConfiguration(Arrays.asList(contexts), level);
                                if (!newConfig.equals((Object)LogManager.getLogConfigurationCopy())) {
                                    LogManager.setLogConfiguration((LogConfiguration)newConfig);
                                }
                            }
                            catch (ConfigurationException ce) {
                                LogManager.logError((String)"MESSAGE_BUS", (Throwable)ce, (String)ce.getMessage());
                            }
                        }
                    }

                    private String[] getContext() {
                        String[] result = null;
                        List discardedContexts = null;
                        String discardedContextsString = CurrentConfiguration.getInstance().getProperties().getProperty(LogConfigurationProvider.LOG_CONTEXT_PROPERTY_NAME);
                        if (discardedContextsString != null) {
                            discardedContexts = StringUtil.split((String)discardedContextsString, (String)",");
                        }
                        HashSet contextsSet = new HashSet(LogContextsUtil.ALL_CONTEXTS);
                        if (discardedContexts != null) {
                            contextsSet.removeAll(discardedContexts);
                        }
                        result = new String[contextsSet.size()];
                        result = contextsSet.toArray(result);
                        return result;
                    }
                });
            }
            catch (MessagingException e) {
                throw new MetaMatrixRuntimeException((Throwable)((Object)e));
            }
            return orig;
        }
        catch (ConfigurationException e) {
            try {
                return BasicLogConfiguration.createLogConfiguration((Properties)System.getProperties());
            }
            catch (LogConfigurationException e1) {
                throw new MetaMatrixRuntimeException((Throwable)e1);
            }
        }
    }
}

