/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.dqp.ResourceFinder;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.vm.api.controller.ProcessManagement;
import com.metamatrix.server.LogApplicationInfo;
import com.metamatrix.server.ServerGuiceModule;
import java.io.File;

public class Main {
    @Inject
    MessageBus messageBus;
    @Inject
    ProcessManagement vmController;
    @Inject
    LogListener logListener;

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: java com.metamatrix.server.Main <vm_name>");
                System.exit(1);
            }
            String processName = args[0];
            Host host = null;
            try {
                host = CurrentConfiguration.getInstance().getDefaultHost();
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
            if (host == null) {
                System.err.println(PlatformPlugin.Util.getString("SocketVMController.5"));
                System.exit(-1);
            }
            VMComponentDefn deployedVM = CurrentConfiguration.getInstance().getConfiguration().getVMForHost(host.getName(), processName);
            String bindAddress = deployedVM.getBindAddress();
            VMNaming.setProcessName((String)processName);
            VMNaming.setup((String)host.getFullName(), (String)host.getHostAddress(), (String)bindAddress);
            Main.writeInfoLog(host, processName);
            Main.createTempDirectory();
            Main main = Main.loadMain(host, processName);
            main.launchServer();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static Main loadMain(Host host, String processName) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ServerGuiceModule(host, processName)});
        ResourceFinder.setInjector((Injector)injector);
        return (Main)injector.getInstance(Main.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchServer() {
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownWork());
            this.vmController.start();
            ProcessManagement processManagement = this.vmController;
            synchronized (processManagement) {
                while (!this.vmController.isShuttingDown()) {
                    this.vmController.wait(1000L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void createTempDirectory() {
        File tf;
        if (FileUtils.TEMP_DIRECTORY != null && !(tf = new File(FileUtils.TEMP_DIRECTORY)).exists()) {
            tf.mkdirs();
        }
    }

    private static String buildPrefix(String hostName, String processName) {
        String hostFileName = StringUtil.replaceAll((String)hostName, (String)".", (String)"_");
        return hostFileName + "_" + processName;
    }

    private static void writeInfoLog(Host host, String processName) {
        LogApplicationInfo logApplInfo = new LogApplicationInfo(host.getFullName(), processName, host.getLogDirectory(), Main.buildPrefix(host.getFullName(), processName) + "_info.log");
        logApplInfo.start();
    }

    class ShutdownWork
    extends Thread {
        ShutdownWork() {
        }

        @Override
        public void run() {
            try {
                Main.this.messageBus.shutdown();
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
            ResourceFinder.getCacheFactory().destroy();
            Main.this.logListener.shutdown();
        }
    }
}

