/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import com.metamatrix.cache.CacheFactory;
import com.metamatrix.cache.jboss.JBossCacheFactory;
import com.metamatrix.common.comm.platform.socket.SocketVMController;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.VMMessageBus;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.ProcessMonitor;
import com.metamatrix.platform.service.proxy.ProxyManager;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.platform.vm.api.controller.ProcessManagement;
import com.metamatrix.platform.vm.controller.ServerEvents;
import com.metamatrix.server.CacheProvider;
import com.metamatrix.server.ChannelProvider;
import com.metamatrix.server.HostManagement;
import com.metamatrix.server.HostManagementProvider;
import com.metamatrix.server.JGroupsProvider;
import com.metamatrix.server.LogConfigurationProvider;
import com.metamatrix.server.ServerLogListernerProvider;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.jboss.cache.Cache;
import org.jgroups.mux.Multiplexer;

class ServerGuiceModule
extends AbstractModule {
    Host host;
    String processName;

    public ServerGuiceModule(Host host, String processName) {
        this.host = host;
        this.processName = processName;
    }

    protected void configure() {
        String systemName = null;
        try {
            systemName = CurrentConfiguration.getInstance().getClusterName();
        }
        catch (ConfigurationException err) {
            systemName = "Teiid-Cluster";
        }
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"HostName")).to(this.host.getFullName());
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"ProcessName")).to(this.processName);
        this.bind(Host.class).annotatedWith((Annotation)Names.named((String)"Host")).toInstance((Object)this.host);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"ClusterName")).to(systemName);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"LogFile")).to(StringUtil.replaceAll((String)this.host.getFullName(), (String)".", (String)"_") + "_" + this.processName + ".log");
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"LogDir")).to(this.host.getLogDirectory());
        Names.bindProperties((Binder)this.binder(), (Properties)CurrentConfiguration.getInstance().getProperties());
        this.bind(Multiplexer.class).toProvider(JGroupsProvider.class).in(Scopes.SINGLETON);
        this.bind(ChannelProvider.class).in(Scopes.SINGLETON);
        this.bind(Cache.class).toProvider(CacheProvider.class).in(Scopes.SINGLETON);
        this.bind(CacheFactory.class).to(JBossCacheFactory.class).in(Scopes.SINGLETON);
        this.bind(ClusteredRegistryState.class).in(Scopes.SINGLETON);
        this.bind(ProxyManager.class).in(Scopes.SINGLETON);
        this.bind(MessageBus.class).to(VMMessageBus.class).in(Scopes.SINGLETON);
        this.bind(ProcessManagement.class).to(SocketVMController.class).in(Scopes.SINGLETON);
        this.bind(ServerEvents.class).to(ProcessMonitor.class).in(Scopes.SINGLETON);
        this.bind(HostManagement.class).toProvider(HostManagementProvider.class).in(Scopes.SINGLETON);
        this.binder().requestStaticInjection(new Class[]{PlatformProxyHelper.class});
        this.bind(LogConfiguration.class).toProvider(LogConfigurationProvider.class).in(Scopes.SINGLETON);
        this.bind(LogListener.class).toProvider(ServerLogListernerProvider.class).in(Scopes.SINGLETON);
        this.binder().requestStaticInjection(new Class[]{LogManager.class});
    }
}

