/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.DbLogListener;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.log.FileLimitSizeLogWriter;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.internal.core.log.PlatformLog;
import com.metamatrix.platform.config.event.ConfigurationChangeEvent;
import com.metamatrix.server.FileLogListenerProvider;
import java.io.FileNotFoundException;
import java.util.EventObject;
import java.util.Properties;

@Singleton
class ServerLogListernerProvider
extends FileLogListenerProvider {
    public static final String LOG_DB_ENABLED = "metamatrix.log.jdbcDatabase.enabled";
    @Inject
    MessageBus messsgeBus;

    ServerLogListernerProvider() {
    }

    @Override
    public LogListener get() {
        PlatformLog log = new PlatformLog();
        try {
            FileLimitSizeLogWriter flw = this.buildFileLogger();
            log.addListener((LogListener)flw);
        }
        catch (FileNotFoundException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        final DbLogListener dbLogger = this.buildDBLogger();
        log.addListener((LogListener)dbLogger);
        try {
            this.messsgeBus.addListener(ConfigurationChangeEvent.class, new EventObjectListener(){

                public void processEvent(EventObject obj) {
                    if (obj instanceof ConfigurationChangeEvent && obj instanceof ConfigurationChangeEvent) {
                        try {
                            Configuration currentConfig = CurrentConfiguration.getInstance().getConfiguration();
                            Properties props = currentConfig.getProperties();
                            boolean enabled = PropertiesUtils.getBooleanProperty((Properties)props, (String)ServerLogListernerProvider.LOG_DB_ENABLED, (boolean)true);
                            dbLogger.enableDBLogging(enabled);
                        }
                        catch (ConfigurationException ce) {
                            LogManager.logError((String)"MESSAGE_BUS", (Throwable)ce, (String)ce.getMessage());
                        }
                    }
                }
            });
        }
        catch (MessagingException e) {
            throw new MetaMatrixRuntimeException((Throwable)((Object)e));
        }
        return log;
    }

    private DbLogListener buildDBLogger() {
        Properties currentProps = CurrentConfiguration.getInstance().getProperties();
        Properties resultsProps = PropertiesUtils.clone((Properties)currentProps, null, (boolean)true, (boolean)false);
        boolean enabled = PropertiesUtils.getBooleanProperty((Properties)resultsProps, (String)LOG_DB_ENABLED, (boolean)true);
        return new DbLogListener(resultsProps, enabled);
    }
}

