/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Named;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.dqp.ResourceFinder;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.apiimpl.RuntimeStateAdminAPIHelper;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.HostControllerRegistryBinding;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.CacheAdmin;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.vm.api.controller.ProcessManagement;
import com.metamatrix.platform.vm.controller.ProcessStatistics;
import com.metamatrix.server.HostManagement;
import com.metamatrix.server.ServiceManagerGuiceModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class ServiceManager {
    private static final int COMMAND_LIST_VMS = 0;
    private static final int COMMAND_LIST_SERVICES = 1;
    private static final int COMMAND_START_VM = 2;
    private static final int COMMAND_STOP_SERVICE = 3;
    private static final int COMMAND_STOP_VM = 4;
    private static final int COMMAND_GET_SERVICE_STATUS = 5;
    private static final int COMMAND_LIST_DEPLOYED_VMS = 6;
    private static final int COMMAND_LIST_DEPLOYED_SERVICES = 7;
    private static final int COMMAND_START_SERVER = 8;
    private static final int COMMAND_KILL_ALL_VMS = 9;
    private static final int COMMAND_LIST_DEPLOYED_HOSTS = 10;
    private static final int COMMAND_MARK_SERVICE_AS_BAD = 11;
    private static final int COMMAND_LIST_VM_PROPERTIES = 12;
    private static final int COMMAND_LIST_SERVICE_PROPERTIES = 13;
    private static final int COMMAND_SHUTDOWN_SERVER = 14;
    private static final int COMMAND_SHUTDOWN_VM = 17;
    private static final int COMMAND_START_SERVICE = 19;
    private static final int COMMAND_EXPERT_MODE_ON = 20;
    private static final int COMMAND_EXPERT_MODE_OFF = 21;
    private static final int COMMAND_GET_SERVICE_QUEUES = 22;
    private static final int COMMAND_GET_VM_STATS = 24;
    private static final int COMMAND_DUMP_THREADS = 25;
    private static final int COMMAND_SYNCH_SERVER = 26;
    private static final int COMMAND_KILL_ALL_HCS = 27;
    private static final int COMMAND_KILL_HC = 28;
    private static final int COMMAND_BOUNCE_SERVICE = 29;
    private static final int COMMAND_CLEAR_CODE_TABLE_CACHES = 30;
    private static final int COMMAND_CLEAR_PREPARED_STMT_CACHES = 31;
    private static final int COMMAND_EXIT = 33;
    private static final int COMMAND_HELP = 34;
    private static final int COMMAND_INVALID = 35;
    private static final String[] commands = new String[]{"ListProcesses", "ListServices", "StartProcess", "StopService", "StopProcess", "GetServiceStatus", "ListDeployedProcesses", "ListDeployedServices", "StartServer", "KillAllProcesses", "ListDeployedHosts", "MarkServiceAsBad", "ListProcessProps", "ListServiceProps", "ShutdownServer", "ShutdownProcess", "RestartService", "ExpertModeOn", "ExpertModeOff", "GetServiceQueues", "GetProcessStats", "DumpThreads", "Synch", "KillAllHostControllers", "KillHostController", "BounceService", "ClearCodeTableCaches", "ClearPreparedStatementCaches", "Exit", "Help"};
    private static final String[] shortCommands = new String[]{"lv", "ls", "StartProcess", "StopService", "StopProcess", "GetServiceStatus", "ListDeployedProcesses", "ListDeployedServices", "StartServer", "KillAllProcesses", "ListDeployedHosts", "MarkServiceAsBad", "ListProcessProps", "ListServiceProps", "ShutdownServer", "ShutdownProcess", "RestartService", "ExpertModeOn", "ExpertModeOff", "GetServiceQueues", "GetProcessStats", "DumpThreads", "Synch", "KillAllHCs", "KillHC", "BounceService", "ClearCodeTableCaches", "ClearPreparedStatementCaches", "Exit", "Help"};
    private static final String[] stateStrings = new String[]{"Not_Initialized", "Running", "Closed", "Failed", "Init_Failed", "Not_Registered", "Data_Source_Unavailable"};
    @Inject
    private HostManagement hostManager;
    @Inject
    private ClusteredRegistryState registry;
    @Inject
    MessageBus messageBus;
    @Inject
    @Named(value="Host")
    private Host host;
    private Configuration currentConfig = CurrentConfiguration.getInstance().getConfiguration();
    private boolean expertMode = false;

    public void run(String command, boolean exit) {
        if (!this.isHostRunning()) {
            System.out.println("HostController is not running; You can not run Service manager without HostController running!");
            System.out.println("Exiting..");
            command = "Exit";
        }
        try {
            if (command != null && command.trim().length() > 0) {
                System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0010", new Object[]{command}));
                this.processCommand(command);
                if (exit) {
                    this.processCommand("Exit");
                }
            }
            this.printUsage();
            this.startInteractiveMode();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private boolean isHostRunning() {
        List<HostControllerRegistryBinding> hosts = this.registry.getHosts();
        for (HostControllerRegistryBinding host : hosts) {
            if (!host.getHostName().equalsIgnoreCase(this.host.getFullName())) continue;
            return true;
        }
        return false;
    }

    private void startInteractiveMode() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            this.processCommand(this.readCommandLine(in));
        }
    }

    private String readCommandLine(BufferedReader in) {
        try {
            System.out.print(PlatformPlugin.Util.getString("MSG.014.008.0011") + " ");
            String line = in.readLine();
            return line;
        }
        catch (IOException e) {
            System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0012"));
            return "";
        }
    }

    private void processCommand(String commandLine) {
        int i;
        if (commandLine == null) {
            return;
        }
        List parsedCommand = StringUtil.splitPreservingQuotedSubstring((String)commandLine, (String)" \t");
        int numTokens = parsedCommand.size();
        if (numTokens == 0) {
            return;
        }
        String command = parsedCommand.get(0).toString().toLowerCase();
        int commandType = 35;
        for (i = 0; i < 35; ++i) {
            if (!command.equalsIgnoreCase(commands[i])) continue;
            commandType = i;
            break;
        }
        if (commandType == 35) {
            for (i = 0; i < 35; ++i) {
                if (!command.equalsIgnoreCase(shortCommands[i])) continue;
                commandType = i;
                break;
            }
        }
        switch (commandType) {
            case 0: {
                this.doListVMs();
                break;
            }
            case 1: {
                this.doListServices();
                break;
            }
            case 10: {
                this.doListDeployedHosts();
                break;
            }
            case 6: {
                this.doListDeployedVMs();
                break;
            }
            case 7: {
                this.doListDeployedServices();
                break;
            }
            case 2: {
                if (numTokens < 2) {
                    System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0013"));
                    break;
                }
                String processName = (String)parsedCommand.get(1);
                this.doStartVM(processName);
                break;
            }
            case 4: {
                if (numTokens < 2) {
                    System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0013"));
                    break;
                }
                String processName = (String)parsedCommand.get(1);
                this.doStopVM(processName);
                break;
            }
            case 8: {
                this.doStartServer();
                break;
            }
            case 28: {
                if (numTokens < 2) {
                    System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0014"));
                    break;
                }
                String host = (String)parsedCommand.get(1);
                this.doShutdownHC(host);
                break;
            }
            case 27: {
                this.doShutdownAllHCs();
                break;
            }
            case 9: {
                this.doKillAllVMs();
                break;
            }
            case 3: {
                ServiceID id = this.parseServiceID(parsedCommand);
                if (id == null) break;
                this.doStopService(id);
                break;
            }
            case 5: {
                ServiceID service = this.parseServiceID(parsedCommand);
                if (service == null) break;
                this.doGetServiceStatus(service);
                break;
            }
            case 11: {
                ServiceID service = this.parseServiceID(parsedCommand);
                if (service == null) break;
                this.doMarkServiceAsBad(service);
                break;
            }
            case 12: {
                if (numTokens < 2) {
                    System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0013"));
                    break;
                }
                String processName = (String)parsedCommand.get(1);
                this.doListVMProps(processName);
                break;
            }
            case 13: {
                if (numTokens < 2) {
                    System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0017"));
                    break;
                }
                String serviceName = (String)parsedCommand.get(1);
                this.doListServiceProps(serviceName);
                break;
            }
            case 17: {
                if (numTokens < 2) {
                    System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0013"));
                    break;
                }
                String processName = (String)parsedCommand.get(1);
                this.doShutdownVM(processName, false);
                break;
            }
            case 29: {
                if (numTokens < 2) {
                    System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0031"));
                    break;
                }
                String name = (String)parsedCommand.get(1);
                this.doBounceService(name);
                break;
            }
            case 14: {
                this.doShutdownServer();
                break;
            }
            case 20: {
                this.expertMode = true;
                this.printUsage();
                break;
            }
            case 21: {
                this.expertMode = false;
                this.printUsage();
                break;
            }
            case 24: {
                if (numTokens < 2) {
                    System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0013"));
                    break;
                }
                String processName = (String)parsedCommand.get(1);
                this.doGetVMStats(processName);
                break;
            }
            case 25: {
                if (numTokens < 2) {
                    System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0013"));
                    break;
                }
                String processName = (String)parsedCommand.get(1);
                this.doDumpThreads(processName);
                break;
            }
            case 22: {
                ServiceID id1 = this.parseServiceID(parsedCommand);
                if (id1 == null) break;
                String queueName = null;
                if (numTokens > 2) {
                    queueName = (String)parsedCommand.get(2);
                }
                this.doGetServiceQueues(id1, queueName);
                break;
            }
            case 26: {
                this.doSynchronize();
                break;
            }
            case 33: {
                this.doExit();
                System.exit(0);
                break;
            }
            case 35: {
                System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0018", new Object[]{commandLine}));
                break;
            }
            case 34: {
                this.printUsage();
                break;
            }
            case 30: {
                this.doClearCodeTableCaches();
                break;
            }
            case 31: {
                this.doClearPreparedStatementCaches();
                break;
            }
            case 19: {
                ServiceID id1 = this.parseServiceID(parsedCommand);
                if (id1 == null) break;
                this.doStartService(id1);
                break;
            }
        }
    }

    private ServiceID parseServiceID(List parsedCommand) {
        long value;
        if (parsedCommand.size() < 2) {
            System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0015"));
            return null;
        }
        String id = (String)parsedCommand.get(1);
        StringTokenizer st = new StringTokenizer(id, "|");
        if (st.countTokens() != 3) {
            System.out.println("Service id must be in the format <id|hostname|processname>");
            return null;
        }
        try {
            value = Long.parseLong(st.nextToken());
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0016"));
            return null;
        }
        return new ServiceID(value, st.nextToken(), st.nextToken());
    }

    public void doBounceService(String name) {
        try {
            System.out.println("Bouncing service: " + name);
            String serviceName = name.trim();
            List<ServiceRegistryBinding> bindings = this.registry.getServiceBindings(null, null);
            if (bindings.isEmpty()) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0036"));
                return;
            }
            for (ServiceRegistryBinding binding : bindings) {
                if (!binding.getInstanceName().trim().equalsIgnoreCase(serviceName)) continue;
                try {
                    System.out.println("Killing " + binding.getServiceID());
                    binding.getService().dieNow();
                }
                catch (Exception se) {
                    System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0063", new Object[]{binding.getServiceID()}));
                    se.printStackTrace();
                }
                try {
                    ProcessRegistryBinding vmBinding = this.registry.getProcessBinding(binding.getHostName(), binding.getServiceID().getProcessName());
                    if (vmBinding != null) {
                        vmBinding.getProcessController().startService(binding.getServiceID());
                        System.out.println("Starting " + binding.getServiceID());
                        continue;
                    }
                    System.out.println("VM not found in registry");
                }
                catch (Exception e) {
                    System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0064", new Object[]{binding.getServiceID()}));
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0065"));
            e.printStackTrace();
        }
    }

    private void doClearPreparedStatementCaches() {
        this.doClearCaches("PreparedPlanCache");
    }

    private void doClearCodeTableCaches() {
        this.doClearCaches("CodeTableCache");
    }

    private void doClearCaches(String type) {
        try {
            List<ServiceRegistryBinding> bindings = this.registry.getServiceBindings(null, null);
            if (bindings.isEmpty()) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0036"));
                return;
            }
            for (ServiceRegistryBinding binding : bindings) {
                try {
                    CacheAdmin admin;
                    Map caches;
                    ServiceInterface service = binding.getService();
                    if (!(service instanceof CacheAdmin) || (caches = (admin = (CacheAdmin)((Object)service)).getCaches()) == null) continue;
                    for (String cacheName : caches.keySet()) {
                        String cacheType = (String)caches.get(cacheName);
                        if (!cacheType.equals(type)) continue;
                        admin.clearCache(cacheName, null);
                    }
                }
                catch (Exception e) {
                    System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0066", new Object[]{binding.getServiceID()}));
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0035"));
            e.printStackTrace();
        }
    }

    private void printUsage() {
        if (this.expertMode) {
            ServiceManager.printExpertUsage();
        } else {
            ServiceManager.printNoviceUsage();
        }
    }

    private static void printExpertUsage() {
        System.out.println("Usage: svcmgr [-config hostname] <Command> [options]");
        System.out.println();
        System.out.println("BounceService <ServiceName>                 Stop and Start all services with name");
        System.out.println("ClearCodeTableCaches                        Clear code table caches");
        System.out.println("ClearPreparedStatementCaches                Clear prepared statement caches");
        System.out.println("DumpJNDI                                    Display contents of JNDI Registry");
        System.out.println("GetServiceQueues <ServiceID>                Display service queue stats");
        System.out.println("GetServiceStatus <ServiceID>                Get status of service");
        System.out.println("GetProcessStats <Process Name>              Displays stats for Process");
        System.out.println("DumpThreads <Process Name>                  Lists all running threads in the log file");
        System.out.println("ListDeployedHosts                           List all deployed hosts");
        System.out.println("ListDeployedServices                        Display all deployed services");
        System.out.println("ListDeployedProcesses                       List all deployed Processes");
        System.out.println("ListServices                                List all running Services");
        System.out.println("ListServiceProps <Name>                     List properties of service");
        System.out.println("ListProcessProps <Process Name>             List properties of process.");
        System.out.println("ListProcesses                               List all running Processes");
        System.out.println("KillAllHostControllers                      Kill all HC's running in the system");
        System.out.println("KillHostController <host>                   Kill HostController running on host");
        System.out.println("KillAllProcesses                            Kill all processes running in the system");
        System.out.println("MarkServiceAsBad <ServiceID>                Mark service as bad");
        System.out.println("RestartService <ServiceID>                  Restart Service");
        System.out.println("RunGC <Process Name>                        Runs garbage collector on Process");
        System.out.println("ShutdownServer                              Gracefully shutdown all processes");
        System.out.println("ShutdownService <ServiceID>                 Shutdown Service");
        System.out.println("ShutdownServiceNow <ServiceID>              Shutdown Service Now");
        System.out.println("ShutdownProcess <Process Name>              Shutdown Process");
        System.out.println("ShutdownProcessNow <Process Name>           Shutdown Process Now");
        System.out.println("StartServer                                 Start all deployed Processes");
        System.out.println("StartProcess <Process Name>                 Start deployed Process");
        System.out.println("StopService <ServiceID>                     Stop Service");
        System.out.println("StopProcess <Process Name>                  Kill Process");
        System.out.println("Synch                                       Synchronize Registries");
        System.out.println("Exit");
        System.out.println("Help");
    }

    private static void printNoviceUsage() {
        System.out.println("Usage: svcmgr [-config hostname] <Command> [options]");
        System.out.println();
        System.out.println("ClearCodeTableCaches                        Clear code table caches");
        System.out.println("ClearPreparedStatementCaches                Clear prepared statement caches");
        System.out.println("GetServiceQueues <ServiceID>                Display service queue stats");
        System.out.println("GetProcessStats <Process Name>              Displays stats for Process");
        System.out.println("KillAllHostControllers                      Kill all HC's running in the system");
        System.out.println("KillHostController <host>                   Kill HostController running on host");
        System.out.println("ListServices                                List all running Services");
        System.out.println("ListProcesses                               List all running Processes");
        System.out.println("ShutdownServer                              Gracefully shutdown all processes");
        System.out.println("ShutdownProcess <Process Name>              Shutdown Process");
        System.out.println("StartServer                                 Start all deployed processes");
        System.out.println("StartProcess <Process Name>                 Start deployed Process");
        System.out.println("Exit");
        System.out.println("Help");
    }

    private synchronized void doExit() {
        try {
            this.messageBus.shutdown();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    private void doSynchronize() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            RuntimeStateAdminAPIHelper.getInstance(this.registry, this.hostManager).synchronizeServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doGetVMStats(String processName) {
        ProcessManagement vm = this.getVMController(processName);
        if (vm != null) {
            try {
                ProcessStatistics stats = vm.getVMStatistics();
                System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0019", new Object[]{stats.name}));
                System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0020", new Object[]{stats.totalMemory}));
                System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0021", new Object[]{stats.freeMemory}));
                System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0022", new Object[]{stats.threadCount}));
            }
            catch (Exception e) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0031", new Object[]{processName}));
                e.printStackTrace();
            }
        } else {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0030", new Object[]{processName}));
        }
    }

    private void doDumpThreads(String processName) {
        ProcessManagement vm = this.getVMController(processName);
        if (vm != null) {
            try {
                System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0023"));
                vm.dumpThreads();
                System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0024", new Object[]{processName}));
            }
            catch (Exception e) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0031", new Object[]{processName}));
                e.printStackTrace();
            }
        } else {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0030", new Object[]{processName}));
        }
    }

    private ProcessManagement getVMController(String processName) {
        try {
            for (ProcessRegistryBinding vmBinding : this.registry.getVMs(null)) {
                if (!vmBinding.getProcessName().equalsIgnoreCase(processName)) continue;
                return vmBinding.getProcessController();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void doStartServer() {
        try {
            this.hostManager.startServers(this.host.getFullName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doKillAllVMs() {
        try {
            this.hostManager.killServers(this.host.getFullName(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doStartVM(String processName) {
        String host = null;
        try {
            for (VMComponentDefn vmDefn : this.getDeployedVMs()) {
                if (!vmDefn.getName().equalsIgnoreCase(processName)) continue;
                host = vmDefn.getHostID().getName();
                break;
            }
            if (host == null) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0032"));
                return;
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0033"));
            return;
        }
        try {
            this.hostManager.startServer(host, processName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doListVMProps(String processName) {
        String host = null;
        try {
            for (VMComponentDefn vmDefn : this.getDeployedVMs()) {
                if (!vmDefn.getName().equalsIgnoreCase(processName)) continue;
                host = vmDefn.getHostID().getName();
                Properties vmPropsAndConfigProps = this.currentConfig.getAllPropertiesForComponent(vmDefn.getID());
                System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0025", new Object[]{processName}));
                for (String string : vmPropsAndConfigProps.keySet()) {
                    String value = (String)vmPropsAndConfigProps.get(string);
                    System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0026", new Object[]{string, value}));
                }
            }
            if (host == null) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0032"));
                return;
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0033"));
            return;
        }
    }

    public void doListServiceProps(String serviceName) {
        try {
            for (HostID hostId : this.currentConfig.getHostIDs()) {
                for (VMComponentDefn vmDefn : this.currentConfig.getVMsForHost(hostId)) {
                    for (DeployedComponent deployedService : this.currentConfig.getDeployedServicesForVM(vmDefn)) {
                        if (!deployedService.getName().equalsIgnoreCase(serviceName)) continue;
                        Properties serviceProps = this.currentConfig.getAllPropertiesForComponent(deployedService.getID());
                        System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0027", new Object[]{deployedService.getFullName()}));
                        for (String string : serviceProps.keySet()) {
                            String value = (String)serviceProps.get(string);
                            System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0026", new Object[]{string, value}));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0033"));
            e.printStackTrace();
        }
    }

    public void doStopVM(String processName) {
        try {
            Iterator<ProcessRegistryBinding> vmIter = this.registry.getVMs(null).iterator();
            ProcessRegistryBinding vmBinding = null;
            while (vmIter.hasNext()) {
                vmBinding = vmIter.next();
                if (!vmBinding.getProcessName().equalsIgnoreCase(processName)) continue;
                this.hostManager.killServer(vmBinding.getHostName(), vmBinding.getProcessName(), false);
                break;
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0034", new Object[]{processName}));
            System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0028"));
            this.killVM(processName);
        }
    }

    private void killVM(String processName) {
        String host = null;
        try {
            for (VMComponentDefn vmDefn : this.getDeployedVMs()) {
                if (!vmDefn.getName().equalsIgnoreCase(processName)) continue;
                host = vmDefn.getHostID().getName();
                break;
            }
            if (host == null) {
                System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0029"));
                return;
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0033"));
            return;
        }
        try {
            this.hostManager.killServer(host, processName, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doShutdownVM(String processName, boolean now) {
        try {
            for (ProcessRegistryBinding vmBinding : this.registry.getVMs(null)) {
                if (!vmBinding.getProcessName().equalsIgnoreCase(processName)) continue;
                this.hostManager.killServer(vmBinding.getHostName(), processName, now);
                return;
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0034", new Object[]{processName}));
            e.printStackTrace();
        }
    }

    public void doListVMs() {
        try {
            Iterator<ProcessRegistryBinding> vmIter = this.registry.getVMs(null).iterator();
            while (vmIter.hasNext()) {
                System.out.println(vmIter.next());
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0035"));
            e.printStackTrace();
        }
    }

    public void doListServices() {
        try {
            List<ServiceRegistryBinding> services = this.registry.getServiceBindings(null, null);
            if (services.isEmpty()) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0036"));
                return;
            }
            for (ServiceRegistryBinding serviceBinding : services) {
                System.out.println(serviceBinding.getServiceID() + " " + serviceBinding.getInstanceName() + "\t" + stateStrings[serviceBinding.getCurrentState()]);
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0035"));
            e.printStackTrace();
        }
    }

    public void doListDeployedHosts() {
        try {
            for (HostID hostId : this.currentConfig.getHostIDs()) {
                System.out.println(hostId);
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0037"));
            e.printStackTrace();
        }
    }

    public void doListDeployedVMs() {
        try {
            for (VMComponentDefn vmDefn : this.getDeployedVMs()) {
                System.out.println(vmDefn);
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0038"));
        }
    }

    public List getDeployedVMs() throws Exception {
        ArrayList vms = new ArrayList();
        try {
            Collection vmDefns = this.currentConfig.getVMComponentDefns();
            vms.addAll(vmDefns);
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0033"));
            e.printStackTrace();
            throw e;
        }
        return vms;
    }

    public void doListDeployedServices() {
        try {
            for (HostID hostId : this.currentConfig.getHostIDs()) {
                for (VMComponentDefn vmDefn : this.currentConfig.getVMsForHost(hostId)) {
                    Iterator servicesIter = this.currentConfig.getDeployedServicesForVM(vmDefn).iterator();
                    while (servicesIter.hasNext()) {
                        System.out.println(servicesIter.next());
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0033"));
            e.printStackTrace();
        }
    }

    public void doStopService(ServiceID serviceID) {
        ServiceID id = null;
        try {
            id = this.getServiceID(serviceID);
            if (id == null) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0039"));
                return;
            }
            ProcessRegistryBinding vmBinding = this.registry.getProcessBinding(id.getHostName(), id.getProcessName());
            if (vmBinding != null) {
                vmBinding.getProcessController().stopService(id, false, false);
            } else {
                System.out.println("No VM found on host=" + id.getHostName() + " with process name =" + id.getProcessName());
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0015", new Object[]{id}));
            e.printStackTrace();
        }
    }

    public void doShutdownAllHCs() {
        System.out.println("Cluster is being shutdown");
        try {
            this.hostManager.shutdownCluster();
        }
        catch (MetaMatrixComponentException e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0043"));
            e.printStackTrace();
        }
    }

    public void doShutdownHC(String host) {
        try {
            System.out.println(PlatformPlugin.Util.getString("MSG.014.008.0030", new Object[]{host}));
            this.hostManager.shutdown(host);
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0040", new Object[]{host}));
            e.printStackTrace();
        }
    }

    public void doShutdownServer() {
        System.out.println("All the servers in Cluster are being shutdown");
        this.hostManager.killAllServersInCluster();
    }

    private void doGetServiceStatus(ServiceID serviceID) {
        ServiceID id = null;
        try {
            id = this.getServiceID(serviceID);
            if (id == null) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0039"));
                return;
            }
            System.out.println(this.registry.getServiceBinding(id.getHostName(), id.getProcessName(), id));
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0043"));
            e.printStackTrace();
        }
    }

    private void doGetServiceQueues(ServiceID serviceID, String queueName) {
        ServiceID id = null;
        try {
            id = this.getServiceID(serviceID);
            if (id == null) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0039"));
                return;
            }
            ServiceRegistryBinding serviceBinding = this.registry.getServiceBinding(id.getHostName(), id.getProcessName(), id);
            ServiceInterface service = null;
            if (serviceBinding != null) {
                service = serviceBinding.getService();
            }
            if (service == null) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0046", new Object[]{id}));
                return;
            }
            if (queueName == null) {
                Collection queues = service.getQueueStatistics();
                if (queues == null) {
                    System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0044"));
                    return;
                }
                for (WorkerPoolStats qs : queues) {
                    this.printQueueStats(qs);
                }
            } else {
                WorkerPoolStats qs = service.getQueueStatistics(queueName);
                if (qs == null) {
                    System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0044", new Object[]{queueName}));
                    return;
                }
                this.printQueueStats(qs);
            }
        }
        catch (NullPointerException npe) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0046", new Object[]{id}));
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0046", new Object[]{id}));
            e.printStackTrace();
        }
    }

    private void printQueueStats(WorkerPoolStats qs) {
        System.out.println(qs);
    }

    private void doStartService(ServiceID serviceID) {
        ServiceID id = null;
        try {
            id = this.getServiceID(serviceID);
            if (id == null) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0039"));
                return;
            }
            ProcessRegistryBinding vmBinding = this.registry.getProcessBinding(id.getHostName(), id.getProcessName());
            if (vmBinding != null) {
                vmBinding.getProcessController().startService(id);
            } else {
                System.out.println("No VM found on host=" + id.getHostName() + " with process name =" + id.getProcessName());
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0047"));
            e.printStackTrace();
        }
    }

    private void doMarkServiceAsBad(ServiceID serviceID) {
        ServiceID id = null;
        try {
            id = this.getServiceID(serviceID);
            if (id == null) {
                System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0039"));
                return;
            }
            ServiceRegistryBinding binding = this.registry.getServiceBinding(serviceID.getHostName(), serviceID.getProcessName(), serviceID);
            if (binding != null) {
                binding.markServiceAsBad();
            }
        }
        catch (Exception e) {
            System.out.println(PlatformPlugin.Util.getString("ERR.014.008.0047"));
            e.printStackTrace();
        }
    }

    private ServiceID getServiceID(ServiceID serviceID) {
        List<ServiceRegistryBinding> bindings = this.registry.getServiceBindings(null, null);
        for (ServiceRegistryBinding binding : bindings) {
            if (serviceID.getID() != binding.getServiceID().getID()) continue;
            return binding.getServiceID();
        }
        return null;
    }

    private static ServiceManager loadServiceManager(Host host) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ServiceManagerGuiceModule(host)});
        ResourceFinder.setInjector((Injector)injector);
        return (ServiceManager)injector.getInstance(ServiceManager.class);
    }

    public static void main(String[] args) throws Exception {
        String command = "";
        boolean exit = false;
        for (int i = 0; i < args.length; ++i) {
            exit = true;
            command = command + args[i] + " ";
        }
        Host host = null;
        try {
            host = CurrentConfiguration.getInstance().getDefaultHost();
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        if (host == null) {
            LogManager.logError((String)"CONTROLLER", (String)("ERROR " + PlatformPlugin.Util.getString("ERR.014.005.0001")));
            System.exit(-1);
        }
        VMNaming.setup((String)host.getFullName(), (String)host.getHostAddress(), (String)host.getBindAddress());
        try {
            ServiceManager manager = ServiceManager.loadServiceManager(host);
            manager.run(command, exit);
        }
        catch (Exception e) {
            System.out.println("Please make sure the HostController is running on this host");
            System.exit(-1);
        }
    }
}

