/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.admin.apiimpl;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.server.InvalidRequestIDException;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.platform.admin.apiimpl.AdminAPIHelper;
import com.metamatrix.platform.admin.apiimpl.SubSystemAdminAPIImpl;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.server.admin.api.QueryAdminAPI;
import com.metamatrix.server.query.service.QueryServiceInterface;
import java.util.ArrayList;
import java.util.Collection;

public class QueryAdminAPIImpl
extends SubSystemAdminAPIImpl
implements QueryAdminAPI {
    private QueryServiceInterface queryAdmin = PlatformProxyHelper.getQueryServiceProxy("ROUND_ROBIN_LOCAL");
    private static QueryAdminAPI queryAdminAPI;

    private QueryAdminAPIImpl() throws MetaMatrixComponentException {
    }

    public static synchronized QueryAdminAPI getInstance() throws MetaMatrixComponentException {
        if (queryAdminAPI == null) {
            queryAdminAPI = new QueryAdminAPIImpl();
        }
        return queryAdminAPI;
    }

    public synchronized Collection getAllRequests() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        ArrayList requests = new ArrayList();
        requests.addAll(this.queryAdmin.getAllQueries());
        return requests;
    }

    public synchronized Collection getRequestsForSession(MetaMatrixSessionID userSessionID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        SessionToken userToken = AdminAPIHelper.validateSession(userSessionID);
        ArrayList requests = new ArrayList();
        requests.addAll(this.queryAdmin.getQueriesForSession(userToken));
        return requests;
    }

    public synchronized void cancelRequest(RequestID requestID) throws AuthorizationException, InvalidSessionException, InvalidRequestIDException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(callerToken, "Admin.ProductAdmin", "QueryAdminAPIImpl.cancelRequest(" + requestID + ")");
        this.queryAdmin.cancelQuery(requestID, true);
    }

    public synchronized void cancelRequest(RequestID requestID, int nodeID) throws AuthorizationException, InvalidSessionException, InvalidRequestIDException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(callerToken, "Admin.ProductAdmin", "QueryAdminAPIImpl.cancelRequest(" + requestID + ", " + nodeID + ")");
        this.queryAdmin.cancelQuery(requestID, nodeID);
    }

    public synchronized void cancelRequests(MetaMatrixSessionID userSessionID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(callerToken, "Admin.ProductAdmin", "QueryAdminAPIImpl.cancelRequests(" + userSessionID + ")");
        SessionToken userToken = AdminAPIHelper.validateSession(userSessionID);
        try {
            this.queryAdmin.cancelQueries(userToken, true);
        }
        catch (InvalidRequestIDException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
    }
}

