/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.admin.apiimpl;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.net.ServerSocketConfiguration;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.vdb.VDBStatus;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.RuntimeVDBDeleteUtility;
import com.metamatrix.metadata.runtime.api.MetadataID;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.vdb.defn.VDBDefnFactory;
import com.metamatrix.metadata.runtime.vdb.defn.VDBDefnImport;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.platform.admin.api.PermissionDataNode;
import com.metamatrix.platform.admin.apiimpl.AdminAPIHelper;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeImpl;
import com.metamatrix.platform.admin.apiimpl.SubSystemAdminAPIImpl;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.server.admin.api.MaterializationLoadScripts;
import com.metamatrix.server.admin.api.RuntimeMetadataAdminAPI;
import com.metamatrix.server.admin.apiimpl.RuntimeMetadataHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class RuntimeMetadataAdminAPIImpl
extends SubSystemAdminAPIImpl
implements RuntimeMetadataAdminAPI {
    private static RuntimeMetadataAdminAPI runtimeMetadataAdminAPI;

    private RuntimeMetadataAdminAPIImpl() throws MetaMatrixComponentException {
    }

    public static synchronized RuntimeMetadataAdminAPI getInstance() throws MetaMatrixComponentException {
        if (runtimeMetadataAdminAPI == null) {
            runtimeMetadataAdminAPI = new RuntimeMetadataAdminAPIImpl();
        }
        return runtimeMetadataAdminAPI;
    }

    public synchronized void updateVirtualDatabase(VirtualDatabase vdb) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(callerToken, "Admin.ProductAdmin", "RuntimeMetadataAdminAPIImpl.updateVirtualDatabase(" + vdb.getID() + ")");
        RuntimeMetadataCatalog.getInstance().updateVirtualDatabase(vdb, callerToken.getUsername());
    }

    public synchronized void markVDBForDelete(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(callerToken, "Admin.ProductAdmin", "RuntimeMetadataAdminAPIImpl.markVDBForDelete(" + vdbID + ")");
        VirtualDatabase theVDB = RuntimeMetadataCatalog.getInstance().getVirtualDatabase(vdbID);
        short vdbStatus = theVDB.getStatus();
        if (vdbStatus == 4) {
            return;
        }
        if (vdbStatus != 2 && vdbStatus != 1) {
            String msg = RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Can_t_delete_VDB_in_state_{0}", new Object[]{VDBStatus.VDB_STATUS_NAMES[vdbStatus]});
            throw new VirtualDatabaseException(msg);
        }
        RuntimeMetadataCatalog.getInstance().setVDBStatus(vdbID, (short)4, callerToken.getUsername());
        RuntimeVDBDeleteUtility vdbDeleter = new RuntimeVDBDeleteUtility();
        vdbDeleter.deleteVDBMarkedForDelete(vdbID);
    }

    public synchronized Map migrateConnectorBindingNames(VirtualDatabase sourceVDB, VDBDefn vdb) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        HashMap<String, List> modelNameToRoutingIDs = new HashMap<String, List>();
        ArrayList<String> modelNames = new ArrayList<String>();
        for (ModelInfo model : vdb.getModels()) {
            String modelName = model.getName();
            modelNameToRoutingIDs.put(modelName, Collections.EMPTY_LIST);
            modelNames.add(modelName);
        }
        short stateFlag = 3;
        VirtualDatabase currentVDB = sourceVDB;
        VirtualDatabaseID currentVDBID = sourceVDB.getVirtualDatabaseID();
        do {
            for (Model model : RuntimeMetadataCatalog.getInstance().getModels(currentVDB.getVirtualDatabaseID())) {
                String modelName = model.getName();
                if (!modelNames.contains(modelName)) continue;
                List cbNames = model.getConnectorBindingNames();
                modelNameToRoutingIDs.put(modelName, cbNames);
                if (cbNames.size() <= 0) continue;
                modelNames.remove(modelName);
            }
            int currentVers = Integer.parseInt(currentVDBID.getVersion());
            if ((currentVDB = RuntimeMetadataHelper.walkBack(currentVDB.getName(), currentVers, stateFlag)) == null) continue;
            currentVDBID = currentVDB.getVirtualDatabaseID();
        } while (currentVDB != null && modelNames.size() > 0);
        return modelNameToRoutingIDs;
    }

    public synchronized void setConnectorBindingNames(VirtualDatabaseID vdbID, Map modelAndCBNames) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(callerToken, "Admin.ProductAdmin", "RuntimeMetadataAdminAPIImpl.setConnectorBindingNames(" + vdbID + ", " + modelAndCBNames + ")");
        RuntimeMetadataCatalog.getInstance().setConnectorBindingNames(vdbID, modelAndCBNames, callerToken.getUsername());
    }

    public synchronized Map getConnectorBindingNames(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        Collection models = RuntimeMetadataCatalog.getInstance().getModels(vdbID);
        HashMap<MetadataID, String> modelIDsCBNames = new HashMap<MetadataID, String>();
        for (Model model : models) {
            List cbNames = model.getConnectorBindingNames();
            for (String cbName : cbNames) {
                modelIDsCBNames.put(model.getID(), cbName);
            }
        }
        return modelIDsCBNames;
    }

    public synchronized Collection getVDBsForConnectorBinding(String routingID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        HashSet<VirtualDatabase> VDBs = new HashSet<VirtualDatabase>();
        Iterator allVDBItr = RuntimeMetadataCatalog.getInstance().getVirtualDatabases().iterator();
        boolean found = false;
        while (allVDBItr.hasNext()) {
            found = false;
            VirtualDatabase aVDB = (VirtualDatabase)allVDBItr.next();
            Iterator modelItr = RuntimeMetadataCatalog.getInstance().getModels(aVDB.getVirtualDatabaseID()).iterator();
            block1: while (!found && modelItr.hasNext()) {
                Model model = (Model)modelItr.next();
                List cbNames = model.getConnectorBindingNames();
                for (String connectorBindingName : cbNames) {
                    if (connectorBindingName == null || !connectorBindingName.equals(routingID)) continue;
                    VDBs.add(aVDB);
                    found = true;
                    continue block1;
                }
            }
        }
        return VDBs;
    }

    public synchronized VirtualDatabase getVirtualDatabase(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return RuntimeMetadataCatalog.getInstance().getVirtualDatabase(vdbID);
    }

    public synchronized VirtualDatabase getLatestVirtualDatabase(String vdbName) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        VirtualDatabaseID vdbId = RuntimeMetadataCatalog.getInstance().getVirtualDatabaseID(vdbName, null);
        if (vdbId != null) {
            return RuntimeMetadataCatalog.getInstance().getVirtualDatabase(vdbId);
        }
        return null;
    }

    public synchronized Collection getVirtualDatabases() throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return RuntimeMetadataCatalog.getInstance().getVirtualDatabases();
    }

    public synchronized Collection getVDBModels(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        ArrayList models = new ArrayList(RuntimeMetadataCatalog.getInstance().getModels(vdbID));
        int sysModelIndex = -1;
        for (int i = 0; i < models.size(); ++i) {
            Model model = (Model)models.get(i);
            if (!model.getName().equals("SystemPhysical")) continue;
            sysModelIndex = i;
            break;
        }
        if (sysModelIndex >= 0) {
            models.remove(sysModelIndex);
        }
        int sysAdminModelIndex = -1;
        for (int i = 0; i < models.size(); ++i) {
            Model model = (Model)models.get(i);
            if (!model.getName().equals("SystemAdminPhysical")) continue;
            sysAdminModelIndex = i;
            break;
        }
        if (sysAdminModelIndex >= 0) {
            models.remove(sysAdminModelIndex);
        }
        return models;
    }

    public synchronized void setVDBState(VirtualDatabaseID vdbID, short state) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(callerToken, "Admin.ProductAdmin", "RuntimeMetadataAdminAPIImpl.setVDBState(" + vdbID + ", " + state + ")");
        VirtualDatabase theVDB = RuntimeMetadataCatalog.getInstance().getVirtualDatabase(vdbID);
        short vdbStatus = theVDB.getStatus();
        if (vdbStatus == 4 || vdbStatus == state) {
            return;
        }
        if (!this.isValidStateChange(theVDB, state)) {
            String msg = RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Can__t_set_VDB_state_from_{0}_to_{1}", new Object[]{VDBStatus.VDB_STATUS_NAMES[vdbStatus], VDBStatus.VDB_STATUS_NAMES[state]});
            throw new VirtualDatabaseException(msg);
        }
        RuntimeMetadataCatalog.getInstance().setVDBStatus(vdbID, state, callerToken.getUsername());
        RuntimeMetadataCatalog.getInstance().setVDBStatus(vdbID, state, callerToken.getUsername());
    }

    private boolean isValidStateChange(VirtualDatabase theVDB, short newState) throws VirtualDatabaseException {
        boolean isValid = false;
        short currentState = theVDB.getStatus();
        if (currentState == 2 && newState == 3 || currentState == 3 && newState == 2 || currentState == 3 && newState == 2 || currentState == 3 && newState == 3) {
            return true;
        }
        if (currentState == 2 && newState == 3 || currentState == 3 && newState == 3) {
            Collection allVDBs = RuntimeMetadataCatalog.getInstance().getVirtualDatabases();
            isValid = !this.namedVdbHasActiveDefault(theVDB.getName(), allVDBs);
        }
        return isValid;
    }

    private boolean namedVdbHasActiveDefault(String vdbName, Collection vdbs) {
        boolean hasActiveDefaultStatus = false;
        for (VirtualDatabase vdb : vdbs) {
            if (!vdb.getName().equals(vdbName) || vdb.getStatus() != 3) continue;
            hasActiveDefaultStatus = true;
        }
        return hasActiveDefaultStatus;
    }

    public synchronized EntitlementMigrationReport migrateEntitlements(VirtualDatabase sourceVDB, VirtualDatabase targetVDB) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.ProductAdmin", "RuntimeMetadataAdminAPIImpl.migrateEntitlements(" + sourceVDB.getID() + ", " + targetVDB.getID() + ")");
        return RuntimeMetadataHelper.migrateEntitlements(sourceVDB, targetVDB, token);
    }

    public synchronized EntitlementMigrationReport migrateEntitlements(VirtualDatabase targetVDB, char[] dataRoleContents, boolean overwriteExisting) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        SessionToken token = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(token, "Admin.SystemAdmin", "RuntimeMetadataAdminAPIImpl.migrateEntitlements(" + targetVDB.getID() + ")");
        return RuntimeMetadataHelper.migrateEntitlements(targetVDB.getVirtualDatabaseID(), dataRoleContents, overwriteExisting, token);
    }

    public synchronized PermissionDataNode getEntitlementTree(String vDBName, String vDBVersion, AuthorizationPolicyID policyID) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logDetail((String)"RUNTIME_METADATA_ADMIN_API", (Object[])new Object[]{"getEntitlementTree: Getting entitlements for policy: [" + policyID + "]"});
        AuthorizationServiceInterface authProxy = PlatformProxyHelper.getAuthorizationServiceProxy("ROUND_ROBIN_LOCAL");
        PermissionDataNode root = RuntimeMetadataHelper.getPermissionDataNodes(new AuthorizationRealm(vDBName, vDBVersion, null), policyID, authProxy);
        return root;
    }

    public synchronized PermissionDataNode getDataNodes(String vDBName, String vDBVersion) throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        LogManager.logDetail((String)"RUNTIME_METADATA_ADMIN_API", (Object[])new Object[]{"getDataNodes: Getting data nodes for VDB: [" + vDBName + "] Vers: [" + vDBVersion + "]"});
        PermissionDataNodeImpl root = RuntimeMetadataHelper.getDataNodes(vDBName, vDBVersion);
        return root;
    }

    public synchronized Set getAllDataNodeNames(String vdbName, String vdbVersion) throws InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return new HashSet(RuntimeMetadataHelper.getAllDataNodeNames(vdbName, vdbVersion, new HashMap()));
    }

    public synchronized byte[] getVDB(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(callerToken, "Admin.ProductAdmin", "RuntimeMetadataAdminAPIImpl.getVDBDefn(" + vdbID + ")");
        VDBArchive vdbArchive = null;
        try {
            vdbArchive = VDBDefnFactory.createVDBArchive(vdbID.getName(), vdbID.getVersion());
            byte[] byArray = VDBArchive.writeToByteArray((VDBArchive)vdbArchive);
            return byArray;
        }
        catch (VirtualDatabaseException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)e);
            }
            if (e instanceof InvalidSessionException) {
                throw (InvalidSessionException)((Object)e);
            }
            if (e instanceof MetaMatrixComponentException) {
                throw (MetaMatrixComponentException)((Object)e);
            }
            throw new MetaMatrixComponentException((Throwable)e, RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Error_getting_VDBDefn_for_{0}") + vdbID);
        }
        finally {
            if (vdbArchive != null) {
                vdbArchive.close();
            }
        }
    }

    public synchronized VirtualDatabase importVDB(byte[] vdbStream) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(callerToken, "Admin.ProductAdmin", "RuntimeMetadataAdminAPIImpl.importVDB(vdbStream)");
        VDBArchive vdbArchive = null;
        try {
            vdbArchive = new VDBArchive((InputStream)new ByteArrayInputStream(vdbStream));
            VirtualDatabase virtualDatabase = VDBDefnImport.importVDBDefn(vdbArchive, callerToken.getUsername());
            return virtualDatabase;
        }
        catch (VirtualDatabaseException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)e);
            }
            if (e instanceof InvalidSessionException) {
                throw (InvalidSessionException)((Object)e);
            }
            if (e instanceof MetaMatrixComponentException) {
                throw (MetaMatrixComponentException)((Object)e);
            }
            Object[] params = new Object[]{vdbArchive.getName()};
            String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0008", params);
            throw new MetaMatrixComponentException((Throwable)e, "ERR.018.001.0008", msg);
        }
        finally {
            if (vdbArchive != null) {
                vdbArchive.close();
            }
        }
    }

    public synchronized Map getModelVisibilityLevels(VirtualDatabaseID vdbID) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        Collection models = RuntimeMetadataCatalog.getInstance().getModels(vdbID);
        HashMap<MetadataID, Short> modelIDsVLevels = new HashMap<MetadataID, Short>();
        for (Model model : models) {
            modelIDsVLevels.put(model.getID(), new Short(model.getVisibility()));
        }
        return modelIDsVLevels;
    }

    public boolean validateConnectorBindingForMaterialization(ConnectorBinding materializationConnector) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        return true;
    }

    public MaterializationLoadScripts getMaterializationScripts(ConnectorBinding materializationConnector, VDBDefn vdb, String mmHost, String mmPort, String materializationUserName, String materializationUserPwd, String metamatrixUserName, String metamatrixPwd) throws AuthorizationException, InvalidSessionException, VirtualDatabaseException, MetaMatrixComponentException {
        if (vdb == null) {
            throw new MetaMatrixRuntimeException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.VDB_null"));
        }
        if (materializationUserName == null || materializationUserName.trim().length() == 0) {
            throw new MetaMatrixRuntimeException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.materializationUserName_null"));
        }
        if (materializationUserPwd == null || materializationUserPwd.trim().length() == 0) {
            throw new MetaMatrixRuntimeException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.materializationUserPwd_null"));
        }
        if (metamatrixUserName == null || metamatrixUserName.trim().length() == 0) {
            throw new MetaMatrixRuntimeException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.metamatrixUserName_null"));
        }
        if (metamatrixPwd == null || metamatrixPwd.trim().length() == 0) {
            throw new MetaMatrixRuntimeException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.metamatrixPwd_null"));
        }
        ModelInfo materializationModel = this.getMatertializationModel(vdb);
        if (materializationModel == null) {
            throw new MetaMatrixRuntimeException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.VDB_has_no_materialziation"));
        }
        String vdbName = vdb.getName();
        int dotIndex = vdbName.indexOf(46);
        if (dotIndex >= 0) {
            vdbName = vdbName.substring(0, dotIndex);
        }
        String vdbVersion = vdb.getVersion();
        Properties connectorProps = materializationConnector.getProperties();
        String matURL = connectorProps.getProperty("URL");
        String matDriver = connectorProps.getProperty("Driver");
        if (mmHost == null) {
            throw new MetaMatrixRuntimeException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.MetaMatrix_host_null"));
        }
        try {
            Integer.parseInt(mmPort);
        }
        catch (NumberFormatException err) {
            Object[] params = new Object[]{mmPort};
            throw new MetaMatrixRuntimeException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Expected_integer_for_port {0}", params));
        }
        String mmDriver = "com.metamatrix.jdbc.MMDriver";
        boolean useSSL = false;
        try {
            useSSL = ServerSocketConfiguration.isSSLEnabled();
        }
        catch (Exception err) {
            throw new MetaMatrixRuntimeException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Unable_to_determine_ssl_mode"));
        }
        try {
            metamatrixPwd = PropertiesUtils.saveConvert((String)CryptoUtil.stringEncrypt((String)metamatrixPwd), (boolean)false);
            materializationUserPwd = PropertiesUtils.saveConvert((String)CryptoUtil.stringEncrypt((String)materializationUserPwd), (boolean)false);
        }
        catch (CryptoException err1) {
            Object[] params = new Object[]{vdbName};
            throw new MetaMatrixRuntimeException((Throwable)err1, RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Unable_to_encrypt_pwd", params));
        }
        MaterializationLoadScripts scripts = RuntimeMetadataHelper.createMaterializedViewLoadProperties(materializationModel, matURL, matDriver, materializationUserName, materializationUserPwd, mmHost, mmPort, mmDriver, useSSL, metamatrixUserName, metamatrixPwd, vdbName, vdbVersion);
        return scripts;
    }

    private ModelInfo getMatertializationModel(VDBDefn vdb) {
        ModelInfo matModel = null;
        for (ModelInfo aModel : vdb.getModels()) {
            if (aModel == null || !aModel.isMaterialization()) continue;
            matModel = aModel;
            break;
        }
        return matModel;
    }
}

