/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.admin.apiimpl;

import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.common.tree.basic.BasicTreeNode;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.LongIDFactory;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.VDBTreeUtility;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseMetadata;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseDoesNotExistException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.platform.admin.api.PermissionDataNode;
import com.metamatrix.platform.admin.api.PermissionDataNodeDefinition;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeDefinitionImpl;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeImpl;
import com.metamatrix.platform.security.api.AuthorizationPolicyFactory;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceNotFoundException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.server.admin.api.MaterializationLoadScripts;
import com.metamatrix.server.admin.apiimpl.MaterializationLoadScriptsImpl;
import com.metamatrix.vdb.materialization.DatabaseDialect;
import com.metamatrix.vdb.materialization.MaterializedViewScriptGeneratorImpl;
import com.metamatrix.vdb.materialization.ScriptType;
import com.metamatrix.vdb.materialization.template.MaterializedViewConnectionData;
import com.metamatrix.vdb.materialization.template.TemplateData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RuntimeMetadataHelper {
    public static final char PATH_SEPERATOR_CHAR = '.';
    public static final short VDB_STATE_INCOMPLETE = 0;
    public static final short VDB_STATE_INACTIVE = 1;
    public static final short VDB_STATE_ACTIVE = 2;
    public static final short VDB_STATE_DELETED = 4;
    public static final short VDB_STATE_ACTIVE_DEFAULT = 5;

    public static short[] mapVDBStates(short stateFlag) {
        short[] states = new short[]{(stateFlag & 0) == 0 ? (short)1 : -1, (stateFlag & 1) == 0 ? (short)2 : -1, (stateFlag & 2) == 0 ? (short)3 : -1, (stateFlag & 4) == 0 ? (short)4 : -1, (stateFlag & 5) == 0 ? (short)3 : -1};
        return states;
    }

    public static VirtualDatabase walkBack(String vdbName, int vers, short stateFlag) throws VirtualDatabaseException {
        short state;
        if (vers > 1) {
            --vers;
        } else {
            return null;
        }
        VirtualDatabaseID previousID = null;
        VirtualDatabase previousVDB = null;
        try {
            previousID = RuntimeMetadataCatalog.getInstance().getVirtualDatabaseID(vdbName, String.valueOf(vers));
            previousVDB = RuntimeMetadataCatalog.getInstance().getVirtualDatabase(previousID);
        }
        catch (VirtualDatabaseDoesNotExistException e) {
            // empty catch block
        }
        if (previousVDB != null && ((state = previousVDB.getStatus()) == 1 || state == 2 || state == 3 || state == 3)) {
            return previousVDB;
        }
        return RuntimeMetadataHelper.walkBack(vdbName, vers, stateFlag);
    }

    public static List getAllDataNodeNames(VirtualDatabaseID vdbID, Map modelNameToModelMap) throws MetaMatrixComponentException {
        VirtualDatabaseMetadata vdbMeta = null;
        try {
            vdbMeta = RuntimeMetadataCatalog.getInstance().getVirtualDatabaseMetadata(vdbID);
        }
        catch (VirtualDatabaseException e) {
            String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0051", new Object[]{vdbID});
            throw new MetaMatrixComponentException((Throwable)e, "ERR.018.001.0051", msg);
        }
        Collection models = Collections.EMPTY_LIST;
        try {
            models = vdbMeta.getDisplayableModels();
        }
        catch (VirtualDatabaseException e) {
            String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0053", new Object[]{vdbID});
            throw new MetaMatrixComponentException((Throwable)e, "ERR.018.001.0053", msg);
        }
        List permissionNodeNames = Collections.EMPTY_LIST;
        if (models == null || models.isEmpty()) {
            return permissionNodeNames;
        }
        try {
            permissionNodeNames = vdbMeta.getALLPaths(models);
        }
        catch (VirtualDatabaseException e) {
            String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0052", new Object[]{vdbID});
            throw new MetaMatrixComponentException((Throwable)e, msg);
        }
        for (Model aModel : models) {
            modelNameToModelMap.put(aModel.getName(), aModel);
        }
        if (modelNameToModelMap.size() == 0) {
            String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0053", new Object[]{vdbID});
            throw new MetaMatrixComponentException("ERR.018.001.0053", msg);
        }
        return permissionNodeNames;
    }

    public static void getDataNodeNames(PermissionDataNodeImpl treeRoot, List nodeNames) {
        List childNodes = treeRoot.getChildren();
        for (PermissionDataNodeImpl aNode : childNodes) {
            nodeNames.add(aNode.getResourceName());
            RuntimeMetadataHelper.getDataNodeNames(aNode, nodeNames);
        }
    }

    public static List getAllDataNodeNames(String vdbName, String vdbVersion, Map modelNameToModelMap) throws MetaMatrixComponentException {
        VirtualDatabaseID vdbID = RuntimeMetadataHelper.getVDBID(vdbName, vdbVersion);
        return RuntimeMetadataHelper.getAllDataNodeNames(vdbID, modelNameToModelMap);
    }

    public static PermissionDataNodeImpl getDataNodes(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        ObjectIDFactory idFactory = IDGenerator.getInstance().getFactory("mmlong");
        if (idFactory == null) {
            IDGenerator.getInstance().addFactory((ObjectIDFactory)new LongIDFactory());
            idFactory = IDGenerator.getInstance().getFactory("mmlong");
        }
        PermissionDataNodeImpl root = new PermissionDataNodeImpl(null, StandardAuthorizationActions.NONE, (PermissionDataNodeDefinition)new PermissionDataNodeDefinitionImpl("root", "root", 0), false, idFactory.create());
        try {
            RuntimeMetadataHelper.buildVDBTree(vdbName, vdbVersion, (BasicTreeNode)root, idFactory);
        }
        catch (VirtualDatabaseException e) {
            String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0053", new Object[]{vdbName});
            throw new MetaMatrixComponentException((Throwable)e, "ERR.018.001.0053", msg);
        }
        return root;
    }

    private static synchronized void buildVDBTree(String vdbName, String vdbVersion, BasicTreeNode rootNode, ObjectIDFactory idFactory) throws VirtualDatabaseException {
        VirtualDatabaseID vdbID = RuntimeMetadataCatalog.getInstance().getVirtualDatabaseID(vdbName, vdbVersion);
        VirtualDatabaseMetadata vDBMetadata = RuntimeMetadataCatalog.getInstance().getVirtualDatabaseMetadata(vdbID);
        VDBTreeUtility.buildDataNodeTree(rootNode, idFactory, vDBMetadata);
    }

    public static PermissionDataNode getPermissionDataNodes(AuthorizationRealm realm, AuthorizationPolicyID policyID, AuthorizationServiceInterface authSvcProxy) throws MetaMatrixComponentException {
        String vdbName = realm.getSuperRealmName();
        String vdbVersion = realm.getSubRealmName();
        ObjectIDFactory idFactory = IDGenerator.getInstance().getFactory("mmlong");
        if (idFactory == null) {
            IDGenerator.getInstance().addFactory((ObjectIDFactory)new LongIDFactory());
            idFactory = IDGenerator.getInstance().getFactory("mmlong");
        }
        PermissionDataNodeImpl root = new PermissionDataNodeImpl(null, StandardAuthorizationActions.NONE, (PermissionDataNodeDefinition)new PermissionDataNodeDefinitionImpl("root", "root", 0), false, idFactory.create());
        try {
            RuntimeMetadataHelper.buildVDBTree(vdbName, vdbVersion, (BasicTreeNode)root, idFactory);
        }
        catch (VirtualDatabaseException e) {
            String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0053", new Object[]{vdbName});
            throw new MetaMatrixComponentException((Throwable)e, "ERR.018.001.0053", msg);
        }
        PermissionDataNodeImpl permissionNode = root;
        try {
            permissionNode = authSvcProxy.fillPermissionNodeTree((PermissionDataNode)root, policyID);
        }
        catch (AuthorizationMgmtException e) {
            String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0055");
            throw new MetaMatrixComponentException((Throwable)e, "ERR.018.001.0055", msg);
        }
        return permissionNode;
    }

    public static void printTree(Map tree) {
        ArrayList keys = new ArrayList(tree.keySet());
        Collections.sort(keys);
        Iterator itr = keys.iterator();
        int i = 0;
        while (itr.hasNext()) {
            PermissionDataNodeImpl parent = (PermissionDataNodeImpl)itr.next();
            System.out.println("\n (" + ++i + ")  Parent: <" + parent + ">");
            Iterator children = ((List)tree.get(parent)).iterator();
            if (!children.hasNext()) {
                System.out.println("        No Children - LEAF");
                continue;
            }
            while (children.hasNext()) {
                PermissionDataNodeImpl child = (PermissionDataNodeImpl)children.next();
                System.out.println("        Child: " + child);
            }
        }
    }

    public static VirtualDatabaseID getVDBID(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        VirtualDatabaseID vdbID = null;
        try {
            vdbID = RuntimeMetadataCatalog.getInstance().getVirtualDatabaseID(vdbName, vdbVersion);
        }
        catch (VirtualDatabaseException e) {
            String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0054", new Object[]{vdbName, vdbVersion});
            throw new MetaMatrixComponentException((Throwable)e, "ERR.018.001.0054", msg);
        }
        return vdbID;
    }

    public static EntitlementMigrationReport migrateEntitlements(VirtualDatabaseID tvdbID) throws MetaMatrixComponentException {
        int currentVersion = new Integer(tvdbID.getVersion());
        if (currentVersion <= 1) {
            return null;
        }
        int previousVersion = currentVersion - 1;
        String prevV = String.valueOf(previousVersion);
        VirtualDatabaseID svdbID = null;
        try {
            svdbID = RuntimeMetadataCatalog.getInstance().getVirtualDatabaseID(tvdbID.getFullName(), prevV);
        }
        catch (VirtualDatabaseException e) {
            // empty catch block
        }
        if (svdbID == null) {
            return null;
        }
        VirtualDatabase tvdb = null;
        VirtualDatabase svdb = null;
        try {
            svdb = RuntimeMetadataCatalog.getInstance().getVirtualDatabase(svdbID);
        }
        catch (VirtualDatabaseException e) {
            String msg = RuntimeMetadataPlugin.Util.getString("RuntimeMetadataHelper.VDB_is_not_found", new Object[]{svdbID.toString()});
            throw new MetaMatrixComponentException((Throwable)e, msg);
        }
        try {
            tvdb = RuntimeMetadataCatalog.getInstance().getVirtualDatabase(tvdbID);
        }
        catch (VirtualDatabaseException e) {
            String msg = RuntimeMetadataPlugin.Util.getString("RuntimeMetadataHelper.VDB_is_not_found", new Object[]{svdbID.toString()});
            throw new MetaMatrixComponentException((Throwable)e, msg);
        }
        SessionToken token = new SessionToken();
        return RuntimeMetadataHelper.migrateEntitlements(svdb, tvdb, token);
    }

    public static EntitlementMigrationReport migrateEntitlements(VirtualDatabaseID tvdbID, char[] dataRoleContents, boolean overwriteExisting, SessionToken session) throws MetaMatrixComponentException {
        AdminOptions options = null;
        options = overwriteExisting ? new AdminOptions(1) : new AdminOptions(2);
        String vdbName = tvdbID.getName();
        String vdbVersion = tvdbID.getVersion();
        try {
            Collection roles = AuthorizationPolicyFactory.buildPolicies((String)vdbName, (String)vdbVersion, (char[])dataRoleContents);
            EntitlementMigrationReport rpt = new EntitlementMigrationReport("from file", vdbName + " " + vdbVersion);
            HashSet allPaths = new HashSet(RuntimeMetadataHelper.getAllDataNodeNames(vdbName, vdbVersion, new HashMap()));
            RuntimeMetadataHelper.getAuthorizationService().migratePolicies(session, rpt, vdbName, vdbVersion, allPaths, roles, options);
            return rpt;
        }
        catch (Exception e) {
            String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0006");
            throw new MetaMatrixComponentException((Throwable)e, "ERR.018.001.0006", msg);
        }
    }

    public static EntitlementMigrationReport migrateEntitlements(VirtualDatabase sourceVDB, VirtualDatabase targetVDB, SessionToken token) throws MetaMatrixComponentException {
        EntitlementMigrationReport rpt = null;
        try {
            VirtualDatabaseID sourceVDBID = sourceVDB.getVirtualDatabaseID();
            String sourceNameVersion = sourceVDBID.getName() + " " + sourceVDBID.getVersion();
            AuthorizationRealm sourceRealm = new AuthorizationRealm(sourceVDBID.getName(), sourceVDBID.getVersion(), null);
            VirtualDatabaseID targetVDBID = targetVDB.getVirtualDatabaseID();
            String targetNameVersion = targetVDBID.getName() + " " + targetVDBID.getVersion();
            rpt = new EntitlementMigrationReport(sourceNameVersion, targetNameVersion);
            AuthorizationServiceInterface authProxy = RuntimeMetadataHelper.getAuthorizationService();
            Collection sourcePolicies = Collections.EMPTY_LIST;
            try {
                try {
                    sourcePolicies = authProxy.getPoliciesInRealm(token, sourceRealm);
                }
                catch (ServiceNotFoundException se) {
                    Thread.sleep(5000L);
                    sourcePolicies = authProxy.getPoliciesInRealm(token, sourceRealm);
                }
            }
            catch (Exception e) {
                String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0004", new Object[]{sourceRealm, e.getMessage()});
                throw new MetaMatrixComponentException((Throwable)e, "ERR.018.001.0004", msg);
            }
            HashSet targetNodes = new HashSet(RuntimeMetadataHelper.getAllDataNodeNames(targetVDBID.getName(), targetVDBID.getVersion(), new HashMap()));
            authProxy.migratePolicies(token, rpt, targetVDBID.getName(), targetVDBID.getVersion(), targetNodes, sourcePolicies, new AdminOptions(1));
            HashSet sourceNodes = new HashSet(RuntimeMetadataHelper.getAllDataNodeNames(sourceVDBID.getName(), sourceVDBID.getVersion(), new HashMap()));
            HashSet newResources = new HashSet(targetNodes);
            newResources.removeAll(sourceNodes);
            if (newResources.size() > 0) {
                Iterator newResourceItr = newResources.iterator();
                while (newResourceItr.hasNext()) {
                    if (rpt == null) continue;
                    rpt.addResourceEntry((Object)RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Failed_migration"), newResourceItr.next(), (Object)"", (Object)"", (Object)"None", (Object)RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.This_resource_exists_in_the_target_VDB_but_not_in_the_source_VDB."));
                }
            }
        }
        catch (Exception e) {
            String msg = RuntimeMetadataPlugin.Util.getString("ERR.018.001.0006");
            throw new MetaMatrixComponentException((Throwable)e, "ERR.018.001.0006", msg);
        }
        return rpt;
    }

    private static AuthorizationServiceInterface getAuthorizationService() throws ServiceException {
        AuthorizationServiceInterface authProxy = PlatformProxyHelper.getAuthorizationServiceProxy("ROUND_ROBIN_LOCAL");
        return authProxy;
    }

    public static MaterializationLoadScripts createMaterializedViewLoadProperties(ModelInfo materializationModel, String matURL, String matDriver, String materializationUserName, String materializationUserPwd, String mmHost, String mmPort, String mmDriver, boolean useSSL, String metamatrixUserName, String metamatrixPwd, String vdbName, String vdbVersion) {
        String nextVersion = RuntimeMetadataHelper.getNextVDBVersion(vdbName, vdbVersion);
        return RuntimeMetadataHelper.createMaterializedViewLoadPropertiesVersion(materializationModel, matURL, matDriver, materializationUserName, materializationUserPwd, mmHost, mmPort, mmDriver, useSSL, metamatrixUserName, metamatrixPwd, vdbName, nextVersion);
    }

    public static MaterializationLoadScripts createMaterializedViewLoadPropertiesVersion(ModelInfo materializationModel, String matURL, String matDriver, String materializationUserName, String materializationUserPwd, String mmHost, String mmPort, String mmDriver, boolean useSSL, String metamatrixUserName, String metamatrixPwd, String vdbName, String vdbVersion) {
        String propFileName = ScriptType.connectionPropertyFileName((String)vdbName, (String)vdbVersion);
        String logFileName = ScriptType.logFileName((String)vdbName, (String)vdbVersion);
        ByteArrayOutputStream oStream = null;
        MaterializationLoadScriptsImpl scripts = null;
        try {
            DatabaseDialect dbDialect;
            String databaseType = RuntimeMetadataHelper.parseDatabaseType(matURL, matDriver, materializationUserName, materializationUserPwd);
            if (databaseType == null) {
                throw new MetaMatrixRuntimeException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataAdminAPIImpl.Connector_has_no_URL"));
            }
            if ((matDriver == null || matDriver.length() == 0) && (dbDialect = DatabaseDialect.getDatabaseDialect((String)databaseType)) != null) {
                matDriver = dbDialect.getDriverClassname();
            }
            scripts = new MaterializationLoadScriptsImpl();
            String[] scriptFileNames = materializationModel.getDDLFileNames();
            String SQL_SERVER_STR = "sql_server";
            for (int i = 0; i < scriptFileNames.length; ++i) {
                String aScriptFileName = scriptFileNames[i];
                String dbAlias = databaseType;
                if (StringUtil.indexOfIgnoreCase((String)aScriptFileName, (String)"sql_server") >= 0 && databaseType.equalsIgnoreCase(DatabaseDialect.SQL_SERVER.getType())) {
                    dbAlias = "sql_server";
                }
                if (StringUtil.indexOfIgnoreCase((String)aScriptFileName, (String)dbAlias) >= 0) {
                    if (ScriptType.isMaterializationScript((String)aScriptFileName)) {
                        String createScriptName = ScriptType.createScriptFileName((String)vdbName, (String)vdbVersion);
                        scripts.setCreateScript(createScriptName, materializationModel.getDDLFileContentsGetBytes(aScriptFileName));
                        continue;
                    }
                    if (ScriptType.isTruncateScript((String)aScriptFileName)) {
                        String truncateScriptName = ScriptType.truncateScriptFileName((String)vdbName, (String)vdbVersion);
                        scripts.setTruncateScript(truncateScriptName, materializationModel.getDDLFileContentsGetBytes(aScriptFileName));
                        continue;
                    }
                    if (!ScriptType.isSwapScript((String)aScriptFileName)) continue;
                    String swapScriptName = ScriptType.swapScriptFileName((String)vdbName, (String)vdbVersion);
                    scripts.setSwapScript(swapScriptName, materializationModel.getDDLFileContentsGetBytes(aScriptFileName));
                    continue;
                }
                if (!ScriptType.isLoadScript((String)aScriptFileName)) continue;
                String loadScriptName = ScriptType.loadScriptFileName((String)vdbName, (String)vdbVersion);
                scripts.setLoadScript(loadScriptName, materializationModel.getDDLFileContentsGetBytes(aScriptFileName));
            }
            String mmProtocol = useSSL ? "mms" : "mm";
            MaterializedViewConnectionData propGenData = new MaterializedViewConnectionData(vdbName, vdbVersion, mmHost, mmPort, mmDriver, metamatrixPwd, metamatrixUserName, mmProtocol, matURL, matDriver, materializationUserPwd, materializationUserName, scripts.getTruncateScriptFileName(), scripts.getLoadScriptFileName(), scripts.getSwapScriptFileName(), logFileName);
            MaterializedViewScriptGeneratorImpl propGen = new MaterializedViewScriptGeneratorImpl((TemplateData)propGenData);
            oStream = new ByteArrayOutputStream();
            propGen.generateMaterializationConnectionPropFile((OutputStream)oStream);
        }
        catch (Throwable t) {
            Object[] params = new Object[]{propFileName};
            throw new MetaMatrixRuntimeException(t, RuntimeMetadataPlugin.Util.getString("RuntimeMetadataHelper.Error_creating_prop_file", params));
        }
        finally {
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (IOException err) {}
            }
        }
        if (oStream != null) {
            scripts.setConnectionPropsFile(propFileName, oStream.toByteArray());
        }
        return scripts;
    }

    private static String getNextVDBVersion(String vdbName, String vdbVersion) {
        String nextVersion = "1";
        if (vdbVersion == null) {
            VirtualDatabaseID vdbID = null;
            try {
                vdbID = RuntimeMetadataCatalog.getInstance().getActiveVirtualDatabaseID(vdbName, vdbVersion);
            }
            catch (VirtualDatabaseDoesNotExistException err) {
            }
            catch (VirtualDatabaseException err) {
                // empty catch block
            }
            if (vdbID != null) {
                int existingVers = Integer.parseInt(vdbID.getVersion());
                nextVersion = Integer.toString(existingVers);
            }
        } else {
            nextVersion = vdbVersion;
        }
        return nextVersion;
    }

    protected static String parseDatabaseType(String url, String driver, String userName, String pwd) throws Throwable {
        return RuntimeMetadataHelper.parseDatabaseType(url, driver);
    }

    protected static String parseDatabaseType(String url, String driver) {
        if (url != null) {
            try {
                JDBCPlatform platform = JDBCPlatformFactory.getPlatform(url, driver);
                if (platform != null) {
                    if (platform.isDB2()) {
                        return DatabaseDialect.DB2.getType().toLowerCase();
                    }
                    if (platform.isOracle()) {
                        return DatabaseDialect.ORACLE.getType().toLowerCase();
                    }
                    if (platform.isSybase()) {
                        return DatabaseDialect.SYBASE.getType().toLowerCase();
                    }
                    if (platform.isMSSQL()) {
                        return DatabaseDialect.SQL_SERVER.getType().toLowerCase();
                    }
                    if (platform.isMYSQL()) {
                        return DatabaseDialect.MYSQL.getType().toLowerCase();
                    }
                }
            }
            catch (MetaMatrixException err) {
                err.printStackTrace();
            }
            Object[] urlParts = StringUtil.split((String)url, (String)":").toArray();
            if (urlParts.length >= 3) {
                StringBuffer dbType = new StringBuffer((String)urlParts[2]);
                if (dbType.charAt(dbType.length() - 1) == '\\') {
                    dbType.setLength(dbType.length() - 1);
                }
                return dbType.toString();
            }
        }
        return null;
    }
}

