/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.admin.apiimpl;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MultipleException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.platform.admin.apiimpl.AdminAPIHelper;
import com.metamatrix.platform.admin.apiimpl.SubSystemAdminAPIImpl;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.server.admin.api.TransactionAdminAPI;
import java.util.Collection;
import java.util.Collections;

public class TransactionAdminAPIImpl
extends SubSystemAdminAPIImpl
implements TransactionAdminAPI {
    private static TransactionAdminAPI transactionAdminAPI;

    private TransactionAdminAPIImpl() throws MetaMatrixComponentException {
    }

    public static synchronized TransactionAdminAPI getInstance() throws MetaMatrixComponentException {
        if (transactionAdminAPI == null) {
            transactionAdminAPI = new TransactionAdminAPIImpl();
        }
        return transactionAdminAPI;
    }

    public synchronized Collection getAllTransactions() throws AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        AdminAPIHelper.validateSession(this.getSessionID());
        return Collections.EMPTY_LIST;
    }

    public synchronized void terminateTransaction(TransactionID transactionID) throws AuthorizationException, InvalidSessionException, XATransactionException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(callerToken, "Admin.ProductAdmin", "TransactionAdminAPIImpl.terminateTransaction(" + transactionID + ")");
    }

    public synchronized void terminateAllTransactions(MetaMatrixSessionID userSessionID) throws AuthorizationException, InvalidSessionException, MultipleException, MetaMatrixComponentException {
        SessionToken callerToken = AdminAPIHelper.validateSession(this.getSessionID());
        AdminAPIHelper.checkForRequiredRole(callerToken, "Admin.ProductAdmin", "TransactionAdminAPIImpl.terminateAllTransactions(" + userSessionID + ")");
    }
}

