/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.connector.service;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.classloader.NonDelegatingClassLoader;
import com.metamatrix.common.classloader.URLFilteringClassLoader;
import com.metamatrix.common.comm.ClientServiceRegistry;
import com.metamatrix.common.comm.api.ResultsReceiver;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.extensionmodule.ExtensionModuleEvent;
import com.metamatrix.common.extensionmodule.protocol.URLFactory;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.util.ReflectionHelper;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.message.AtomicRequestID;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.AtomicResultsMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.service.DQPServiceNames;
import com.metamatrix.platform.service.api.CacheAdmin;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import com.metamatrix.platform.service.controller.AbstractService;
import com.metamatrix.query.optimizer.capabilities.SourceCapabilities;
import com.metamatrix.server.ResourceFinder;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.server.connector.service.ClientServiceRegistryService;
import com.metamatrix.server.connector.service.ConnectorServiceInterface;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.teiid.connector.api.ConnectorException;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManager;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class ConnectorService
extends AbstractService
implements ConnectorServiceInterface,
CacheAdmin {
    private static final String RESULT_SET_CACHE_NAME = "ConnectorResultSetCache";
    private ConnectorManager connectorMgr;
    private String connectorMgrName;
    private boolean monitoringEnabled = true;
    private ClientServiceRegistry registry;
    private static boolean cacheClassLoaders = true;
    private static Map<String, WeakReference<NonDelegatingClassLoader>> classLoaderCache = new HashMap<String, WeakReference<NonDelegatingClassLoader>>();

    private static void initExtensionModuleListener() {
        MessageBus vmb = ResourceFinder.getMessageBus();
        EventObjectListener listener = new EventObjectListener(){

            public void processEvent(EventObject obj) {
                if (obj instanceof ExtensionModuleEvent) {
                    ExtensionModuleEvent event = (ExtensionModuleEvent)obj;
                    switch (event.getType()) {
                        case -100: {
                            ConnectorService.clearClassLoaderCache();
                        }
                    }
                }
            }
        };
        try {
            vmb.addListener(ExtensionModuleEvent.class, listener);
        }
        catch (MessagingException e) {
            LogManager.logError((String)"CONFIG", (Throwable)((Object)e), (String)e.getMessage());
        }
    }

    @Override
    public void init(ServiceID id, DeployedComponentID deployedComponentID, Properties props, ClientServiceRegistry listenerRegistry) {
        this.registry = listenerRegistry;
        super.init(id, deployedComponentID, props, listenerRegistry);
        String monitoringEnabledString = this.getProperties().getProperty("ServiceMonitoringEnabled");
        if (monitoringEnabledString != null) {
            this.monitoringEnabled = Boolean.valueOf(monitoringEnabledString);
        }
        ConnectorService.logOK("ConnectorService.Data_source_monitoring_enabled", new Boolean(this.monitoringEnabled));
    }

    @Override
    public ConnectorID getConnectorID() throws ServiceStateException {
        return this.connectorMgr.getConnectorID();
    }

    @Override
    public void cancelRequest(AtomicRequestID request) throws MetaMatrixComponentException {
        this.connectorMgr.cancelRequest(request);
    }

    @Override
    public void closeRequest(AtomicRequestID request) throws MetaMatrixComponentException {
        this.connectorMgr.closeRequest(request);
    }

    @Override
    public void executeRequest(AtomicRequestMessage request, ResultsReceiver<AtomicResultsMessage> resultListener) throws MetaMatrixComponentException {
        this.connectorMgr.executeRequest(resultListener, request);
    }

    @Override
    public void requestBatch(AtomicRequestID request) throws MetaMatrixComponentException {
        this.connectorMgr.requstMore(request);
    }

    private ClassLoader getCustomClassLoader(String urls) throws ApplicationInitializationException {
        if (urls == null || urls.trim().length() == 0) {
            String msg = ServerPlugin.Util.getString("ConnectorService.NoClassPath");
            throw new ApplicationInitializationException(msg);
        }
        Class<ConnectorService> clazz = ConnectorService.class;
        synchronized (ConnectorService.class) {
            WeakReference<NonDelegatingClassLoader> ref;
            URLFilteringClassLoader result = null;
            if (cacheClassLoaders && (ref = classLoaderCache.get(urls)) != null && (result = (NonDelegatingClassLoader)ref.get()) != null) {
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return result;
            }
            try {
                result = new URLFilteringClassLoader(URLFactory.parseURLs(urls, ";"));
                if (cacheClassLoaders) {
                    classLoaderCache.put(urls, new WeakReference<URLFilteringClassLoader>(result));
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return result;
            }
            catch (MalformedURLException e1) {
                String msg = ServerPlugin.Util.getString("ConnectorService.IllegalClassPath");
                throw new ApplicationInitializationException(msg);
            }
        }
    }

    private ConnectorManager createConnectorManager(Properties deMaskedProps, ClassLoader loader) throws ApplicationLifecycleException {
        try {
            ConnectorManager connectorManager = (ConnectorManager)ReflectionHelper.create((String)ConnectorManager.class.getName(), null, (ClassLoader)loader);
            ServiceID id = this.getID();
            String connID = id.getHostName() + "|" + id.getProcessName() + "|" + id.getID();
            deMaskedProps.put("ConnectorID", connID);
            deMaskedProps.put("ConnectorBindingName", this.getInstanceName());
            deMaskedProps.put("ConnectorVMName", VMNaming.getProcessName());
            connectorManager.setClassloader(loader);
            connectorManager.initialize(deMaskedProps);
            return connectorManager;
        }
        catch (MetaMatrixCoreException e) {
            String msg = ServerPlugin.Util.getString("ConnectorService.Unexpected_error_instantiating_ConnectorManagerImpl");
            throw new ApplicationLifecycleException((Throwable)e, msg);
        }
    }

    @Override
    protected void initService(Properties props) throws ApplicationLifecycleException, ApplicationInitializationException {
        Properties deMaskedProps = this.decryptMaskedProperties(props);
        String urls = this.buildClasspath(deMaskedProps);
        ClassLoader loader = this.getCustomClassLoader(urls);
        this.connectorMgr = this.createConnectorManager(deMaskedProps, loader);
        ApplicationEnvironment env = new ApplicationEnvironment();
        env.bindService("platform.registry", (ApplicationService)new ClientServiceRegistryService(this.registry));
        for (int i = 0; i < DQPServiceNames.ALL_SERVICES.length; ++i) {
            final String serviceName = DQPServiceNames.ALL_SERVICES[i];
            env.bindService(serviceName, (ApplicationService)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DQPServiceNames.ALL_SERVICE_CLASSES[i]}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    DQPCore dqp = (DQPCore)ConnectorService.this.registry.getClientService(ClientSideDQP.class);
                    if (dqp == null) {
                        throw new IllegalStateException("A local QueryService is not available");
                    }
                    ApplicationService instance = dqp.getEnvironment().findService(serviceName);
                    if (instance == null) {
                        throw new IllegalStateException(serviceName + " is not available");
                    }
                    try {
                        return method.invoke((Object)instance, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
            }));
        }
        try {
            this.connectorMgr.start(env);
            this.connectorMgrName = this.connectorMgr.getName();
        }
        catch (ApplicationLifecycleException e) {
            this.killService();
            throw e;
        }
    }

    private String buildClasspath(Properties connectorProperties) {
        StringBuilder sb = new StringBuilder();
        this.appendlasspath(connectorProperties.getProperty("ConnectorClassPath"), sb);
        this.appendlasspath(connectorProperties.getProperty("ConnectorTypeClassPath"), sb);
        return sb.toString();
    }

    private void appendlasspath(String path, StringBuilder builder) {
        if (path != null && path.length() > 0) {
            builder.append(path);
            if (!path.endsWith(";")) {
                builder.append(";");
            }
        }
    }

    @Override
    protected void closeService() throws ApplicationLifecycleException {
        this.waitForServiceToClear();
        if (this.connectorMgr != null) {
            this.killService();
        }
    }

    @Override
    protected void waitForServiceToClear() throws ApplicationLifecycleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void killService() {
        if (this.connectorMgr != null) {
            try {
                Object[] params = new Object[]{this.connectorMgrName};
                LogManager.logInfo((String)"CONFIG", (String)ServerPlugin.Util.getString("ConnectorService.Killing_connectorMgr", params));
                this.connectorMgr.stop();
            }
            catch (ApplicationLifecycleException e) {
                Object[] params = new Object[]{this.connectorMgrName, e.getMessage()};
                LogManager.logError((String)"CONFIG", (Throwable)e, (String)ServerPlugin.Util.getString("ConnectorService.Unable_to_shutdown_connectorMgr", params));
            }
            finally {
                this.connectorMgr = null;
            }
        }
    }

    @Override
    public void checkState() throws ServiceStateException {
        if (this.monitoringEnabled) {
            Boolean status = this.connectorMgr.getStatus();
            int state = this.getCurrentState();
            if (state == 1 && status == Boolean.FALSE) {
                this.updateState(6);
                ConnectorService.logOK("ConnectorService.Change_state_to_data_source_unavailable", this.connectorMgrName);
            }
            if (state == 6 && status == Boolean.TRUE) {
                this.updateState(1);
                ConnectorService.logOK("ConnectorService.Change_state_to_open", this.connectorMgrName);
            }
        }
        if (this.getCurrentState() != 6) {
            super.checkState();
        }
    }

    @Override
    public SourceCapabilities getCapabilities(RequestID requestId, Serializable executionPayload, DQPWorkContext message) throws ConnectorException {
        return this.connectorMgr.getCapabilities(requestId, executionPayload, message);
    }

    @Override
    public Collection getQueueStatistics() {
        Collection result;
        if (this.connectorMgr != null && (result = this.connectorMgr.getQueueStatistics()) != null) {
            return result;
        }
        return new ArrayList();
    }

    @Override
    public WorkerPoolStats getQueueStatistics(String name) {
        Object aPoolStat;
        Iterator resultsItr;
        Collection results = null;
        if (this.connectorMgr != null) {
            results = this.connectorMgr.getQueueStatistics(name);
        }
        WorkerPoolStats poolStats = new WorkerPoolStats();
        if (results != null && (resultsItr = results.iterator()).hasNext() && (aPoolStat = resultsItr.next()) != null && aPoolStat instanceof WorkerPoolStats) {
            poolStats = (WorkerPoolStats)aPoolStat;
        }
        return poolStats;
    }

    private Properties decryptMaskedProperties(Properties maskedProps) throws ApplicationInitializationException {
        Properties result = PropertiesUtils.clone((Properties)maskedProps, (boolean)false);
        result.remove("ServiceName");
        String connectorBindingName = maskedProps.getProperty("ServiceName");
        if (connectorBindingName == null) {
            String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_get_connector_binding_name_from_connector_properties");
            throw new ApplicationInitializationException(msg);
        }
        Configuration currentConfig = null;
        try {
            currentConfig = CurrentConfiguration.getInstance().getConfiguration();
        }
        catch (ConfigurationException e) {
            Object[] params = new Object[]{connectorBindingName};
            String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_get_Configuration_for_connector_binding_{0}", params);
            throw new ApplicationInitializationException((Throwable)e, msg);
        }
        ConfigurationModelContainer configModel = null;
        try {
            configModel = CurrentConfiguration.getInstance().getConfigurationModel();
        }
        catch (ConfigurationException e) {
            Object[] params = new Object[]{connectorBindingName};
            String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_get_ConfigurationModelContainer_for_connector_binding_{0}", params);
            throw new ApplicationInitializationException((Throwable)e, msg);
        }
        ConnectorBinding configConnBinding = currentConfig.getConnectorBinding(connectorBindingName);
        if (configConnBinding != null) {
            ComponentType componentType = configModel.getComponentType(configConnBinding.getComponentTypeID().getName());
            if (componentType == null) {
                Object[] params = new Object[]{configConnBinding.getComponentTypeID().getName()};
                String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_get_connector_ComponentType_for_ComponentTyepID_name_{0}", params);
                throw new ApplicationInitializationException(msg);
            }
            Collection compTypeDefns = configModel.getAllComponentTypeDefinitions((ComponentTypeID)componentType.getID());
            for (ComponentTypeDefn typeDefn : compTypeDefns) {
                PropertyDefinition propDefn = typeDefn.getPropertyDefinition();
                String propName = propDefn.getName();
                String propValue = maskedProps.getProperty(propName);
                if (propValue == null) continue;
                if (propDefn.isMasked()) {
                    try {
                        propValue = CryptoUtil.stringDecrypt((String)propValue);
                    }
                    catch (CryptoException e) {
                        throw new ApplicationInitializationException((Throwable)e, ServerPlugin.Util.getString("ConnectorService.Failed_decrypting_masked_prop", new Object[]{propName}));
                    }
                }
                result.setProperty(propName, propValue);
            }
        }
        return result;
    }

    @Override
    public Map getCaches() throws MetaMatrixComponentException {
        HashMap<String, String> names = new HashMap<String, String>();
        names.put(RESULT_SET_CACHE_NAME, RESULT_SET_CACHE_NAME);
        return names;
    }

    @Override
    public void clearCache(String name, Properties props) throws MetaMatrixComponentException {
        if (name.equals(RESULT_SET_CACHE_NAME) && this.connectorMgr != null) {
            this.connectorMgr.clearCache();
        }
    }

    private static synchronized void clearClassLoaderCache() {
        LogManager.logInfo((String)"CONFIG", (String)"ConnectorService clearing ClassLoader cache");
        classLoaderCache.clear();
    }

    private static void logOK(String messageProperty, Object value) {
        LogManager.logInfo((String)"CONFIG", (String)ServerPlugin.Util.getString(messageProperty, new Object[]{value}));
    }

    static {
        cacheClassLoaders = PropertiesUtils.getBooleanProperty((Properties)CurrentConfiguration.getInstance().getProperties(), (String)"metamatrix.server.cacheConnectorClassLoaders", (boolean)false);
        ConnectorService.logOK("ConnectorService.Cache_class_loaders", new Boolean(cacheClassLoaders));
        ConnectorService.initExtensionModuleListener();
    }
}

