/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.dqp.config;

import com.google.inject.Binder;
import com.google.inject.name.Names;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.DQPConfigSource;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.service.CustomizableTrackingService;
import com.metamatrix.dqp.service.metadata.IndexMetadataService;
import com.metamatrix.dqp.service.metadata.QueryMetadataCache;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.server.dqp.service.PlatformAuthorizationService;
import com.metamatrix.server.dqp.service.PlatformBufferService;
import com.metamatrix.server.dqp.service.PlatformDataService;
import com.metamatrix.server.dqp.service.PlatformTransactionService;
import com.metamatrix.server.dqp.service.PlatformVDBService;
import com.metamatrix.server.dqp.service.tracker.DatabaseCommandLogger;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PlatformConfigSource
implements DQPConfigSource {
    public static final String PROC_DEBUG_ALLOWED = "metamatrix.server.procDebug";
    private Properties dqpProps;
    private Host host;
    private String processName;

    public PlatformConfigSource(Properties queryServiceProps, Properties currentConfiguration, Object clientId, Host host, String processName) {
        String streamingBatchSize;
        this.dqpProps = PropertiesUtils.clone((Properties)queryServiceProps, (Properties)currentConfiguration, (boolean)true);
        this.dqpProps.setProperty("ProcessPoolMaxThreads", queryServiceProps.getProperty("ProcessPoolMaxThreads"));
        this.dqpProps.setProperty("ProcessPoolThreadTTL", queryServiceProps.getProperty("ProcessPoolThreadTTL"));
        this.dqpProps.setProperty("MinFetchSize", queryServiceProps.getProperty("MinFetchSize"));
        this.dqpProps.setProperty("MaxFetchSize", queryServiceProps.getProperty("MaxFetchSize"));
        this.dqpProps.setProperty("MaxCodeTableRecords", queryServiceProps.getProperty("MaxCodeTableRecords"));
        this.dqpProps.setProperty("MaxCodeTables", queryServiceProps.getProperty("MaxCodeTables"));
        this.dqpProps.setProperty("ProcessorTimeslice", queryServiceProps.getProperty("ProcessorTimeslice"));
        this.dqpProps.setProperty("ResultSetCacheEnabled", queryServiceProps.getProperty("ResultSetCacheEnabled"));
        this.dqpProps.setProperty("ResultSetCacheMaxSize", queryServiceProps.getProperty("ResultSetCacheMaxSize"));
        this.dqpProps.setProperty("ResultSetCacheMaxAge", queryServiceProps.getProperty("ResultSetCacheMaxAge"));
        this.dqpProps.setProperty("ResultSetCacheScope", queryServiceProps.getProperty("ResultSetCacheScope"));
        this.dqpProps.setProperty("MaxPlanCacheSize", queryServiceProps.getProperty("MaxPlanCacheSize"));
        String procDebugStr = currentConfiguration.getProperty(PROC_DEBUG_ALLOWED);
        if (procDebugStr != null) {
            this.dqpProps.setProperty("ProcessorDebugAllowed", procDebugStr);
        }
        if ((streamingBatchSize = currentConfiguration.getProperty("metamatrix.server.streamingBatchSize")) != null) {
            this.dqpProps.setProperty("metamatrix.server.streamingBatchSize", streamingBatchSize);
        }
        if (this.dqpProps.getProperty("metamatrix.server.commandLoggerClassname") == null) {
            this.dqpProps.setProperty("metamatrix.server.commandLoggerClassname", DatabaseCommandLogger.class.getName());
        }
        this.host = host;
        this.processName = processName;
    }

    public Properties getProperties() {
        return this.dqpProps;
    }

    public Map<String, Class<? extends ApplicationService>> getDefaultServiceClasses() {
        HashMap<String, Class<? extends ApplicationService>> result = new HashMap<String, Class<? extends ApplicationService>>();
        result.put("dqp.tracking", CustomizableTrackingService.class);
        result.put("dqp.buffer", PlatformBufferService.class);
        result.put("dqp.vdb", PlatformVDBService.class);
        result.put("dqp.metadata", IndexMetadataService.class);
        result.put("dqp.data", PlatformDataService.class);
        result.put("dqp.transaction", PlatformTransactionService.class);
        result.put("dqp.authorization", PlatformAuthorizationService.class);
        return result;
    }

    public void updateBindings(Binder binder) {
        binder.bind(AuthorizationServiceInterface.class).toInstance((Object)PlatformProxyHelper.getAuthorizationServiceProxy("ROUND_ROBIN_LOCAL"));
        try {
            binder.bind(QueryMetadataCache.class).toInstance((Object)RuntimeMetadataCatalog.getInstance().getQueryMetadataCache());
        }
        catch (VirtualDatabaseException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        binder.bindConstant().annotatedWith((Annotation)Names.named((String)"ProcessName")).to(this.processName);
        binder.bind(Host.class).annotatedWith((Annotation)Names.named((String)"Host")).toInstance((Object)this.host);
    }
}

