/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.dqp.service;

import com.google.inject.Inject;
import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.api.exception.security.InvalidUserException;
import com.metamatrix.api.exception.security.MembershipServiceException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.dqp.service.AuthorizationService;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.BasicAuthorizationPermission;
import com.metamatrix.platform.security.api.BasicAuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.server.ServerPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class PlatformAuthorizationService
implements AuthorizationService {
    private static final BasicAuthorizationPermissionFactory PERMISSION_FACTORY = new BasicAuthorizationPermissionFactory();
    private boolean useEntitlements;
    private AuthorizationServiceInterface authInterface;

    @Inject
    public PlatformAuthorizationService(AuthorizationServiceInterface authInterface) {
        this.authInterface = authInterface;
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
        this.useEntitlements = PropertiesUtils.getBooleanProperty((Properties)props, (String)"metamatrix.authorization.dataaccess.CheckingEnabled", (boolean)false);
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    public void stop() throws ApplicationLifecycleException {
    }

    public Collection getInaccessibleResources(String connectionID, int action, Collection resources, int context) throws MetaMatrixComponentException {
        SessionToken token = DQPWorkContext.getWorkContext().getSessionToken();
        AuthorizationRealm realm = this.getRealm(DQPWorkContext.getWorkContext());
        AuthorizationActions actions = this.getActions(action);
        Collection permissions = this.createPermissions(realm, resources, actions);
        String auditContext = this.getAuditContext(context);
        Collection inaccessableResources = Collections.EMPTY_LIST;
        try {
            inaccessableResources = this.authInterface.getInaccessibleResources(token, auditContext, permissions);
        }
        catch (InvalidSessionException e) {
            throw new MetaMatrixComponentException((Throwable)e, ServerPlugin.Util.getString("PlatformAuthorizationService.Invalid_session"));
        }
        catch (AuthorizationMgmtException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        ArrayList<String> inaccessableResourceNames = Collections.EMPTY_LIST;
        if (inaccessableResources != null && inaccessableResources.size() > 0) {
            inaccessableResourceNames = new ArrayList<String>();
            for (AuthorizationPermission permission : inaccessableResources) {
                inaccessableResourceNames.add(permission.getResourceName());
            }
        }
        return inaccessableResourceNames;
    }

    public boolean hasRole(String connectionID, String roleType, String roleName) throws MetaMatrixComponentException {
        SessionToken token = DQPWorkContext.getWorkContext().getSessionToken();
        AuthorizationRealm realm = null;
        if ("admin".equalsIgnoreCase(roleType)) {
            realm = RolePermissionFactory.getRealm();
        } else if ("data".equalsIgnoreCase(roleType)) {
            realm = this.getRealm(DQPWorkContext.getWorkContext());
        } else {
            return false;
        }
        try {
            return this.authInterface.hasPolicy(token, realm, roleName);
        }
        catch (AuthorizationMgmtException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        catch (InvalidUserException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        catch (MembershipServiceException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        catch (ServiceException err) {
            throw new MetaMatrixComponentException((Throwable)((Object)err));
        }
    }

    public boolean checkingEntitlements() {
        return this.useEntitlements;
    }

    private AuthorizationRealm getRealm(DQPWorkContext context) {
        return new AuthorizationRealm(context.getVdbName(), context.getVdbVersion());
    }

    private AuthorizationActions getActions(int actionCode) {
        switch (actionCode) {
            case 0: {
                return StandardAuthorizationActions.DATA_READ;
            }
            case 1: {
                return StandardAuthorizationActions.DATA_CREATE;
            }
            case 2: {
                return StandardAuthorizationActions.DATA_UPDATE;
            }
            case 3: {
                return StandardAuthorizationActions.DATA_DELETE;
            }
        }
        return StandardAuthorizationActions.DATA_READ;
    }

    private Collection createPermissions(AuthorizationRealm realm, Collection resources, AuthorizationActions actions) {
        ArrayList<BasicAuthorizationPermission> permissions = new ArrayList<BasicAuthorizationPermission>(resources.size());
        for (String resource : resources) {
            BasicAuthorizationPermission permission = (BasicAuthorizationPermission)PERMISSION_FACTORY.create(resource, realm, actions);
            permissions.add(permission);
        }
        return permissions;
    }

    private String getAuditContext(int auditCode) {
        switch (auditCode) {
            case 0: {
                return "QUERY";
            }
            case 1: {
                return "INSERT";
            }
            case 2: {
                return "UPDATE";
            }
            case 3: {
                return "DELETE";
            }
            case 4: {
                return "STORED_PROCEDURE";
            }
        }
        return "QUERY";
    }
}

