/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.dqp.service;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.BufferManagerFactory;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.dqp.service.BufferService;
import java.util.Properties;

public class PlatformBufferService
implements BufferService {
    private BufferManager bufferMgr;
    private Properties props;
    private String processName;
    private Host host;

    @Inject
    public PlatformBufferService(@Named(value="Host") Host host, @Named(value="ProcessName") String processName) {
        this.host = host;
        this.processName = processName;
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
        this.props = PropertiesUtils.clone((Properties)props);
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        String dataDir = this.host.getDataDirectory();
        String relativeLoc = this.props.getProperty("metamatrix.buffer.relative.storageDirectory");
        String dir = FileUtils.buildDirectoryPath((String[])new String[]{dataDir, relativeLoc});
        this.props.setProperty("metamatrix.buffer.storageDirectory", dir);
        try {
            this.bufferMgr = BufferManagerFactory.getServerBufferManager((String)(this.host.getFullName() + "-" + this.processName), (Properties)this.props);
        }
        catch (MetaMatrixComponentException e) {
            throw new ApplicationLifecycleException((Throwable)e);
        }
    }

    public void stop() throws ApplicationLifecycleException {
        this.bufferMgr.stop();
    }
}

