/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.dqp.service;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ResultsReceiver;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.message.AtomicRequestID;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.AtomicResultsMessage;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.query.optimizer.capabilities.SourceCapabilities;
import com.metamatrix.server.ResourceFinder;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.server.connector.service.ConnectorServiceInterface;
import com.metamatrix.server.dqp.service.RemoteResultsReceiver;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.connector.api.ConnectorException;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class PlatformDataService
implements DataService {
    private ConcurrentHashMap<ConnectorID, ConnectorServiceInterface> connectors;

    public ConnectorID selectConnector(String connectorBindingID) {
        ArgCheck.isNotNull((Object)connectorBindingID);
        ConnectorServiceInterface connector = PlatformProxyHelper.getConnectorServiceProxy(connectorBindingID, "ROUND_ROBIN_LOCAL");
        ConnectorID connectorId = connector.getConnectorID();
        this.connectors.putIfAbsent(connectorId, connector);
        return connectorId;
    }

    public void executeRequest(AtomicRequestMessage request, ConnectorID connectorId, ResultsReceiver<AtomicResultsMessage> resultListener) throws MetaMatrixComponentException {
        ConnectorServiceInterface serverInstance = this.getConnector(connectorId);
        RemoteResultsReceiver receiver = new RemoteResultsReceiver(ResourceFinder.getMessageBus());
        receiver.setActualReceiver(resultListener);
        serverInstance.executeRequest(request, receiver);
    }

    private ConnectorServiceInterface getConnector(ConnectorID connectorId) throws MetaMatrixComponentException {
        ConnectorServiceInterface serverInstance = this.connectors.get(connectorId);
        if (serverInstance == null) {
            throw new MetaMatrixComponentException(ServerPlugin.Util.getString("DQPDataService.Unable_to_find_a_connector_for_connector_ID__{0}", new Object[]{connectorId}));
        }
        return serverInstance;
    }

    public void cancelRequest(AtomicRequestID request, ConnectorID connectorId) throws MetaMatrixComponentException {
        ConnectorServiceInterface serverInstance = this.getConnector(connectorId);
        serverInstance.cancelRequest(request);
    }

    public void closeRequest(AtomicRequestID request, ConnectorID connectorId) throws MetaMatrixComponentException {
        ConnectorServiceInterface serverInstance = this.getConnector(connectorId);
        serverInstance.closeRequest(request);
    }

    public void requestBatch(AtomicRequestID request, ConnectorID connectorId) throws MetaMatrixComponentException {
        ConnectorServiceInterface serverInstance = this.getConnector(connectorId);
        serverInstance.requestBatch(request);
    }

    public SourceCapabilities getCapabilities(RequestMessage request, DQPWorkContext dqpWorkContext, ConnectorID connectorId) throws MetaMatrixComponentException {
        ConnectorServiceInterface serverInstance = this.getConnector(connectorId);
        try {
            return serverInstance.getCapabilities(dqpWorkContext.getRequestID(request.getExecutionId()), request.getExecutionPayload(), dqpWorkContext);
        }
        catch (ConnectorException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
        this.connectors = new ConcurrentHashMap();
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    public void stop() throws ApplicationLifecycleException {
    }

    public void startConnectorBinding(String connectorBindingName) throws ApplicationLifecycleException, ComponentNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void stopConnectorBinding(String connectorBindingName) throws ApplicationLifecycleException, ComponentNotFoundException {
        throw new UnsupportedOperationException();
    }

    public List getConnectorBindings() throws ComponentNotFoundException {
        throw new UnsupportedOperationException();
    }

    public Boolean getConnectorBindingState(String connectorBindingName) throws MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }

    public ConnectorBinding getConnectorBinding(String connectorBindingName) throws MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }

    public Collection getConnectorBindingStatistics(String connectorBindingName) throws MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }

    public void clearConnectorBindingCache(String connectorBindingName) throws MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }
}

