/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.dqp.service;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.dqp.transaction.TransactionServer;
import com.metamatrix.dqp.transaction.XAServer;
import com.metamatrix.xa.arjuna.ArjunaTransactionProvider;
import java.util.Map;
import java.util.Properties;
import org.teiid.dqp.internal.transaction.TransactionProvider;
import org.teiid.dqp.internal.transaction.TransactionServerImpl;

public class PlatformTransactionService
implements TransactionService {
    private TransactionServerImpl arjunaTs = new TransactionServerImpl();
    private TransactionServer ts;
    private Host host;

    @Inject
    public PlatformTransactionService(@Named(value="Host") Host host) {
        this.host = host;
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
        try {
            Properties env = null;
            try {
                env = CurrentConfiguration.getInstance().getResourceProperties("XATransactionManager");
            }
            catch (ConfigurationException e) {
                throw new ApplicationInitializationException((Throwable)e);
            }
            String hostLogDir = this.host.getLogDirectory();
            String txnLogDir = env.getProperty("metamatrix.xatxnmgr.log_base_dir", "txnlog");
            String logDir = FileUtils.buildDirectoryPath((String[])new String[]{hostLogDir, txnLogDir});
            props.putAll((Map<?, ?>)env);
            props.setProperty("metamatrix.xatxnmgr.log_base_dir", logDir);
            props.setProperty("metamatrix.xatxnmgr.hostname", this.host.getFullName());
            props.setProperty("metamatrix.xatxnmgr.vmname", VMNaming.getProcessName());
            props.setProperty("metamatrix.xatxnmgr.txnstore_dir", this.host.getDataDirectory());
            this.arjunaTs.init((TransactionProvider)ArjunaTransactionProvider.getInstance((Properties)props));
            Class[] interfaces = new Class[]{TransactionServer.class, XAServer.class};
            this.ts = (TransactionServer)LogManager.createLoggingProxy((String)"XA_TXN", (Object)this.arjunaTs, (Class[])interfaces, (int)5);
        }
        catch (XATransactionException err) {
            throw new ApplicationInitializationException((Throwable)err);
        }
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    public void stop() throws ApplicationLifecycleException {
        this.arjunaTs.shutdown(true);
    }

    public TransactionServer getTransactionServer() {
        return this.ts;
    }

    public XAServer getXAServer() {
        return (XAServer)this.ts;
    }
}

