/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.dqp.service;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.vdb.api.SystemVdbUtility;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.event.RuntimeMetadataEvent;
import com.metamatrix.metadata.runtime.event.RuntimeMetadataListener;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseDoesNotExistException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.vdb.runtime.VDBKey;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PlatformVDBService
implements VDBService,
RuntimeMetadataListener {
    private Map vdbIDs = Collections.synchronizedMap(new HashMap());
    private EventObjectListener listener = null;

    public boolean isActiveVDB(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        try {
            RuntimeMetadataCatalog.getInstance().getActiveVirtualDatabaseID(vdbName, vdbVersion);
        }
        catch (VirtualDatabaseDoesNotExistException e) {
            return false;
        }
        catch (VirtualDatabaseException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        return true;
    }

    public List getConnectorBindingNames(String vdbName, String vdbVersion, String modelName) throws MetaMatrixComponentException {
        if (modelName.equalsIgnoreCase("SystemPhysical") || modelName.equalsIgnoreCase("SystemAdminPhysical")) {
            ArrayList<String> bindings = new ArrayList<String>(1);
            bindings.add("RuntimeMetadataService");
            return bindings;
        }
        try {
            VirtualDatabaseID vdbID = this.getVirtualDatabaseID(vdbName, vdbVersion);
            Model model = RuntimeMetadataCatalog.getInstance().getModel(modelName, vdbID);
            if (model == null) {
                throw new MetaMatrixComponentException(ServerPlugin.Util.getString("PlatformVDBService.Model_not_found_in_vdb", new Object[]{modelName, vdbName}));
            }
            return model.getConnectorBindingNames();
        }
        catch (VirtualDatabaseException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public int getModelVisibility(String vdbName, String vdbVersion, String modelName) throws MetaMatrixComponentException {
        if (modelName.equalsIgnoreCase("SystemPhysical") || modelName.equalsIgnoreCase("SystemAdminPhysical")) {
            return 2;
        }
        if (SystemVdbUtility.isSystemModelWithSystemTableType((String)modelName)) {
            return 0;
        }
        try {
            VirtualDatabaseID vdbID = this.getVirtualDatabaseID(vdbName, vdbVersion);
            Model model = RuntimeMetadataCatalog.getInstance().getModel(modelName, vdbID);
            if (model == null) {
                return 2;
            }
            return model.getVisibility();
        }
        catch (VirtualDatabaseException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public int getFileVisibility(String vdbName, String vdbVersion, String pathInVDB) throws MetaMatrixComponentException {
        String modelName = StringUtil.getFirstToken((String)StringUtil.getLastToken((String)pathInVDB, (String)"/"), (String)".");
        if (StringUtil.endsWithIgnoreCase((String)modelName, (String)"SystemPhysical") || StringUtil.endsWithIgnoreCase((String)modelName, (String)"SystemAdminPhysical")) {
            return 2;
        }
        if (SystemVdbUtility.isSystemModelWithSystemTableType((String)modelName)) {
            return 0;
        }
        try {
            VirtualDatabaseID vdbID = this.getVirtualDatabaseID(vdbName, vdbVersion);
            boolean isVisible = RuntimeMetadataCatalog.getInstance().isVisible(pathInVDB, vdbID);
            if (isVisible) {
                return 0;
            }
            return 2;
        }
        catch (VirtualDatabaseException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        this.registerVdbListner();
    }

    public void stop() throws ApplicationLifecycleException {
        this.removeVdbListner();
    }

    private VirtualDatabaseID getVirtualDatabaseID(String vdbName, String vdbVersion) throws VirtualDatabaseDoesNotExistException, VirtualDatabaseException {
        VDBKey vdbKey = new VDBKey(vdbName, vdbVersion);
        VirtualDatabaseID vdbID = null;
        vdbID = (VirtualDatabaseID)this.vdbIDs.get(vdbKey);
        if (vdbID == null) {
            vdbID = RuntimeMetadataCatalog.getInstance().getActiveVirtualDatabaseID(vdbName, vdbVersion);
            this.vdbIDs.put(vdbKey, vdbID);
        }
        return vdbID;
    }

    private void removeVirtualDatabaseID(VirtualDatabaseID vdbID) {
        VDBKey vdbKey = new VDBKey(vdbID.getName(), vdbID.getVersion());
        LogManager.logTrace((String)"QUERY_SERVICE", (Object[])new Object[]{"PlatformVDBService removing vdb ", vdbKey});
        this.vdbIDs.remove(vdbKey);
    }

    public String getConnectorName(String connectorBindingID) throws MetaMatrixComponentException {
        Configuration operational = CurrentConfiguration.getInstance().getConfiguration();
        ConnectorBinding bindingName = operational.getConnectorBindingByRoutingID(connectorBindingID);
        if (bindingName != null) {
            return bindingName.toString();
        }
        return "UNKNOWN";
    }

    @Override
    public void processEvent(RuntimeMetadataEvent event) {
        if (event.deleteVDB()) {
            VirtualDatabaseID vdbID = event.getVirtualDatabaseID();
            this.removeVirtualDatabaseID(vdbID);
        }
    }

    private void registerVdbListner() {
        try {
            this.listener = RuntimeMetadataCatalog.getInstance().registerRuntimeMetadataListener(this);
        }
        catch (Exception e) {
            LogManager.logError((String)"SERVICE", (Throwable)e, (String)ServerPlugin.Util.getString("PlatformVDBService.0"));
        }
    }

    private void removeVdbListner() {
        try {
            if (this.listener != null) {
                RuntimeMetadataCatalog.getInstance().removeRuntimeMetadataListener(this.listener);
            }
        }
        catch (Exception e) {
            LogManager.logError((String)"SERVICE", (Throwable)e, (String)ServerPlugin.Util.getString("PlatformVDBService.1"));
        }
    }

    public List getMultiSourceModels(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        try {
            VirtualDatabaseID vdbID = this.getVirtualDatabaseID(vdbName, vdbVersion);
            return RuntimeMetadataCatalog.getInstance().getMutiSourcedModels(vdbID);
        }
        catch (VirtualDatabaseException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public InputStream getVDBResource(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        try {
            VirtualDatabaseID vdbID = this.getVirtualDatabaseID(vdbName, vdbVersion);
            byte[] bytes = RuntimeMetadataCatalog.getInstance().getVDBArchive(vdbID);
            return new ByteArrayInputStream(bytes);
        }
        catch (VirtualDatabaseDoesNotExistException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        catch (VirtualDatabaseException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public int getVDBStatus(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }

    public void changeVDBStatus(String vdbName, String vdbVersion, int status) throws ApplicationLifecycleException, MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }

    public List getAvailableVDBs() throws MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }
}

