/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.dqp.service;

import com.metamatrix.common.comm.api.ResultsReceiver;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.dqp.message.AtomicResultsMessage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RemoteResultsReceiver
implements ResultsReceiver<AtomicResultsMessage>,
Externalizable {
    private ResultsReceiver<AtomicResultsMessage> actualReceiver;
    private Object stub;
    private MessageBus messageBus;

    public RemoteResultsReceiver() {
    }

    public RemoteResultsReceiver(MessageBus bus) {
        this.messageBus = bus;
    }

    public void setActualReceiver(ResultsReceiver<AtomicResultsMessage> actualReceiver) {
        this.actualReceiver = actualReceiver;
    }

    public void exceptionOccurred(Throwable e) {
        this.actualReceiver.exceptionOccurred(e);
        this.shutdown();
    }

    public void receiveResults(AtomicResultsMessage results) {
        this.actualReceiver.receiveResults((Object)results);
        if (results.isRequestClosed()) {
            this.shutdown();
        }
    }

    @Override
    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
        this.stub = arg0.readObject();
        this.actualReceiver = (ResultsReceiver)this.messageBus.getRPCProxy(this.stub);
    }

    @Override
    public void writeExternal(ObjectOutput arg0) throws IOException {
        this.stub = this.messageBus.export(this, new Class[]{ResultsReceiver.class});
    }

    public void shutdown() {
        if (this.stub != null) {
            this.messageBus.unExport(this.stub);
        }
    }
}

