/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.dqp.service.tracker;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.dqp.spi.CommandLoggerSPI;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.server.dqp.service.tracker.TransactionLogMessage;
import com.metamatrix.server.dqp.service.tracker.TransactionLogWriter;
import java.util.Properties;
import org.teiid.connector.api.ExecutionContext;

public class DatabaseCommandLogger
implements CommandLoggerSPI {
    private boolean isStopped = false;
    private TransactionLogWriter writer;

    public boolean isStopped() {
        return this.isStopped;
    }

    public void initialize(Properties props) {
        this.writer = new TransactionLogWriter(props);
    }

    public void close() {
        LogManager.logInfo((String)"TXN_LOG", (String)ServerPlugin.Util.getString("MSG.003.031.0006"));
        this.isStopped = true;
        this.writer.shutdown();
    }

    public void dataSourceCommandEnd(long timestamp, String requestID, long sourceCommandID, String subTransactionID, String modelName, String connectorBindingName, String sessionID, String principal, int finalRowCount, boolean isCancelled, boolean errorOccurred, ExecutionContext context) {
        short status = 2;
        if (isCancelled) {
            status = 3;
        } else if (errorOccurred) {
            status = 4;
        }
        this.writer.print(new TransactionLogMessage(requestID, sourceCommandID, subTransactionID, status, modelName, connectorBindingName, 2, sessionID, principal, null, finalRowCount, timestamp));
    }

    public void dataSourceCommandStart(long timestamp, String requestID, long sourceCommandID, String subTransactionID, String modelName, String connectorBindingName, String sessionID, String principal, String sql, ExecutionContext context) {
        this.writer.print(new TransactionLogMessage(requestID, sourceCommandID, subTransactionID, 1, modelName, connectorBindingName, 1, sessionID, principal, sql, -1, timestamp));
    }

    public void userCommandEnd(long timestamp, String requestID, String transactionID, String sessionID, String principal, String vdbName, String vdbVersion, int finalRowCount, boolean isCancelled, boolean errorOccurred) {
        short status = 2;
        if (isCancelled) {
            status = 3;
        } else if (errorOccurred) {
            status = 4;
        }
        this.writer.print(new TransactionLogMessage(requestID, transactionID, 2, status, sessionID, null, principal, vdbName, vdbVersion, null, finalRowCount, timestamp));
    }

    public void userCommandStart(long timestamp, String requestID, String transactionID, String sessionID, String applicationName, String principal, String vdbName, String vdbVersion, String sql) {
        this.writer.print(new TransactionLogMessage(requestID, transactionID, 1, 1, sessionID, applicationName, principal, vdbName, vdbVersion, sql, -1, timestamp));
    }
}

