/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.query.service;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.server.InvalidRequestIDException;
import com.metamatrix.common.application.DQPConfigSource;
import com.metamatrix.common.comm.ClientServiceRegistry;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.controller.AbstractService;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.function.FunctionMetadataSource;
import com.metamatrix.query.function.UDFSource;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.server.dqp.config.PlatformConfigSource;
import com.metamatrix.server.query.service.QueryServiceInterface;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.teiid.dqp.internal.process.DQPCore;

public class QueryService
extends AbstractService
implements QueryServiceInterface {
    private static final String CLASSPATH_DELIMITER = ";";
    private static final String CODE_TABLE_CACHE_NAME = "CodeTableCache";
    private static final String PLAN_CACHE_NAME = "PreparedPlanCache";
    private static final String RESULT_SET_CACHE_NAME = "QueryServiceResultSetCache";
    private DQPCore dqp;

    @Override
    protected void initService(Properties props) throws Exception {
        String udfSource = null;
        try {
            udfSource = props.getProperty("UDFSource", "FunctionDefinitions.xmi");
            if (udfSource != null) {
                this.registerUDFSource(udfSource);
            }
        }
        catch (IOException t) {
            LogManager.logError((String)"QUERY_SERVICE", (Throwable)t, (String)ServerPlugin.Util.getString("QueryService.Unable_to_register_user-defined_function_source__{0}_1", new Object[]{udfSource}));
        }
        PlatformConfigSource configSource = new PlatformConfigSource(props, CurrentConfiguration.getInstance().getProperties(), new Long(this.getID().getID()), CurrentConfiguration.getInstance().getDefaultHost(), VMNaming.getProcessName());
        this.dqp = new DQPCore();
        this.dqp.start((DQPConfigSource)configSource);
    }

    private void registerUDFSource(String udfSource) throws IOException {
        try {
            InputStream in = this.retrieveUDFStream(udfSource);
            if (in != null) {
                FunctionLibraryManager.registerSource((FunctionMetadataSource)new UDFSource(in, Thread.currentThread().getContextClassLoader()));
            }
        }
        catch (ExtensionModuleNotFoundException e) {
            LogManager.logDetail((String)"CONFIG", (Throwable)e, (String)ServerPlugin.Util.getString("QueryService.no_udf"));
        }
        catch (MetaMatrixComponentException e) {
            LogManager.logDetail((String)"CONFIG", (Throwable)e, (String)ServerPlugin.Util.getString("QueryService.no_udf"));
        }
    }

    private InputStream retrieveUDFStream(String udfSource) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        byte[] xmlData = ExtensionModuleManager.getInstance().getSource(udfSource);
        return new ByteArrayInputStream(xmlData);
    }

    @Override
    protected void closeService() throws Exception {
        this.dqp.stop();
    }

    @Override
    protected void waitForServiceToClear() throws Exception {
    }

    @Override
    protected void killService() {
        try {
            this.closeService();
        }
        catch (Exception e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    @Override
    public void clearCache(SessionToken sessionToken) throws ComponentNotFoundException {
    }

    @Override
    public Collection getAllQueries() {
        return this.dqp.getRequests();
    }

    @Override
    public void cancelQueries(SessionToken sessionToken, boolean shouldRollback) throws InvalidRequestIDException, MetaMatrixComponentException {
        this.dqp.terminateConnection(sessionToken.getSessionID().toString());
    }

    @Override
    public Collection getQueriesForSession(SessionToken userToken) {
        return this.dqp.getRequestsByClient(userToken.getSessionID().toString());
    }

    @Override
    public void cancelQuery(RequestID requestID, boolean shouldRollback) throws InvalidRequestIDException, MetaMatrixComponentException {
        if (!this.dqp.cancelRequest(requestID)) {
            throw new InvalidRequestIDException(DQPPlugin.Util.getString("DQPCore.failed_to_cancel"));
        }
    }

    @Override
    public void cancelQuery(RequestID requestID, int nodeID) throws InvalidRequestIDException, MetaMatrixComponentException {
        this.dqp.cancelAtomicRequest(requestID, nodeID);
    }

    @Override
    public Collection getQueueStatistics() {
        return this.dqp.getQueueStatistics();
    }

    @Override
    public WorkerPoolStats getQueueStatistics(String name) {
        Object aPoolStat;
        Iterator resultsItr;
        WorkerPoolStats poolStats = new WorkerPoolStats();
        Collection results = this.dqp.getQueueStatistics(name);
        if (results != null && (resultsItr = results.iterator()).hasNext() && (aPoolStat = resultsItr.next()) != null && aPoolStat instanceof WorkerPoolStats) {
            poolStats = (WorkerPoolStats)aPoolStat;
        }
        return poolStats;
    }

    @Override
    public Map getCaches() throws MetaMatrixComponentException {
        HashMap<String, String> names = new HashMap<String, String>();
        names.put(CODE_TABLE_CACHE_NAME, CODE_TABLE_CACHE_NAME);
        names.put(PLAN_CACHE_NAME, PLAN_CACHE_NAME);
        names.put(RESULT_SET_CACHE_NAME, RESULT_SET_CACHE_NAME);
        return names;
    }

    @Override
    public void clearCache(String name, Properties props) throws MetaMatrixComponentException {
        if (name.equals(CODE_TABLE_CACHE_NAME)) {
            this.dqp.clearCodeTableCache();
        } else if (name.equals(PLAN_CACHE_NAME)) {
            this.dqp.clearPlanCache();
        } else if (name.equals(RESULT_SET_CACHE_NAME)) {
            this.dqp.clearResultSetCache();
        }
    }

    @Override
    public void init(ServiceID id, DeployedComponentID deployedComponentID, Properties props, ClientServiceRegistry listenerRegistry) {
        super.init(id, deployedComponentID, props, listenerRegistry);
        listenerRegistry.registerClientService(ClientSideDQP.class, (Object)this.dqp, "QUERY_SERVICE");
    }
}

