/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.util;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.metadata.runtime.RuntimeVDBDeleteUtility;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.SessionTerminationHandler;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.server.query.service.QueryServiceInterface;

public class DataServerSessionTerminationHandler
implements SessionTerminationHandler {
    public static final String PRODUCT_NAME = "Integration Server";
    private QueryServiceInterface queryServiceProxy;

    @Override
    public String getProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public void cleanup(SessionToken token) throws Exception {
        Object[] params;
        try {
            this.getQueryServiceProxy().cancelQueries(token, true);
        }
        catch (Exception e) {
            params = new Object[]{token.getSessionID()};
            LogManager.logWarning((String)"CONFIG", (Throwable)e, (String)ServerPlugin.Util.getString("DataServerSessionTerminationHandler.Error_communicating_with_QueryService__Could_not_cancel_queries_for_{0}", params));
        }
        try {
            this.getQueryServiceProxy().clearCache(token);
        }
        catch (Exception e) {
            params = new Object[]{token.getSessionID()};
            LogManager.logWarning((String)"CONFIG", (Throwable)e, (String)ServerPlugin.Util.getString("DataServerSessionTerminationHandler.Error_communicating_with_QueryService__Could_not_clear_cache_for_{0}", params));
        }
        try {
            RuntimeVDBDeleteUtility vdbDeleter = new RuntimeVDBDeleteUtility();
            vdbDeleter.deleteVDBsMarkedForDelete(token.getSessionID());
        }
        catch (Exception e) {
            params = new Object[]{token.getSessionID()};
            LogManager.logWarning((String)"CONFIG", (Throwable)e, (String)ServerPlugin.Util.getString("DataServerSessionTerminationHandler.Error_deleting_VDB_vesions_for_{0}", params));
        }
    }

    private QueryServiceInterface getQueryServiceProxy() throws ServiceException {
        if (this.queryServiceProxy == null) {
            this.queryServiceProxy = PlatformProxyHelper.getQueryServiceProxy("ROUND_ROBIN_LOCAL");
        }
        return this.queryServiceProxy;
    }
}

