/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.service;

import com.metamatrix.common.jdbc.SimplePooledConnectionSource;
import com.metamatrix.soap.service.ConnectionPoolFactory;
import java.util.Properties;
import javax.sql.DataSource;

public class BasicConnectionPoolFactory
implements ConnectionPoolFactory {
    private static final Properties defaultProperties = new Properties();

    public DataSource createConnectionPool(Properties poolProperties) {
        if (poolProperties == null) {
            return null;
        }
        Properties p = new Properties(poolProperties);
        p.setProperty("metamatrix.common.pooling.jdbc.Driver", "com.metamatrix.jdbc.MMDriver");
        p.setProperty("metamatrix.common.pooling.jdbc.User", poolProperties.getProperty("Username"));
        p.setProperty("metamatrix.common.pooling.jdbc.Password", poolProperties.getProperty("Password"));
        p.setProperty("metamatrix.common.pooling.jdbc.Database", poolProperties.getProperty("ServerURL"));
        p.setProperty("pooling.resource.pool.maximum.size", this.getProperty("com.metamatrix.soap.service.maxactiveconnections"));
        p.setProperty("pooling.resource.pool.wait.time", this.getProperty("com.metamatrix.soap.service.maxwait"));
        return new SimplePooledConnectionSource(p);
    }

    protected String getProperty(String propKey) {
        return System.getProperty(propKey, defaultProperties.getProperty(propKey));
    }

    static {
        defaultProperties.setProperty("com.metamatrix.soap.service.initpoolsize", String.valueOf(1));
        defaultProperties.setProperty("com.metamatrix.soap.service.maxactiveconnections", String.valueOf(25));
        defaultProperties.setProperty("com.metamatrix.soap.service.maxidleconnections", String.valueOf(10));
        defaultProperties.setProperty("com.metamatrix.soap.service.maxwait", String.valueOf(30000));
        defaultProperties.setProperty("com.metamatrix.soap.service.minidlecount", String.valueOf(0));
        defaultProperties.setProperty("com.metamatrix.soap.service.minevictableidletime", String.valueOf(600000));
        defaultProperties.setProperty("com.metamatrix.soap.service.timebetweenevictionthreadruns", String.valueOf(60000));
    }
}

