/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.service;

import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.jdbc.api.SQLStates;
import com.metamatrix.soap.SOAPPlugin;
import com.metamatrix.soap.exceptions.SOAPProcessingException;
import com.metamatrix.soap.security.Credential;
import com.metamatrix.soap.service.ConnectionSource;
import com.metamatrix.soap.service.DataServiceInfo;
import com.metamatrix.soap.service.PoolingConnectionSource;
import com.metamatrix.soap.sqlquerywebservice.log.LogUtil;
import com.metamatrix.soap.util.EndpointUriTranslatorStrategyImpl;
import com.metamatrix.soap.util.WebServiceUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class DataServiceWebServiceImpl {
    public static final String SOAP_11_STANDARD_CLIENT_FAULT_CODE = "Client";
    public static final String SOAP_11_STANDARD_SERVER_FAULT_CODE = "Server";
    private static final String EMPTY_STRING = "";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SINGLE_QUOTE = "'";
    public static final String USER_NAME = "user";
    public static final String PASSWORD = "password";
    public static final String ERROR_PREFIX = "Procedure error: ";
    private ConnectionSource connectionSource = PoolingConnectionSource.getInstance();

    public DataServiceWebServiceImpl() {
    }

    public DataServiceWebServiceImpl(MessageFactory factory, ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement executeDataService(OMElement element) throws AxisFault {
        MessageContext context = MessageContext.getCurrentMessageContext();
        SOAPBody reqBody = null;
        reqBody = context.getEnvelope().getBody();
        String inputMessage = EMPTY_STRING;
        DataServiceInfo info = null;
        try {
            info = this.getDataServiceInfo(element);
        }
        catch (Exception e2) {
            this.createSOAPFaultMessage(e2, e2.getMessage(), SOAP_11_STANDARD_SERVER_FAULT_CODE);
        }
        List bodyElements = this.getBodyElements(reqBody);
        if (bodyElements != null && bodyElements.size() == 1) {
            inputMessage = StringUtil.replaceAll((String)bodyElements.get(0).toString(), (String)DOUBLE_QUOTE, (String)SINGLE_QUOTE);
        } else if (bodyElements.size() > 1) {
            String message = SOAPPlugin.Util.getString("DataServiceWebServiceImpl.2");
            this.createSOAPFaultMessage((Exception)new SOAPException(message), message, SOAP_11_STANDARD_CLIENT_FAULT_CODE);
        }
        String returnFragment = null;
        Connection connection = null;
        try {
            connection = this.getConnection(info);
            String procedure = this.getVirtualProcedure(info);
            boolean noParm = false;
            if (inputMessage.equals(EMPTY_STRING)) {
                noParm = true;
            }
            String executeStatement = "{?=call " + procedure + (noParm ? "()}" : "(?)}");
            CallableStatement statement = connection.prepareCall(executeStatement);
            if (!noParm) {
                statement.setString(1, inputMessage);
            }
            statement.setQueryTimeout(this.getQueryTimeout());
            boolean hasResultSet = statement.execute();
            if (hasResultSet) {
                String params;
                ResultSet set = statement.getResultSet();
                if (set.next()) {
                    returnFragment = set.getString(1);
                } else {
                    params = procedure;
                    LogUtil.log((int)2, (String)SOAPPlugin.Util.getString("DataServiceWebServiceImpl.8"));
                    this.createSOAPFaultMessage(new Exception(SOAPPlugin.Util.getString("DataServiceWebServiceImpl.7", new Object[]{params})), SOAPPlugin.Util.getString("DataServiceWebServiceImpl.7", new Object[]{params}), SOAP_11_STANDARD_SERVER_FAULT_CODE);
                }
                if (set.next()) {
                    params = procedure;
                    String message = SOAPPlugin.Util.getString("DataServiceWebServiceImpl.1", new Object[]{params});
                    this.createSOAPFaultMessage((Exception)new SQLException(message), message, SOAP_11_STANDARD_SERVER_FAULT_CODE);
                }
                element = this.getElement(returnFragment);
                set.close();
            }
            statement.close();
        }
        catch (Exception e) {
            SQLException sqlException;
            String faultcode = SOAP_11_STANDARD_SERVER_FAULT_CODE;
            Object[] params = new Object[]{e};
            String msg = SOAPPlugin.Util.getString("DataServiceWebServiceImpl.6", params);
            LogUtil.log((int)2, (Throwable)e, (String)msg);
            if (e instanceof SQLException && SQLStates.isUsageErrorState((String)(sqlException = (SQLException)e).getSQLState())) {
                faultcode = SOAP_11_STANDARD_CLIENT_FAULT_CODE;
            }
            element = this.createSOAPFaultMessage(e, e.getMessage(), faultcode);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                LogUtil.log((int)3, (String)SOAPPlugin.Util.getString("DataServiceWebServiceImpl.3"));
            }
        }
        return element;
    }

    protected Connection getConnection(DataServiceInfo info) throws SOAPException, AxisFault {
        Properties connectionProperties = new Properties();
        String userName = EMPTY_STRING;
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        if (msgCtx == null) {
            String message = SOAPPlugin.Util.getString("DataServiceWebServiceImpl.0");
            this.createSOAPFaultMessage((Exception)new SQLException(message), message, SOAP_11_STANDARD_CLIENT_FAULT_CODE);
        }
        Credential credential = null;
        credential = WebServiceUtil.getCredentials((MessageContext)msgCtx);
        userName = credential.getUserName();
        connectionProperties.setProperty("Username", userName);
        connectionProperties.setProperty("Password", new String(credential.getPassword()));
        connectionProperties.setProperty("ServerURL", info.getServerURL());
        Connection connection = null;
        try {
            connection = this.connectionSource.getConnection(connectionProperties);
        }
        catch (Exception e) {
            throw new SOAPException(SOAPPlugin.Util.getString("DataServiceWebServiceImpl.12", new Object[]{userName, e.getMessage()}), (Throwable)e);
        }
        return connection;
    }

    protected Properties getAuthenticationProperties(String username, String password) {
        Properties props = new Properties();
        if (username != null) {
            props.setProperty(USER_NAME, username);
        }
        if (password != null) {
            props.setProperty(PASSWORD, password);
        }
        return props;
    }

    protected DataServiceInfo getDataServiceInfo(OMElement element) throws SOAPProcessingException {
        return EndpointUriTranslatorStrategyImpl.getDataServiceInfo();
    }

    protected OMElement createSOAPFaultMessage(Exception e, String faultMessageString, String faultCode) throws AxisFault {
        LogUtil.log((int)2, (Throwable)e, (String)faultMessageString);
        AxisFault fault = new AxisFault(faultMessageString, faultCode);
        throw fault;
    }

    private List getBodyElements(SOAPBody body) {
        LinkedList elements = new LinkedList();
        if (body == null) {
            return elements;
        }
        Iterator iter = body.getChildElements();
        if (iter != null) {
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof OMElement)) continue;
                elements.add(obj);
            }
        }
        return elements;
    }

    private OMElement getElement(String result) throws AxisFault {
        StAXOMBuilder builder = null;
        try {
            builder = new StAXOMBuilder(ByteArrayHelper.toInputStream((byte[])result.getBytes()));
        }
        catch (XMLStreamException e) {
            Object[] params1 = new Object[]{result};
            Object[] params2 = new Object[]{e.getMessage()};
            String s1 = SOAPPlugin.Util.getString("DataServiceWebServiceImpl.9", params1);
            LogUtil.log((int)2, (Throwable)e, (String)s1);
            String s2 = SOAPPlugin.Util.getString("DataServiceWebServiceImpl.10", params2);
            this.createSOAPFaultMessage((Exception)e, s2, SOAP_11_STANDARD_SERVER_FAULT_CODE);
        }
        catch (Exception e) {
            this.createSOAPFaultMessage(e, e.getMessage(), SOAP_11_STANDARD_SERVER_FAULT_CODE);
        }
        OMElement documentElement = builder.getDocumentElement();
        return documentElement;
    }

    protected int getQueryTimeout() {
        int timeout = 0;
        if (System.getProperty("com.metamatrix.webservice.querytimeout") != null) {
            try {
                timeout = Integer.parseInt(System.getProperty("com.metamatrix.webservice.querytimeout"));
            }
            catch (NumberFormatException nfe) {
                LogUtil.log((int)3, (Throwable)nfe, (String)SOAPPlugin.Util.getString("DataServiceWebServiceImpl.16"));
                timeout = 0;
            }
        }
        return timeout;
    }

    private String getVirtualProcedure(DataServiceInfo info) {
        String storedProc = info.getDataServiceFullPath();
        return StringUtil.replaceAll((String)storedProc, (String)DOUBLE_QUOTE, (String)EMPTY_STRING);
    }
}

