/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.service;

import com.metamatrix.soap.SOAPPlugin;
import com.metamatrix.soap.service.BasicConnectionPoolFactory;
import com.metamatrix.soap.service.ConnectionPoolFactory;
import com.metamatrix.soap.service.ConnectionSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class PoolingConnectionSource
implements ConnectionSource {
    private static PoolingConnectionSource INSTANCE = new PoolingConnectionSource();
    private ConnectionPoolFactory poolFactory;
    private Map pools = new HashMap();

    public PoolingConnectionSource() {
        this.poolFactory = new BasicConnectionPoolFactory();
    }

    public PoolingConnectionSource(ConnectionPoolFactory poolFactory) {
        this.poolFactory = poolFactory;
    }

    public static PoolingConnectionSource getInstance() {
        return INSTANCE;
    }

    public Connection getConnection(Properties connectionProperties) throws SQLException {
        DataSource source;
        if (this.poolFactory == null) {
            throw new SQLException(SOAPPlugin.Util.getString("BasicConnectionPool.The_connection_pool_factory_given_the_Pooling_Connection_Source"));
        }
        Object pool = this.pools.get(connectionProperties);
        if (pool == null) {
            pool = this.createPool(connectionProperties);
            this.pools.put(connectionProperties, pool);
        }
        if ((source = (DataSource)pool) != null) {
            return source.getConnection();
        }
        throw new SQLException(SOAPPlugin.Util.getString("PoolingConnectionSource.The_DataSource_instance_pulled_from_the"));
    }

    private Object createPool(Properties properties) throws SQLException {
        return this.poolFactory.createConnectionPool(properties);
    }

    protected boolean hasPool(Properties connectionProperties) {
        return this.pools.get(connectionProperties) != null;
    }
}

