/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.servlet;

import com.metamatrix.common.util.WSDLServletUtil;
import com.metamatrix.soap.SOAPPlugin;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class MMGetVDBResourceServlet
extends HttpServlet {
    protected static final String procString = "{?=call System.getUpdatedCharacterVDBResource(?,?,?)}";
    protected static final String DATASERVICE = "/services/service";
    protected static final String[] TOKEN_ARRAY = new String[]{"http://vdb.metamatrix.com", "?vdbToken=true", "http://vdb.dataservice.metamatrix.com", "http://server.properies.metamatrix.com"};
    protected static final String WSDL_ERROR = "wsdlerror";
    protected static final String AMP = "&";
    protected static final String EQUALS = "=";
    private String dataServiceEndpoint = "";
    static Logger log = Logger.getLogger(MMGetVDBResourceServlet.class);

    public synchronized void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.dataServiceEndpoint = this.getServletContext().getInitParameter("endpointOverride");
        if (this.dataServiceEndpoint == null || this.dataServiceEndpoint.equals("")) {
            this.dataServiceEndpoint = "/services/service";
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Connection connection = null;
        resp.setContentType("text/html");
        resp.setHeader("wsdlerror", "wsdlerror");
        String serverURL = req.getParameter("ServerURL");
        String vdbName = req.getParameter("VDBName");
        String vdbVersion = req.getParameter("VDBVersion");
        String resourcePath = req.getPathInfo();
        try {
            MMGetVDBResourceServlet.checkFormValue((String)serverURL, (String)"ServerURL");
            MMGetVDBResourceServlet.checkFormValue((String)vdbName, (String)"VDBName");
            serverURL = serverURL + ";ApplicationName=" + SOAPPlugin.Util.getString("MMGetVDBResourceServlet.Application_Name");
        }
        catch (Exception e) {
            log.error((Object)e);
            resp.getOutputStream().println(e.getMessage());
            return;
        }
        try {
            connection = this.getConnection("teiidanonymous", "mmx", vdbName, vdbVersion, serverURL);
        }
        catch (Exception e) {
            String message = SOAPPlugin.Util.getString("ERR.018.002.0006");
            log.error((Object)message, (Throwable)e);
            resp.getOutputStream().println(message);
            return;
        }
        String suffix = this.buildEndpointSuffixString(req.getParameterMap());
        String urlPrefix = this.buildUrlPrefix(req);
        String servletPath = urlPrefix + "/servlet/ArtifactDocumentService";
        String result = this.escapeAttributeEntities(suffix);
        result = "?" + result;
        String endPointURL = null;
        endPointURL = urlPrefix + this.dataServiceEndpoint + result;
        StringBuffer serverProperties = new StringBuffer();
        serverProperties.append("VDBName").append("=").append(vdbName);
        serverProperties.append("&").append("ServerURL").append("=").append(serverURL.substring(0, serverURL.indexOf(";")));
        serverProperties.append("&").append("VDBVersion").append("=").append(vdbVersion != null ? vdbVersion : "");
        serverProperties.append("&");
        serverProperties = new StringBuffer(this.escapeAttributeEntities(serverProperties.toString()));
        try {
            this.getResource(resp, "{?=call System.getUpdatedCharacterVDBResource(?,?,?)}", resourcePath, servletPath, result, serverProperties.toString(), endPointURL, connection);
        }
        catch (SQLException se) {
            resp.getOutputStream().println(se.getMessage());
            log.error((Object)SOAPPlugin.Util.getString("MMGetVDBResourceServlet.7"), (Throwable)se);
        }
        catch (Exception e) {
            log.error((Object)SOAPPlugin.Util.getString("MMGetVDBResourceServlet.8"), (Throwable)e);
            resp.getOutputStream().println(e.getMessage());
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error((Object)SOAPPlugin.Util.getString("MMGetVDBResourceServlet.0"), (Throwable)e);
                resp.setHeader("wsdlerror", "wsdlerror");
                resp.getOutputStream().println(e.getMessage());
            }
        }
    }

    private String buildUrlPrefix(HttpServletRequest req) {
        StringBuffer urlPrefix = new StringBuffer();
        if (req.isSecure()) {
            urlPrefix.append("https").append("://").append(req.getServerName()).append(":").append(WSDLServletUtil.getHttpsPort());
        } else {
            urlPrefix.append("http").append("://").append(req.getServerName()).append(":").append(WSDLServletUtil.getHttpPort());
        }
        urlPrefix.append(req.getContextPath());
        return urlPrefix.toString();
    }

    public Connection getConnection(String userid, String password, String vdbName, String vdbVersion, String url) throws SQLException, ClassNotFoundException {
        Properties props = new Properties();
        props.put("user", userid);
        props.put("password", password);
        Class.forName("com.metamatrix.jdbc.MMDriver");
        return DriverManager.getConnection("jdbc:metamatrix:" + vdbName + "@" + url + (vdbVersion == null || vdbVersion.trim().length() == 0 ? "" : ";version=" + vdbVersion), props);
    }

    public void getResource(HttpServletResponse resp, String procString, String resourcePath, String urlPrefix, String urlSuffix, String serverProperites, String endPointURL, Connection connection) throws SQLException, IOException {
        int c;
        String[] value_Array = new String[]{urlPrefix, urlSuffix, endPointURL, serverProperites};
        CallableStatement statement = connection.prepareCall(procString);
        ResultSet rs = null;
        Clob clob = null;
        statement.setString(1, resourcePath);
        statement.setObject(2, (Object)TOKEN_ARRAY);
        statement.setObject(3, (Object)value_Array);
        boolean rtn = statement.execute();
        if (!rtn) {
            String message = SOAPPlugin.Util.getString("MMGetVDBResourceServlet.12");
            log.error((Object)message);
            resp.getOutputStream().println(message);
            return;
        }
        rs = statement.getResultSet();
        if (!rs.next()) {
            String message = SOAPPlugin.Util.getString("MMGetVDBResourceServlet.14");
            log.error((Object)message);
            resp.getOutputStream().println(message);
            return;
        }
        clob = rs.getClob(1);
        Reader reader = clob.getCharacterStream();
        StringWriter sw = new StringWriter();
        while ((c = reader.read()) != -1) {
            sw.write(c);
        }
        resp.setHeader("wsdlerror", null);
        resp.setContentType("text/xml");
        resp.getOutputStream().write(sw.getBuffer().toString().getBytes());
    }

    private static void checkFormValue(String parameter, String expectedParameterName) throws Exception {
        if (parameter == null || parameter.trim().length() == 0) {
            throw new Exception(SOAPPlugin.Util.getString("ERR.018.002.0004", new Object[]{expectedParameterName}));
        }
    }

    protected String escapeAttributeEntities(String st) {
        int i;
        StringBuffer buff = new StringBuffer();
        char[] block = st.toCharArray();
        String stEntity = null;
        int last = 0;
        for (i = 0; i < block.length; ++i) {
            switch (block[i]) {
                case '<': {
                    stEntity = "&lt;";
                    break;
                }
                case '>': {
                    stEntity = "&gt;";
                    break;
                }
                case '\"': {
                    stEntity = "&quot;";
                    break;
                }
                case '&': {
                    stEntity = "&amp;";
                    break;
                }
            }
            if (stEntity == null) continue;
            buff.append(block, last, i - last);
            buff.append(stEntity);
            stEntity = null;
            last = i + 1;
        }
        if (last < block.length) {
            buff.append(block, last, i - last);
        }
        return buff.toString();
    }

    protected String buildEndpointSuffixString(Map parameterMap) {
        String suffixString = "";
        Set keySet = parameterMap.keySet();
        for (Object key : keySet) {
            if (!(key instanceof String)) continue;
            String keyString = (String)key;
            if (!"".equals(suffixString)) {
                suffixString = suffixString + "&";
            }
            String parameterValue = "";
            String[] paramValueArray = (String[])parameterMap.get(keyString);
            if (paramValueArray.length > 0) {
                try {
                    parameterValue = URLEncoder.encode(((String[])parameterMap.get(keyString))[0], "UTF-8");
                }
                catch (UnsupportedEncodingException err) {
                    log.error((Object)SOAPPlugin.Util.getString("MMGetVDBResourceServlet.15", new Object[]{err}));
                }
            }
            suffixString = suffixString + keyString + "=" + parameterValue;
        }
        return suffixString;
    }

    public static String getScheme(boolean isSecure) {
        if (isSecure) {
            return "https";
        }
        return "http";
    }
}

