/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.servlet;

import com.metamatrix.common.util.WSDLServletUtil;
import com.metamatrix.soap.SOAPPlugin;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class WSDLURLGenerator
extends HttpServlet {
    static Logger log = Logger.getLogger(WSDLURLGenerator.class);

    public synchronized void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String servletPath;
        URL url;
        HttpURLConnection connection;
        String mmServerHostAndPortList = req.getParameter("MMServerHostAndPort");
        String vdbName = req.getParameter("VDBName");
        String vdbVersion = req.getParameter("VDBVersion");
        String targetHost = req.getParameter("TargetHost");
        String targetPort = req.getParameter("TargetPort");
        String scheme = req.getScheme();
        String appContext = req.getContextPath();
        List hostAndPortList = Collections.EMPTY_LIST;
        try {
            hostAndPortList = WSDLURLGenerator.checkHostAndPortFormValue((String)mmServerHostAndPortList, (String)"MMServerHostAndPort");
            WSDLURLGenerator.checkFormValue((String)vdbName, (String)"VDBName");
            WSDLURLGenerator.checkFormValue((String)targetHost, (String)"TargetHost");
        }
        catch (Exception e) {
            log.error((Object)e);
            resp.getOutputStream().println(e.getMessage());
            return;
        }
        ArrayList<String> mmServers = new ArrayList<String>(hostAndPortList.size());
        ArrayList<String> mmPorts = new ArrayList<String>(hostAndPortList.size());
        for (String hostAndPort : hostAndPortList) {
            int colonIndex = hostAndPort.indexOf(58);
            String mmServer = hostAndPort.substring(0, colonIndex);
            String mmPort = hostAndPort.substring(colonIndex + 1);
            if (!this.validateInteger(resp, mmPort, "ERR.018.002.0020")) {
                return;
            }
            mmServers.add(mmServer);
            mmPorts.add(mmPort);
        }
        if (targetPort != null && targetPort.length() > 0 && !this.validateInteger(resp, targetPort, "ERR.018.002.0020")) {
            return;
        }
        if (vdbVersion != null && vdbVersion.length() > 0 && !this.validateInteger(resp, vdbVersion, "ERR.018.002.0024")) {
            return;
        }
        String mmServerHost = null;
        try {
            for (int i = 0; i < mmServers.size(); ++i) {
                mmServerHost = (String)mmServers.get(i);
                new URL(scheme + "://" + mmServerHost + ":" + mmPorts.get(i));
            }
        }
        catch (MalformedURLException mue) {
            String message = SOAPPlugin.Util.getString("ERR.018.002.0021", new Object[]{mmServerHost});
            log.error((Object)message, (Throwable)mue);
            resp.getOutputStream().println(message);
            return;
        }
        ArrayList<String> serverURLs = new ArrayList<String>(mmServers.size());
        for (int i = 0; i < mmServers.size(); ++i) {
            String serverURL = URLEncoder.encode(this.getProtocol(req.getParameter("Secure")) + "://" + (String)mmServers.get(i) + ":" + (String)mmPorts.get(i), "UTF-8");
            if (i == 0) {
                serverURLs.add(serverURL);
                continue;
            }
            String serverAndPortStr = (String)mmServers.get(i) + ":" + (String)mmPorts.get(i);
            serverURLs.add(URLEncoder.encode(serverAndPortStr, "UTF-8"));
        }
        if (targetPort == null) {
            targetPort = "";
        }
        if ((connection = (HttpURLConnection)(url = new URL(servletPath = WSDLServletUtil.formatURL((String)scheme, (String)targetHost, (String)targetPort, (String)appContext, serverURLs, (String)vdbName, (String)vdbVersion))).openConnection()) == null || "wsdlerror".equals(connection.getHeaderField("wsdlerror"))) {
            StringBuffer error = new StringBuffer();
            InputStreamReader reader = new InputStreamReader(connection.getInputStream());
            try {
                int c;
                while ((c = reader.read()) != -1) {
                    error.append((char)c);
                }
                String message = SOAPPlugin.Util.getString("ERR.018.002.0022", new Object[]{servletPath, error.toString()});
                log.error((Object)message);
                resp.getOutputStream().println(message);
            }
            finally {
                reader.close();
            }
            return;
        }
        resp.getOutputStream().println("<a href='" + servletPath + "'>" + servletPath + "</a>");
    }

    private boolean validateInteger(HttpServletResponse resp, String integer, String error_key) throws IOException {
        try {
            int port = Integer.parseInt(integer);
            if (port < 0) {
                throw new NumberFormatException(SOAPPlugin.Util.getString("ERR.018.002.0023"));
            }
        }
        catch (NumberFormatException nfe) {
            String message = SOAPPlugin.Util.getString(error_key, new Object[]{integer});
            log.error((Object)message, (Throwable)nfe);
            resp.getOutputStream().println(message);
            return false;
        }
        return true;
    }

    private String getProtocol(String secure) {
        if (secure != null && secure.equals("Secure")) {
            return "mms";
        }
        return "mm";
    }

    private static void checkFormValue(String parameter, String expectedParameterName) throws Exception {
        if (parameter == null || parameter.trim().length() == 0) {
            throw new Exception(SOAPPlugin.Util.getString("ERR.018.002.0004", new Object[]{expectedParameterName}));
        }
    }

    private static List checkHostAndPortFormValue(String parameter, String expectedParameterName) throws Exception {
        ArrayList<String> hostPortList = new ArrayList<String>();
        if (parameter == null || parameter.trim().length() == 0) {
            throw new Exception(SOAPPlugin.Util.getString("ERR.018.002.0004", new Object[]{expectedParameterName}));
        }
        StringTokenizer st = new StringTokenizer(parameter, ",", false);
        while (st.hasMoreTokens()) {
            String hostPortToken = st.nextToken();
            if (hostPortToken == null || hostPortToken.trim().length() == 0) continue;
            String hostPortStr = hostPortToken.trim();
            if (hostPortStr.indexOf(58) == -1) {
                throw new Exception(SOAPPlugin.Util.getString("ERR.018.002.0025", new Object[]{hostPortToken}));
            }
            hostPortList.add(hostPortStr);
        }
        if (hostPortList.isEmpty()) {
            throw new Exception(SOAPPlugin.Util.getString("ERR.018.002.0026"));
        }
        return hostPortList;
    }
}

