/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.sqlquerywebservice.service;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.dqp.client.impl.ServerRequest;
import com.metamatrix.jdbc.MMCallableStatement;
import com.metamatrix.jdbc.MMPreparedStatement;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.api.ResultSetMetaData;
import com.metamatrix.jdbc.api.SQLStates;
import com.metamatrix.jdbc.api.Statement;
import com.metamatrix.soap.security.Credential;
import com.metamatrix.soap.service.ConnectionSource;
import com.metamatrix.soap.service.PoolingConnectionSource;
import com.metamatrix.soap.sqlquerywebservice.helper.Cell;
import com.metamatrix.soap.sqlquerywebservice.helper.ColumnMetadata;
import com.metamatrix.soap.sqlquerywebservice.helper.ConnectionlessRequest;
import com.metamatrix.soap.sqlquerywebservice.helper.Data;
import com.metamatrix.soap.sqlquerywebservice.helper.LogInParameters;
import com.metamatrix.soap.sqlquerywebservice.helper.RequestInfo;
import com.metamatrix.soap.sqlquerywebservice.helper.Results;
import com.metamatrix.soap.sqlquerywebservice.helper.Row;
import com.metamatrix.soap.sqlquerywebservice.helper.SqlWarning;
import com.metamatrix.soap.sqlquerywebservice.log.LogUtil;
import com.metamatrix.soap.sqlquerywebservice.service.SqlQueryWebService;
import com.metamatrix.soap.sqlquerywebservice.service.SqlQueryWebServiceFault;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Properties;

public class SqlQueryWebService {
    public static final String APP_NAME = "SQL Query Web Service";
    private ConnectionSource connectionSource = PoolingConnectionSource.getInstance();
    private CredentialProvider credentialProvider = new /* Unavailable Anonymous Inner Class!! */;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results executeBlocking(ConnectionlessRequest connectionlessRequest) throws SqlQueryWebServiceFault {
        Connection conn = null;
        Results results = null;
        MMPreparedStatement stmt = null;
        try {
            Properties connectionProperties = this.getConnectionInfo(connectionlessRequest.getParameters());
            conn = this.connectionSource.getConnection(connectionProperties);
            ServerRequest request = this.getRequestInfo(connectionlessRequest);
            if (request.getRequestType() == 1) {
                MMPreparedStatement pStmt;
                stmt = pStmt = conn.prepareStatement(request.getSql(), request.getCursorType(), 1007).unwrap(MMPreparedStatement.class);
                this.setParameterValues(request, pStmt);
            } else if (request.getRequestType() == 2) {
                MMCallableStatement cStmt = conn.prepareCall(request.getSql(), request.getCursorType(), 1007).unwrap(MMCallableStatement.class);
                stmt = cStmt;
                this.setParameterValues(request, (MMPreparedStatement)cStmt);
            } else {
                stmt = (Statement)conn.createStatement(request.getCursorType(), 1007).unwrap(MMStatement.class);
            }
            if (connectionlessRequest.getMaxRowsReturned() > 0) {
                stmt.setMaxRows(connectionlessRequest.getMaxRowsReturned());
            }
            if (request.getFetchSize() > 0) {
                stmt.setFetchSize(request.getFetchSize());
            }
            if (connectionlessRequest.getTimeToWait() > 0) {
                stmt.setQueryTimeout(connectionlessRequest.getTimeToWait() / 1000);
            }
            stmt.setExecutionProperty("planNotAllowed", Boolean.TRUE.toString());
            if (request.getXMLStyleSheet() != null) {
                try {
                    stmt.attachStylesheet((Reader)new StringReader(request.getXMLStyleSheet()));
                }
                catch (IOException e) {
                    this.throwFaultException(true, (Throwable)e);
                }
            }
            stmt.setExecutionProperty("partialResultsMode", String.valueOf(request.getPartialResults()));
            stmt.setExecutionProperty("XMLValidation", String.valueOf(request.getXMLValidationMode()));
            stmt.setExecutionProperty("Tree", String.valueOf(request.getXMLFormat()));
            int transactionAutowrap = request.getTransactionAutoWrapMode();
            String autowrap = null;
            switch (transactionAutowrap) {
                case 0: {
                    autowrap = "OFF";
                    break;
                }
                case 1: {
                    autowrap = "ON";
                    break;
                }
                case 2: {
                    autowrap = "OPTIMISTIC";
                    break;
                }
                case 3: {
                    autowrap = "PESSIMISTIC";
                    break;
                }
                default: {
                    this.throwFaultException(true, (Throwable)new MetaMatrixProcessingException(AdminPlugin.Util.getString("ServerFacadeImpl.invalid_txnautowrap", new Object[]{transactionAutowrap})));
                }
            }
            stmt.setExecutionProperty("txnAutoWrap", autowrap);
            stmt.setExecutionProperty("resultSetCacheMode", String.valueOf(request.getUseResultSetCache()));
            ResultSet rs = null;
            if (request.getRequestType() == 1 || request.getRequestType() == 1) {
                if (((PreparedStatement)stmt).execute()) {
                    rs = stmt.getResultSet();
                }
            } else if (stmt.execute(request.getSql())) {
                rs = stmt.getResultSet();
            }
            results = this.buildResults((Statement)stmt, rs, connectionlessRequest, connectionlessRequest.isIncludeMetadata());
        }
        catch (SQLException e) {
            this.throwFaultException(e.getSQLState() == null ? true : SQLStates.isUsageErrorState((String)e.getSQLState()), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return results;
    }

    private void setParameterValues(ServerRequest request, MMPreparedStatement pStmt) throws SQLException {
        Object[] params = request.getBindParameters();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                pStmt.setObject(i + 1, params[i]);
            }
        }
    }

    private Properties getConnectionInfo(LogInParameters params) throws SqlQueryWebServiceFault {
        Properties connectionInfo = new Properties();
        if (params.getMmServerUrl() != null) {
            connectionInfo.setProperty("serverURL", params.getMmServerUrl());
        }
        if (params.getVdbName() != null) {
            connectionInfo.setProperty("VirtualDatabaseName", params.getVdbName());
        }
        if (params.getVdbVersion() != null) {
            connectionInfo.setProperty("VirtualDatabaseVersion", params.getVdbVersion());
        }
        if (params.getConnectionPayload() != null) {
            connectionInfo.setProperty("clientToken", params.getConnectionPayload());
        }
        connectionInfo.setProperty("ApplicationName", APP_NAME);
        if (params.getOptionalProperties() != null) {
            for (int i = 0; i < params.getOptionalProperties().length; ++i) {
                String propName = params.getOptionalProperties()[i].getPropertyName();
                String propValue = params.getOptionalProperties()[i].getPropertyValue();
                connectionInfo.setProperty(propName, propValue);
            }
        }
        Credential credential = this.credentialProvider.getCredentials();
        connectionInfo.setProperty("user", credential.getUserName());
        connectionInfo.setProperty("password", new String(credential.getPassword()));
        return connectionInfo;
    }

    private ServerRequest getRequestInfo(ConnectionlessRequest request) {
        RequestInfo info = request.getRequestInfo();
        ServerRequest domainInfo = new ServerRequest();
        domainInfo.setBindParameters((Object[])info.getBindParameters());
        domainInfo.setCommandPayload((Serializable)((Object)info.getCommandPayload()));
        domainInfo.setCursorType(Integer.parseInt(info.getCursorType().getValue()));
        domainInfo.setFetchSize(info.getFetchSize());
        domainInfo.setPartialResults(info.isPartialResults());
        domainInfo.setRequestType(Integer.parseInt(info.getRequestType().getValue()));
        domainInfo.setSql(info.getSqlString());
        domainInfo.setTransactionAutoWrapMode(Integer.parseInt(info.getTransactionAutoWrapMode().getValue()));
        domainInfo.setUseResultSetCache(info.isUseResultSetCache());
        domainInfo.setXMLFormat(info.getXmlFormat());
        domainInfo.setXMLStyleSheet(info.getXmlStyleSheet());
        domainInfo.setXMLValidationMode(info.isXmlValidationMode());
        return domainInfo;
    }

    protected Results buildResults(Statement stmt, ResultSet rs, ConnectionlessRequest request, boolean includeMetadata) throws SQLException {
        Results soapResults = new Results();
        this.getData(soapResults, rs, includeMetadata);
        soapResults.setSqlWarnings(this.getWarnings(stmt.getWarnings()));
        soapResults.setUpdateCount(Integer.valueOf(stmt.getUpdateCount()));
        soapResults.setOutputParameters(this.getOutputParameters(stmt));
        return soapResults;
    }

    private SqlWarning[] getWarnings(SQLWarning warning) {
        if (warning == null) {
            return new SqlWarning[]{new SqlWarning()};
        }
        ArrayList<SqlWarning> warnings = new ArrayList<SqlWarning>();
        do {
            SqlWarning toAdd = new SqlWarning();
            toAdd.setMessage(warning.getMessage());
            warnings.add(toAdd);
        } while ((warning = warning.getNextWarning()) != null);
        return (SqlWarning[])warnings.toArray();
    }

    private String[] getOutputParameters(Statement stmt) throws SQLException {
        String[] result = null;
        if (stmt instanceof CallableStatement) {
            CallableStatement cs = (CallableStatement)stmt;
            ParameterMetaData metadata = cs.getParameterMetaData();
            int count = metadata.getParameterCount();
            ArrayList<String> outputParametersList = new ArrayList<String>();
            for (int k = 1; k <= count; ++k) {
                int parameterType = metadata.getParameterType(k);
                if (parameterType != 4 && parameterType != 2) continue;
                outputParametersList.add(cs.getString(k));
            }
            result = (String[])outputParametersList.toArray();
        }
        if (result == null || result.length == 0) {
            return new String[]{"none"};
        }
        return result;
    }

    private void getData(Results soapResults, ResultSet rs, boolean includeMetadata) throws SQLException {
        Data data = new Data();
        soapResults.setBeginRow(Integer.valueOf(0));
        data.setLast(true);
        Row[] rowArray = null;
        int rowCounter = 0;
        if (rs != null) {
            soapResults.setHasData(true);
            ResultSetMetaData metadata = rs.getMetaData().unwrap(ResultSetMetaData.class);
            if (includeMetadata) {
                data.setMetadataArray(this.getColumnMetaData(metadata));
            }
            ArrayList<Row> rows = new ArrayList<Row>();
            while (rs.next()) {
                Row row = new Row();
                Cell[] cellArray = new Cell[metadata.getColumnCount()];
                for (int j = 1; j <= cellArray.length; ++j) {
                    Cell cell = new Cell();
                    String value = rs.getString(j);
                    cell.setValue(value);
                    cellArray[j - 1] = cell;
                }
                row.setCells(cellArray);
                rows.add(row);
                ++rowCounter;
            }
            rowArray = (Row[])rows.toArray();
        }
        soapResults.setEndRow(Integer.valueOf(rowCounter));
        if (rowCounter == 0) {
            Row emptyRow = new Row();
            rowArray = new Row[]{emptyRow};
            Cell emptyCell = new Cell();
            emptyRow.setCells(new Cell[]{emptyCell});
        }
        data.setRows(rowArray);
        soapResults.setData(data);
    }

    private ColumnMetadata[] getColumnMetaData(ResultSetMetaData metadata) throws SQLException {
        int columnCount = metadata.getColumnCount();
        ColumnMetadata[] metadataArray = new ColumnMetadata[columnCount];
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            ColumnMetadata columnMetadata = new ColumnMetadata();
            columnMetadata.setColumnName(metadata.getColumnName(i));
            columnMetadata.setColumnDataType(metadata.getColumnTypeName(i));
            columnMetadata.setColumnClassName(metadata.getColumnClassName(i));
            columnMetadata.setColumnDisplaySize(metadata.getColumnDisplaySize(i));
            columnMetadata.setCurrency(metadata.isCurrency(i));
            columnMetadata.setGetColumnLabel(metadata.getColumnLabel(i));
            columnMetadata.setNullable(metadata.isNullable(i) == 1);
            columnMetadata.setPrecision(metadata.getPrecision(i));
            columnMetadata.setReadOnly(metadata.isReadOnly(i));
            columnMetadata.setScale(metadata.getScale(i));
            columnMetadata.setSearchable(metadata.isSearchable(i));
            columnMetadata.setSigned(metadata.isSigned(i));
            columnMetadata.setTableName(metadata.getTableName(i));
            columnMetadata.setVirtualDatabaseName(metadata.getVirtualDatabaseName(i));
            columnMetadata.setVirtualDatabaseVersion(metadata.getVirtualDatabaseVersion(i));
            metadataArray[i - 1] = columnMetadata;
        }
        return metadataArray;
    }

    private void throwFaultException(boolean client, Throwable e) throws SqlQueryWebServiceFault {
        SqlQueryWebServiceFault fault = SqlQueryWebServiceFault.create((boolean)client, (Throwable)e);
        LogUtil.log((int)2, (Throwable)e, (String)e.getMessage());
        throw fault;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    public void setCredentialProvider(CredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    static /* synthetic */ void access$000(SqlQueryWebService x0, boolean x1, Throwable x2) throws SqlQueryWebServiceFault {
        x0.throwFaultException(x1, x2);
    }
}

