/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.util;

import com.metamatrix.soap.exceptions.SOAPProcessingException;
import com.metamatrix.soap.service.DataServiceInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.axis2.context.MessageContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class EndpointUriTranslatorStrategyImpl {
    private static final String URL_PREFIX = "jdbc:metamatrix:";
    private static final String URL_AT = "@";
    private static final String URL_SUFFIX = ";version=";
    private static final String soapEncoding = "UTF-8";

    public static DataServiceInfo getDataServiceInfo() throws SOAPProcessingException {
        DataServiceInfo info = new DataServiceInfo();
        MessageContext context = MessageContext.getCurrentMessageContext();
        Map map = (Map)context.getProperty("endpointURI");
        String vdbContextualWebServiceName = (String)map.get("procedure");
        info.setDataServiceFullPath(vdbContextualWebServiceName);
        String serverUrl = (String)map.get("ServerURL");
        String vdbName = (String)map.get("VDBName");
        String vdbVersion = (String)map.get("VDBVersion");
        String additionalProps = (String)map.get("AddExecProperties");
        String jdbcUrl = EndpointUriTranslatorStrategyImpl.createJdbcUrl((String)serverUrl, (String)(vdbName == null ? null : vdbName), (String)(vdbVersion == null ? null : vdbVersion), (String)(additionalProps == null ? null : additionalProps));
        info.setServerURL(jdbcUrl);
        return info;
    }

    protected static String createJdbcUrl(String serverUrl, String vdbName, String vdbVersion, String additionalProps) throws SOAPProcessingException {
        StringBuffer result = new StringBuffer();
        try {
            result = new StringBuffer("jdbc:metamatrix:").append(URLDecoder.decode(vdbName, "UTF-8")).append("@").append(URLDecoder.decode(serverUrl, "UTF-8"));
            if (vdbVersion != null) {
                result.append(";version=").append(vdbVersion);
            }
            if (additionalProps != null) {
                result.append(';').append(URLDecoder.decode(additionalProps, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SOAPProcessingException((Throwable)e);
        }
        return result.toString();
    }
}

