/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.xa.arjuna;

import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.teiid.dqp.internal.transaction.TransactionProvider;

public class XAConnectorRecovery
implements XAResourceRecovery {
    private static Map<String, TransactionProvider.XAConnectionSource> resourceRegistry = Collections.synchronizedMap(new HashMap());
    private Iterator connectorIter = null;
    private Map<String, TransactionProvider.XAConnectionSource> connectionsHeld = new HashMap<String, TransactionProvider.XAConnectionSource>();

    public XAResource getXAResource() throws SQLException {
        Map<String, TransactionProvider.XAConnectionSource> map = resourceRegistry;
        synchronized (map) {
            String connectorName = (String)this.connectorIter.next();
            TransactionProvider.XAConnectionSource conn = null;
            try {
                conn = this.connectionsHeld.get(connectorName);
                if (conn == null) {
                    conn = resourceRegistry.get(connectorName);
                    this.connectionsHeld.put(connectorName, conn);
                }
                return conn.getXAResource();
            }
            catch (SQLException e) {
                if (conn != null) {
                    conn.close();
                    this.connectionsHeld.remove(connectorName);
                }
                throw new SQLException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreResources() {
        boolean hasNext = false;
        Map<String, TransactionProvider.XAConnectionSource> map = resourceRegistry;
        synchronized (map) {
            if (this.connectorIter != null) {
                hasNext = this.connectorIter.hasNext();
            }
            if (!hasNext) {
                HashMap<String, TransactionProvider.XAConnectionSource> map2 = new HashMap<String, TransactionProvider.XAConnectionSource>(resourceRegistry);
                this.connectorIter = map2.keySet().iterator();
            }
        }
        return hasNext;
    }

    public boolean initialise(String p) throws SQLException {
        return true;
    }

    public static void addConnector(String name, TransactionProvider.XAConnectionSource connector) {
        resourceRegistry.put(name, connector);
    }

    public static void removeConnector(String name) {
        resourceRegistry.remove(name);
    }
}

