/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.audit.report;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.test.audit.report.AuditAssertion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuditParser {
    private String version;
    private Map<String, List<AuditAssertion>> assertions = new HashMap<String, List<AuditAssertion>>();
    private Map<String, String> titles = new HashMap<String, String>();
    private InputStream source;

    public AuditParser(InputStream source) {
        this.source = source;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSectionTitle(String sectionId) {
        return this.titles.get(sectionId);
    }

    public Map<String, List<AuditAssertion>> getAssertions() {
        return this.assertions;
    }

    public List<String> getSectionIds() {
        ArrayList<String> sectionIds = new ArrayList<String>(this.assertions.keySet());
        Collections.sort(sectionIds, new Comparator<String>(){

            @Override
            public int compare(String value1, String value2) {
                String[] parts1 = value1.split("[.]");
                String[] parts2 = value2.split("[.]");
                int i = 0;
                while (true) {
                    block6: {
                        if (parts1.length < i + 1) {
                            return parts2.length < i + 1 ? 0 : 0;
                        }
                        if (parts2.length < i + 1) {
                            return parts1.length < i + 1 ? 0 : 1;
                        }
                        try {
                            int val1 = Integer.parseInt(parts1[i]);
                            int val2 = Integer.parseInt(parts2[i]);
                            if (val1 != val2) {
                                return val1 - val2;
                            }
                        }
                        catch (NumberFormatException ex) {
                            int comp = parts1[i].compareTo(parts2[i]);
                            if (comp == 0) break block6;
                            return comp;
                        }
                    }
                    ++i;
                }
            }
        });
        return sectionIds;
    }

    public List<AuditAssertion> getAssertionsForSection(String sectionId) {
        ArrayList<AuditAssertion> sectionAssertions = new ArrayList<AuditAssertion>((Collection)this.assertions.get(sectionId));
        Collections.sort(sectionAssertions);
        return sectionAssertions;
    }

    public boolean hasAssertion(String sectionId, String assertionId) {
        if (!this.assertions.containsKey(sectionId)) {
            return false;
        }
        for (AuditAssertion assertion : this.assertions.get(sectionId)) {
            if (!assertion.getId().equals(assertionId)) continue;
            return true;
        }
        return false;
    }

    public void parse() throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(this.source);
        NodeList sectionNodes = doc.getDocumentElement().getChildNodes();
        this.version = doc.getDocumentElement().getAttribute("version");
        for (int i = 0; i < sectionNodes.getLength(); ++i) {
            if (!(sectionNodes.item(i) instanceof Element) || !"section".equals(sectionNodes.item(i).getNodeName())) continue;
            this.processSectionNode((Element)sectionNodes.item(i));
        }
    }

    private void processSectionNode(Element node) {
        String sectionId = node.getAttribute("id");
        this.titles.put(sectionId, node.getAttribute("title"));
        this.assertions.put(sectionId, new ArrayList());
        NodeList assertionNodes = node.getChildNodes();
        for (int i = 0; i < assertionNodes.getLength(); ++i) {
            if (!(assertionNodes.item(i) instanceof Element) || !"assertion".equals(assertionNodes.item(i).getNodeName())) continue;
            this.processAssertionNode(sectionId, (Element)assertionNodes.item(i));
        }
    }

    private void processAssertionNode(String sectionId, Element node) {
        List<AuditAssertion> value = this.assertions.get(sectionId);
        String text = null;
        String note = null;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            if (!(child instanceof Element)) continue;
            if ("text".equals(child.getNodeName())) {
                text = child.getTextContent();
                continue;
            }
            if (!"note".equals(child.getNodeName())) continue;
            note = child.getTextContent();
        }
        boolean testable = node.hasAttribute("testable") ? Boolean.parseBoolean(node.getAttribute("testable")) : true;
        boolean implied = node.hasAttribute("implied") ? Boolean.parseBoolean(node.getAttribute("implied")) : false;
        value.add(new AuditAssertion(sectionId, node.getAttribute("id"), text, note, testable, implied));
    }
}

