/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.audit.report;

import java.util.List;
import org.jboss.test.audit.report.ColourGradient;
import org.jboss.test.audit.report.SeriesGenerator;

public class BarChartGenerator {
    private String fromColour;
    private String toColour;
    private List<SeriesGenerator.SeriesElement> values;
    private int chartHeight = 60;
    private int barWidth = 16;

    public BarChartGenerator(String fromColour, String toColour, List<SeriesGenerator.SeriesElement> values) {
        this.fromColour = fromColour;
        this.toColour = toColour;
        this.values = values;
    }

    public String generate() {
        int chartWidth = this.barWidth * this.values.size() + this.values.size();
        StringBuilder sb = new StringBuilder();
        sb.append("<div style=\"width:" + chartWidth + "px;height:" + this.chartHeight + "px;border:1px solid #000000\">\n");
        double highest = 0.0;
        int highestPosition = 0;
        for (int i = 0; i < this.values.size(); ++i) {
            if (!((double)this.values.get(i).getValue() > highest)) continue;
            highest = this.values.get(i).getValue();
            highestPosition = i;
        }
        List<String> gradient = new ColourGradient(this.fromColour, this.toColour).calculateGradient(highestPosition + 1);
        List<String> downGradient = new ColourGradient(this.toColour, this.fromColour).calculateGradient(this.values.size() - highestPosition + 1);
        gradient.addAll(downGradient.subList(1, downGradient.size()));
        for (int i = 0; i < this.values.size(); ++i) {
            double val = this.values.get(i).getValue();
            long pixels = val == 0.0 ? (long)this.chartHeight : Math.round((double)this.chartHeight * 1.0 - val * 1.0 / (highest * 1.0) * (0.9 * (double)this.chartHeight));
            String title = String.format("%.1f%% to %.1f%% coverage - %d sections", this.values.get(i).getRangeFrom(), this.values.get(i).getRangeTo(), this.values.get(i).getValue());
            sb.append("  <div title=\"" + title + "\" style=\"float:left;border-right:1px solid #eeeeee;width:" + this.barWidth + "px;height:" + this.chartHeight + "px;background-color:" + gradient.get(i) + "\">\n");
            sb.append("    <div style=\"background-color:#ffffff;height:" + pixels + "px\">&nbsp;</div>\n");
            sb.append("  </div>\n");
        }
        sb.append("</div>\n");
        return sb.toString();
    }
}

