/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.audit.report;

import java.util.Comparator;
import java.util.List;

public class Method {
    public static final Comparator<Method> COMPARATOR = new MethodComparator();
    private final String packageName;
    private final String className;
    private final String methodName;
    private final List<String> groups;

    public Method(String packageName, String className, String methodName, List<String> groups) {
        this.packageName = packageName;
        this.className = className;
        this.methodName = methodName;
        this.groups = groups;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Method) {
            Method that = (Method)obj;
            return this.getPackageName().equals(that.getPackageName()) && this.getClassName().equals(that.getClassName()) && this.getMethodName().equals(that.getMethodName());
        }
        return false;
    }

    public int hashCode() {
        return this.getPackageName().hashCode() + this.getClassName().hashCode() + this.getMethodName().hashCode();
    }

    public String getFqn() {
        return this.packageName + "." + this.className + "." + this.methodName;
    }

    private static class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method arg0, Method arg1) {
            return arg0.getFqn().compareToIgnoreCase(arg1.getFqn());
        }
    }
}

