/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.audit.report;

import java.util.ArrayList;
import java.util.List;

public class SeriesGenerator {
    private List<Double> values = new ArrayList<Double>();

    public void addValue(Double value) {
        this.values.add(value);
    }

    public List<SeriesElement> getSeries(int bandSize, int total) {
        ArrayList<SeriesElement> series = new ArrayList<SeriesElement>();
        for (int i = 0; i < total; ++i) {
            float rangeFrom = i * bandSize;
            float rangeTo = rangeFrom + (float)bandSize;
            int count = 0;
            for (Double value : this.values) {
                if (!(value >= (double)rangeFrom) || !(value < (double)rangeTo) && (i != total - 1 || !(value <= (double)rangeTo))) continue;
                ++count;
            }
            series.add(new SeriesElement(rangeFrom, rangeTo, count));
        }
        return series;
    }

    public class SeriesElement {
        private int value;
        private double rangeFrom;
        private double rangeTo;

        public SeriesElement(double rangeFrom, double rangeTo, int value) {
            this.rangeFrom = rangeFrom;
            this.rangeTo = rangeTo;
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public double getRangeFrom() {
            return this.rangeFrom;
        }

        public double getRangeTo() {
            return this.rangeTo;
        }
    }
}

