/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.audit.config;

import java.io.IOException;
import java.net.URL;
import org.jboss.test.audit.config.EnumerationIterable;
import org.jboss.test.audit.config.ResourceLoadingException;

class SimpleResourceLoader {
    SimpleResourceLoader() {
    }

    public Class<?> classForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException(e);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException(e);
        }
    }

    public URL getResource(String name) {
        return this.getClass().getResource(name);
    }

    public Iterable<URL> getResources(String name) {
        try {
            return new EnumerationIterable<URL>(this.getClass().getClassLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException(e);
        }
    }
}

