/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.properties;

import java.io.IOException;
import java.net.URL;
import org.jboss.testharness.properties.EnumerationIterable;
import org.jboss.testharness.properties.ResourceLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleResourceLoader {
    SimpleResourceLoader() {
    }

    public Class<?> classForName(String name) {
        try {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException(e);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException(e);
        }
    }

    public URL getResource(String name) {
        return this.getClass().getResource(name);
    }

    public Iterable<URL> getResources(String name) {
        try {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return new EnumerationIterable<URL>(Thread.currentThread().getContextClassLoader().getResources(name));
            }
            return new EnumerationIterable<URL>(this.getClass().getClassLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException(e);
        }
    }
}

