/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.integration.jbossas;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.testharness.api.DeploymentException;
import org.jboss.testharness.integration.jbossas.JBossASConnector;
import org.jboss.virtual.VFS;

public class ProfileServiceConnector
extends JBossASConnector {
    private Logger log = Logger.getLogger(ProfileServiceConnector.class);
    public static final String MAX_DEPLOYMENTS_PROPERTY_NAME = "max.deployments.restart";
    private final List<String> failedUndeployments;
    private DeploymentManager deploymentManager;
    private final File tmpdir = new File(System.getProperty("java.io.tmpdir"), "org.jboss.webbeans.tck.integration.jbossas");
    private int deploymentCounter = 0;
    private Integer maxDeployments;
    private Boolean forceRestart;

    public ProfileServiceConnector() throws Exception {
        this.tmpdir.mkdir();
        this.tmpdir.deleteOnExit();
        this.failedUndeployments = new ArrayList<String>();
    }

    public void setup() throws IOException {
        super.setup();
        try {
            this.initDeploymentManager();
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void deploy(InputStream archiveStream, String name) throws DeploymentException, IOException {
        if (this.deploymentManager == null) {
            throw new IllegalStateException("setup() has not been called!");
        }
        Exception failure = null;
        try {
            File archive = new File(this.tmpdir, name);
            archive.deleteOnExit();
            ProfileServiceConnector.copy((InputStream)archiveStream, (File)archive);
            DeploymentProgress distribute = this.deploymentManager.distribute(name, ManagedDeployment.DeploymentPhase.APPLICATION, archive.toURI().toURL(), true);
            distribute.run();
            DeploymentProgress progress = this.deploymentManager.start(ManagedDeployment.DeploymentPhase.APPLICATION, new String[]{name});
            progress.run();
            DeploymentStatus status = progress.getDeploymentStatus();
            if (status.isFailed()) {
                failure = status.getFailure();
                this.doUndeploy(name);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        if (failure != null) {
            if (failure.getCause() instanceof IncompleteDeploymentException) {
                IncompleteDeploymentException incompleteDeploymentException = (IncompleteDeploymentException)failure.getCause();
                for (Map.Entry entry : incompleteDeploymentException.getIncompleteDeployments().getContextsInError().entrySet()) {
                    if (!((String)entry.getKey()).endsWith(name + "/_WebBeansBootstrapBean")) continue;
                    throw new DeploymentException((Throwable)entry.getValue());
                }
            }
            throw new DeploymentException((Throwable)failure);
        }
    }

    private void doUndeploy(String name) throws IOException {
        try {
            DeploymentProgress stopProgress = this.deploymentManager.stop(ManagedDeployment.DeploymentPhase.APPLICATION, new String[]{name});
            stopProgress.run();
            DeploymentProgress undeployProgress = this.deploymentManager.undeploy(ManagedDeployment.DeploymentPhase.APPLICATION, new String[]{name});
            undeployProgress.run();
            if (undeployProgress.getDeploymentStatus().isFailed()) {
                this.failedUndeployments.add(name);
            } else {
                ++this.deploymentCounter;
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(String name) throws IOException {
        try {
            this.doUndeploy(name);
        }
        finally {
            if (this.deploymentCounter >= this.getMaxDeployments()) {
                this.forceRestart = true;
                this.deploymentCounter = 0;
                this.removeFailedUnDeployments();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.restartServer();
                try {
                    this.initDeploymentManager();
                }
                catch (Exception e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
            }
        }
    }

    protected void initDeploymentManager() throws Exception {
        String profileName = "default";
        InitialContext ctx = new InitialContext();
        ProfileService ps = (ProfileService)ctx.lookup("ProfileService");
        this.deploymentManager = ps.getDeploymentManager();
        ProfileKey defaultKey = new ProfileKey(profileName);
        this.deploymentManager.loadProfile(defaultKey, false);
        VFS.init();
    }

    public void cleanup() throws IOException {
        this.removeFailedUnDeployments();
        super.cleanup();
    }

    private void removeFailedUnDeployments() throws IOException {
        ArrayList<String> remainingDeployments = new ArrayList<String>();
        for (String name : this.failedUndeployments) {
            try {
                DeploymentProgress undeployProgress = this.deploymentManager.undeploy(ManagedDeployment.DeploymentPhase.APPLICATION, new String[]{name});
                undeployProgress.run();
                if (!undeployProgress.getDeploymentStatus().isFailed()) continue;
                remainingDeployments.add(name);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (remainingDeployments.size() > 0) {
            // empty if block
        }
        this.failedUndeployments.clear();
    }

    protected String getMaxDeploymentsPropertyName() {
        return MAX_DEPLOYMENTS_PROPERTY_NAME;
    }

    protected Integer getMaxDeployments() {
        if (this.maxDeployments == null) {
            this.maxDeployments = this.getProperties().getIntValue(this.getMaxDeploymentsPropertyName(), 25, false);
        }
        return this.maxDeployments;
    }

    protected Boolean getForceRestart() {
        if (this.forceRestart == null) {
            return super.getForceRestart();
        }
        return this.forceRestart;
    }
}

